(ns ch.codesmith.blocks.aero
  (:require [aero.core :as aero]
            [ch.codesmith.blocks :as cb]
            [clojure.java.io :as io]))

(defn aero [_ {:keys [file resource ::cb/environment]}]
  {::cb/instance (aero/read-config (if-let [file (io/file file)]
                                     (if (.exists file)
                                       file
                                       (throw (ex-info (str "file " file " does not exists") {:file file})))
                                     (io/resource (or resource "config.edn")))
                                   {:profile environment})})
