(ns ch.codesmith.blocks.dev
  (:require [ch.codesmith.blocks.core :as cb]
            [ch.codesmith.blocks.dev.state :as cbds]
            [ch.codesmith.blocks.system-values :as cbsv]))

(defn halt! []
  (alter-var-root #'cbds/system (fn [system]
                                  (when system
                                    (cb/stop-system! system))
                                  nil)))

(defn go! [config]
  (halt!)
  (alter-var-root #'cbds/system (constantly (cb/new-system config)))
  :done)

(defn block
  ([factory]
   (block factory {}))
  ([factory dynamic-args]
   (cb/block cbds/system factory dynamic-args)))

(defn ensure-block-stopped!
  ([factory]
   (ensure-block-stopped! factory {}))
  ([factory dynamic-args]
   (cb/ensure-block-stopped! cbds/system factory dynamic-args)))

(defn sysval
  ([value-spec]
   (sysval value-spec {}))
  ([value-spec dynamic-args]
   (cbsv/resolve-system-value cbds/system value-spec dynamic-args)))

(defn project-system [update-dynamic-args]
  (cb/project-system cbds/system update-dynamic-args))

(defn project-system-with-common [common-dynamic-args]
  (cb/project-system-with-common cbds/system common-dynamic-args))
