(ns ch.codesmith.blocks.dev
  (:require [ch.codesmith.blocks :as cb]
            [integrant.repl :as ir]
            [integrant.repl.state :as irs]))

(defn set-prep! [system profile]
  (ir/set-prep! (constantly
                  (-> (cb/system->ig system profile)
                      cb/derive-all-blocks))))

(defn go
  ([] (go nil))
  ([keys]
   (ir/go keys)))

(defn clear []
  (ir/clear))

(defn halt []
  (ir/halt))

(defn suspend []
  (ir/suspend))

(defn resume []
  (ir/resume))

(defn reset []
  (ir/reset))

(defn reset-all []
  (ir/reset-all))

(defn get-block [block-key]
  (cb/get-block irs/system block-key))

(defn resolve-block [block-key]
  (cb/resolve-block irs/system block-key))