(ns ch.codesmith.blocks.dev
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.dev.state :as cbds]
            [integrant.core :as ig]))


(defn halt []
  (alter-var-root cbds/system (fn [system]
                                (when system
                                  (cb/halt! system))
                                nil))
  (alter-var-root cbds/config (constantly nil)))

(defn go [base & profiles]
  (halt)
  (let [config (apply cb/merge-with-profiles base profiles)]
    (alter-var-root cbds/config (constantly config))
    (try
      (let [system (cb/init′ config)]
        (alter-var-root cbds/system (constantly system)))
      (catch Exception e
        (if-let [ig-system (:system (ex-data e))]
          (ig/halt! ig-system)
          (throw e))))))

(defn get-block [block-key]
  (-> cbds/system :system block-key))

(defn resolve-block [block-key]
  (ig/resolve-key block-key (get-block block-key)))
