(ns ch.codesmith.blocks.httpkit
  (:require [ch.codesmith.blocks :as cb]
            [org.httpkit.server :as hkit]))

(defn server [_ {:keys [ring-handler
                        options]}]
  {::cb/instance (hkit/run-server ring-handler
                                  (merge {:legacy-return-value? false}
                                         options))
   ::cb/halt     (fn [_ instance]
                   (hkit/server-stop! instance))})
