(ns codesmith.blocks.postgres.dev
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.postgres :as cbp]
            [integrant.core :as ig]
            [next.jdbc.connection :as conn])
  (:import [com.zaxxer.hikari HikariDataSource]
           [io.zonky.test.db.postgres.embedded EmbeddedPostgres]))

(defmethod cb/typed-block-transform
  [::cb/postgres :embedded-dev]
  [block-key system+profile ig-config]
  (cb/assoc-if-absent ig-config
                      ::embedded-dev
                      (-> system+profile block-key)))

(defmethod ig/init-key ::embedded-dev
  [_ {:keys [port]}]
  (let [builder                             (EmbeddedPostgres/builder)
        builder                             (if port (.setPort builder port) builder)
        ^EmbeddedPostgres embedded-postgres (.start builder)
        ^HikariDataSource ds                (conn/->pool HikariDataSource
                                                         (merge
                                                           (cbp/config->db-spec {:connection-url (.getJdbcUrl embedded-postgres "postgres" "postgres")})
                                                           {:password "postgres"}))]
    (cbp/migrate-db! ds)
    {:datasource        ds
     :embedded-postgres embedded-postgres}))

(defmethod ig/resolve-key ::embedded-dev
  [_ value]
  (:datasource value))

(defmethod ig/halt-key! ::embedded-dev
  [_ {:keys [datasource embedded-postgres]}]
  (.close datasource)
  (.close embedded-postgres))

(derive ::embedded-dev ::cb/postgres)
