(ns ch.codesmith.blocks.rabbitmq.dev
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.rabbitmq :as cbr]
            [integrant.core :as ig]
            [langohr.core :as rmq]
            [clj-test-containers.core :as tc]
            [clojure.java.browse :as cjb]))

(defmethod cb/typed-block-transform
  [::cbr/rabbitmq ::dev]
  [_ _ ig-config]
  (assoc ig-config ::dev {}))

(defmethod ig/init-key ::dev
  [_ _]
  (let [rabbitmq-container (-> (tc/create {:image-name    "rabbitmq:3.9"
                                           :exposed-ports [5672 15672]
                                           :env-vars      {"RABBITMQ_ERLANG_COOKIE" "SWQOKODSQALRPCLNMEQG"
                                                           "RABBITMQ_DEFAULT_VHOST" "/"}
                                           :wait-for      {:wait-strategy   :log
                                                           :message         "Server startup complete"
                                                           :startup-timeout 30}})
                               (tc/copy-file-to-container!
                                 {:container-path "/etc/rabbitmq/enabled_plugins"
                                  :path           "./development/rabbitmq/enabled_plugins"
                                  :type           :host-path})
                               (tc/start!))]
    {:container  rabbitmq-container
     :connection (rmq/connect {:port     ((:mapped-ports rabbitmq-container) 5672)
                               :host     "localhost"
                               :username "guest"
                               :password "guest"})}))

(defmethod ig/resolve-key ::dev
  [_ dev]
  (:connection dev))

(defmethod ig/halt-key! ::dev
  [_ {:keys [container connection]}]
  (rmq/close connection)
  (tc/stop! container))

(defn open-admin-web-ui [{:keys [container]}]
  (cjb/browse-url (str "http://localhost:" ((container :mapped-ports) 15672))))

(derive ::dev :cbr/rabbitmq)
