(ns ch.codesmith.blocks.reitit.dev
  (:require [reitit.core :as r]
            [ch.codesmith.blocks.reitit :as cbrei]))

(deftype DynamicRouter [router-fn]
  r/Router
  (router-name [_]
    :dynamic-router)
  (routes [_]
    (r/routes (router-fn)))
  (compiled-routes [_]
    (r/compiled-routes (router-fn)))
  (options [_]
    (r/options (router-fn)))
  (route-names [_]
    (r/route-names (router-fn)))
  (match-by-path [_ path]
    (r/match-by-path (router-fn) path))
  (match-by-name
    [_ name]
    (r/match-by-name (router-fn) name))
  (match-by-name
    [_ name path-params]
    (r/match-by-name (router-fn) name path-params)))

(def router cbrei/router)

(defmethod cbrei/router :dynamic
  [_ config]
  (let [route-fn (:routes-fn config)]
    (when-not (var? route-fn)
      (throw (let [class (class route-fn)]
               (ex-info
                 (str "To work properly, the dynamic router requires a var as routes-fn, got a " class)
                 {:class class})))))
  {:instance (->DynamicRouter #(cbrei/static-router config))})
