(ns ch.codesmith.blocks.sqlite
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.jdbc :as cbjdbc]
            [clojure.spec.alpha :as s]))

(defmulti sqlite (fn [_ config] (::cb/type config)))

(def datasource-defaults
  {:maximumPoolSize 1})

(defmulti check-config ::cb/type)

(s/def ::file string?)
(s/def ::file-config (s/keys :req-un [::file]))
(def file-config-checker (cb/checker ::file-config))

(defmethod check-config :file
  [config]
  (file-config-checker config))

(s/def ::name string?)
(s/def ::memory-config (s/keys :opt-un [::name]))
(def memory-config-checker (cb/checker ::memory-config))

(defmethod check-config :memory
  [config]
  (memory-config-checker config))

(defmulti jdbc-url ::cb/type)

(defmethod jdbc-url :file
  [{:keys [file]}]
  (str "jdbc:sqlite:file:" file))

(defmethod jdbc-url :memory
  [{:keys [name] :or {name "memdb"}}]
  (str "jdbc:sqlite:file:" name "?mode=memory&cache=shared"))

(defmethod sqlite :default
  [_ config]
  {::cb/instance (let [config (check-config (cbjdbc/include-datasource-defaults config datasource-defaults))
                       config (assoc config :datasource {:jdbcUrl (jdbc-url config)})]
                   (cbjdbc/init config))
   ::cb/halt     cbjdbc/halt!})
