(ns ch.codesmith.blocks.xtdb
  (:require [ch.codesmith.blocks :as cb]
            [clojure.java.io :as io]
            [xtdb.api :as xt])
  (:import (java.io Closeable)))

(defn stop-node [^Closeable xtdb-node]
  (.close xtdb-node))

(defn xtdb [_ {:keys [options init]}]
  (let [node (xt/start-node (or options {}))]
    (when init
      (try
        (when-let [tx (init node)]
          (xt/await-tx node tx))
        (catch Exception e
          (stop-node node)
          (throw e))))
    {::cb/instance node
     ::cb/halt     (fn [_ node]
                     (stop-node node))}))

(defn dev-rocksdb [{:keys [tx-log-path document-store-path index-store init]
                    :or   {tx-log-path         "data/xtdb/tx-log"
                           document-store-path "data/xtdb/doc-store"
                           index-store         "data/xtdb/index-store"}}]
  (letfn [(kv-store [dir]
            {:kv-store {:xtdb/module 'xtdb.rocksdb/->kv-store
                        :db-dir      (io/file dir)
                        :sync?       true}})]
    {::cb/block xtdb
     :config    {:xtdb/tx-log         (kv-store tx-log-path)
                 :xtdb/document-store (kv-store document-store-path)
                 :xtdb/index-store    (kv-store index-store)}
     :init      init}))
