(ns ch.deepimpact.CasThrottle
  (:require [ch.deepimpact.cas-throttle-api :as api])
  (:gen-class
   :init init
   :state state
   :methods [[exceedsThreshold [javax.servlet.ServletRequest] Boolean]
             [recordSubmissionFailure [javax.servlet.ServletRequest] void]
             [afterCompletion [javax.servlet.ServletRequest] void]
             [clean [] void]]))


;; 1. after completition
;; 2. exceeds?
;; 3.1: fail => after-completition
;; 3.1: success => after-completition

;; loop=> .... clean

(defn -init []
  [[]
   (atom {}) ])


(defn -exceedsThreshold [this req]
  (Boolean. (api/exceeds-threshold (.state this) req)))

(defn -recordSubmissionFailure [this req]
  (api/record-submission-failure (.state this) req))

(defn -afterCompletion [this req]
  (println (count @(.state this)) @(.state this))
  (api/after-completion (.state this) req))

(defn -clean [this]
  (api/clean (.state this))
  )
