(ns ch.deepimpact.cas-throttle-api
  (require
   [clj-time.core :as t]
   [clj-http.client :as client]))

(def recaptcha-secret "6LfQ0AoTAAAAAMcm5Y8nXXSeQ6al_VUUQKD6FOWX")

(def limit 3)

(defn get-ip [req]
  (str (.getParameter req "username") ":::" (.getRemoteAddr req)))

(defn has-value? [s]
  (and ((complement nil?) s) (not= "undefined" s) (not= "" s)))

(defn increment-counter! [^clojure.lang.Atom state ip]
  (println "IP " ip)
  (println "STATE " state)
 (if-let [c (get @state ip)]
       (do
         (swap! state update-in  [ip :count] inc)
         (swap! state update-in  [ip :time] (fn [_] (t/now)))
         )
       (swap! state assoc ip {:count 1 :time (t/now)}))
  (get-in @state [ip :count]))

(defn decrement-counter! [^clojure.lang.Atom state ip]
  (when-let [c (get @state ip)]
    (swap! state update-in  [ip :count] dec)
    (swap! state update-in  [ip :time] (fn [_] (t/now)))))


(defn reset-counter! [^clojure.lang.Atom state ip]
  (swap! state dissoc ip))


(defn get-count [^clojure.lang.Atom state ip]
  (if-let [c (get-in @state [ip :count])] c 0))

;; should return boolean
(defn exceeds-threshold [^clojure.lang.Atom state req]
  (let [captcha (or (.getParameter req "captcha") (.getParameter req "g-recaptcha-response"))]
;    (println captcha)
    (if (has-value? captcha)
      (let [google-response (:body (client/post "https://www.google.com/recaptcha/api/siteverify"
                                                {:form-params  {:secret recaptcha-secret
                                                                :response  captcha}

                                                 :headers {
                                                           "Content-Type" "application/x-www-form-urlencoded"
                                                           "Accept" "application/json, text/plain, */*"}

                                                 :throw-exceptions false
                                                 :as :json}))]
        (println google-response)
        (when (:success google-response)
          (decrement-counter! state (get-ip req))
          (.setAttribute req "recaptcha" (Boolean. true)))
        (not (:success google-response)))
      (> (get-count state (get-ip req)) limit))))


(defn record-submission-failure [state req]
  (increment-counter! state (get-ip req))
  (.setAttribute req "failure" (Boolean. true))

  )

(defn after-completion [state req]
  (when-not (.getAttribute req "failure")
    (when (.getAttribute req "recaptcha")
      (reset-counter! state (get-ip req))
      )
    )

  )
(defn clean [state]
  (print " clean! ")
  (doseq [[ip _] (filter (fn [[k v]] (let [one-hour-minus (t/plus (t/now) (t/hours -1))]
                                  (t/before? (:time v) one-hour-minus)
                                  )) @state)]
    (reset-counter! state ip)))


(comment
 (def req1 (reify
             javax.servlet.ServletRequest
             (getParameter [this k]
               (condp = k
                 "captcha" ""
                 ""))
             (getRemoteAddr [this]
               "me")
             (getAttribute [this k]
               "hello")
             (setAttribute [this k v]
               "ignore")

             ))

 (def req2 (reify
             javax.servlet.ServletRequest
             (getParameter [this k]
               (condp = k
                 "captcha" ""
                 ""))
             (getRemoteAddr [this]
               "you")
             (getAttribute [this k]
               "hello")
             (setAttribute [this k v]
               "ignore")

             ))

 (def state (atom {}))
 (if (exceeds-threshold state req)
   (record-submission-failure state req2)
   (reset-counter! state (get-ip req2))
   )
 state
 (clean state)


 )
