// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__33756 = arguments.length;
switch (G__33756) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33757 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33757 = (function (f,blockable,meta33758){
this.f = f;
this.blockable = blockable;
this.meta33758 = meta33758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33759,meta33758__$1){
var self__ = this;
var _33759__$1 = this;
return (new cljs.core.async.t_cljs$core$async33757(self__.f,self__.blockable,meta33758__$1));
});

cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33759){
var self__ = this;
var _33759__$1 = this;
return self__.meta33758;
});

cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async33757.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async33757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta33758","meta33758",-864857948,null)], null);
});

cljs.core.async.t_cljs$core$async33757.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33757";

cljs.core.async.t_cljs$core$async33757.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async33757");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33757.
 */
cljs.core.async.__GT_t_cljs$core$async33757 = (function cljs$core$async$__GT_t_cljs$core$async33757(f__$1,blockable__$1,meta33758){
return (new cljs.core.async.t_cljs$core$async33757(f__$1,blockable__$1,meta33758));
});

}

return (new cljs.core.async.t_cljs$core$async33757(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__33763 = arguments.length;
switch (G__33763) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__33766 = arguments.length;
switch (G__33766) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__33769 = arguments.length;
switch (G__33769) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_33771 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_33771);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_33771,ret){
return (function (){
return fn1.call(null,val_33771);
});})(val_33771,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__33773 = arguments.length;
switch (G__33773) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5718__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5718__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___33775 = n;
var x_33776 = (0);
while(true){
if((x_33776 < n__4607__auto___33775)){
(a[x_33776] = (0));

var G__33777 = (x_33776 + (1));
x_33776 = G__33777;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__33778 = (i + (1));
i = G__33778;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33779 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33779 = (function (flag,meta33780){
this.flag = flag;
this.meta33780 = meta33780;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_33781,meta33780__$1){
var self__ = this;
var _33781__$1 = this;
return (new cljs.core.async.t_cljs$core$async33779(self__.flag,meta33780__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_33781){
var self__ = this;
var _33781__$1 = this;
return self__.meta33780;
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta33780","meta33780",875105116,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async33779.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33779.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33779";

cljs.core.async.t_cljs$core$async33779.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async33779");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33779.
 */
cljs.core.async.__GT_t_cljs$core$async33779 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async33779(flag__$1,meta33780){
return (new cljs.core.async.t_cljs$core$async33779(flag__$1,meta33780));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async33779(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33782 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33782 = (function (flag,cb,meta33783){
this.flag = flag;
this.cb = cb;
this.meta33783 = meta33783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33784,meta33783__$1){
var self__ = this;
var _33784__$1 = this;
return (new cljs.core.async.t_cljs$core$async33782(self__.flag,self__.cb,meta33783__$1));
});

cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33784){
var self__ = this;
var _33784__$1 = this;
return self__.meta33783;
});

cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33782.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async33782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta33783","meta33783",-846471153,null)], null);
});

cljs.core.async.t_cljs$core$async33782.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33782.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33782";

cljs.core.async.t_cljs$core$async33782.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async33782");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33782.
 */
cljs.core.async.__GT_t_cljs$core$async33782 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async33782(flag__$1,cb__$1,meta33783){
return (new cljs.core.async.t_cljs$core$async33782(flag__$1,cb__$1,meta33783));
});

}

return (new cljs.core.async.t_cljs$core$async33782(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33785_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33785_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33786_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33786_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33787 = (i + (1));
i = G__33787;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___33793 = arguments.length;
var i__4731__auto___33794 = (0);
while(true){
if((i__4731__auto___33794 < len__4730__auto___33793)){
args__4736__auto__.push((arguments[i__4731__auto___33794]));

var G__33795 = (i__4731__auto___33794 + (1));
i__4731__auto___33794 = G__33795;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__33790){
var map__33791 = p__33790;
var map__33791__$1 = (((((!((map__33791 == null))))?(((((map__33791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33791):map__33791);
var opts = map__33791__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq33788){
var G__33789 = cljs.core.first.call(null,seq33788);
var seq33788__$1 = cljs.core.next.call(null,seq33788);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33789,seq33788__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__33797 = arguments.length;
switch (G__33797) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__33696__auto___33843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___33843){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___33843){
return (function (state_33821){
var state_val_33822 = (state_33821[(1)]);
if((state_val_33822 === (7))){
var inst_33817 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33823_33844 = state_33821__$1;
(statearr_33823_33844[(2)] = inst_33817);

(statearr_33823_33844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (1))){
var state_33821__$1 = state_33821;
var statearr_33824_33845 = state_33821__$1;
(statearr_33824_33845[(2)] = null);

(statearr_33824_33845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (4))){
var inst_33800 = (state_33821[(7)]);
var inst_33800__$1 = (state_33821[(2)]);
var inst_33801 = (inst_33800__$1 == null);
var state_33821__$1 = (function (){var statearr_33825 = state_33821;
(statearr_33825[(7)] = inst_33800__$1);

return statearr_33825;
})();
if(cljs.core.truth_(inst_33801)){
var statearr_33826_33846 = state_33821__$1;
(statearr_33826_33846[(1)] = (5));

} else {
var statearr_33827_33847 = state_33821__$1;
(statearr_33827_33847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (13))){
var state_33821__$1 = state_33821;
var statearr_33828_33848 = state_33821__$1;
(statearr_33828_33848[(2)] = null);

(statearr_33828_33848[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (6))){
var inst_33800 = (state_33821[(7)]);
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33821__$1,(11),to,inst_33800);
} else {
if((state_val_33822 === (3))){
var inst_33819 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33821__$1,inst_33819);
} else {
if((state_val_33822 === (12))){
var state_33821__$1 = state_33821;
var statearr_33829_33849 = state_33821__$1;
(statearr_33829_33849[(2)] = null);

(statearr_33829_33849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (2))){
var state_33821__$1 = state_33821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33821__$1,(4),from);
} else {
if((state_val_33822 === (11))){
var inst_33810 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
if(cljs.core.truth_(inst_33810)){
var statearr_33830_33850 = state_33821__$1;
(statearr_33830_33850[(1)] = (12));

} else {
var statearr_33831_33851 = state_33821__$1;
(statearr_33831_33851[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (9))){
var state_33821__$1 = state_33821;
var statearr_33832_33852 = state_33821__$1;
(statearr_33832_33852[(2)] = null);

(statearr_33832_33852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (5))){
var state_33821__$1 = state_33821;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33833_33853 = state_33821__$1;
(statearr_33833_33853[(1)] = (8));

} else {
var statearr_33834_33854 = state_33821__$1;
(statearr_33834_33854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (14))){
var inst_33815 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33835_33855 = state_33821__$1;
(statearr_33835_33855[(2)] = inst_33815);

(statearr_33835_33855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (10))){
var inst_33807 = (state_33821[(2)]);
var state_33821__$1 = state_33821;
var statearr_33836_33856 = state_33821__$1;
(statearr_33836_33856[(2)] = inst_33807);

(statearr_33836_33856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33822 === (8))){
var inst_33804 = cljs.core.async.close_BANG_.call(null,to);
var state_33821__$1 = state_33821;
var statearr_33837_33857 = state_33821__$1;
(statearr_33837_33857[(2)] = inst_33804);

(statearr_33837_33857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___33843))
;
return ((function (switch__33601__auto__,c__33696__auto___33843){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_33838 = [null,null,null,null,null,null,null,null];
(statearr_33838[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_33838[(1)] = (1));

return statearr_33838;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_33821){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_33821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e33839){if((e33839 instanceof Object)){
var ex__33605__auto__ = e33839;
var statearr_33840_33858 = state_33821;
(statearr_33840_33858[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33821);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33859 = state_33821;
state_33821 = G__33859;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_33821){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_33821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___33843))
})();
var state__33698__auto__ = (function (){var statearr_33841 = f__33697__auto__.call(null);
(statearr_33841[(6)] = c__33696__auto___33843);

return statearr_33841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___33843))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__33860){
var vec__33861 = p__33860;
var v = cljs.core.nth.call(null,vec__33861,(0),null);
var p = cljs.core.nth.call(null,vec__33861,(1),null);
var job = vec__33861;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__33696__auto___34032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results){
return (function (state_33868){
var state_val_33869 = (state_33868[(1)]);
if((state_val_33869 === (1))){
var state_33868__$1 = state_33868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33868__$1,(2),res,v);
} else {
if((state_val_33869 === (2))){
var inst_33865 = (state_33868[(2)]);
var inst_33866 = cljs.core.async.close_BANG_.call(null,res);
var state_33868__$1 = (function (){var statearr_33870 = state_33868;
(statearr_33870[(7)] = inst_33865);

return statearr_33870;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33868__$1,inst_33866);
} else {
return null;
}
}
});})(c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results))
;
return ((function (switch__33601__auto__,c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_33871 = [null,null,null,null,null,null,null,null];
(statearr_33871[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__);

(statearr_33871[(1)] = (1));

return statearr_33871;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1 = (function (state_33868){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_33868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e33872){if((e33872 instanceof Object)){
var ex__33605__auto__ = e33872;
var statearr_33873_34033 = state_33868;
(statearr_33873_34033[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34034 = state_33868;
state_33868 = G__34034;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = function(state_33868){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1.call(this,state_33868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results))
})();
var state__33698__auto__ = (function (){var statearr_33874 = f__33697__auto__.call(null);
(statearr_33874[(6)] = c__33696__auto___34032);

return statearr_33874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34032,res,vec__33861,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33875){
var vec__33876 = p__33875;
var v = cljs.core.nth.call(null,vec__33876,(0),null);
var p = cljs.core.nth.call(null,vec__33876,(1),null);
var job = vec__33876;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___34035 = n;
var __34036 = (0);
while(true){
if((__34036 < n__4607__auto___34035)){
var G__33879_34037 = type;
var G__33879_34038__$1 = (((G__33879_34037 instanceof cljs.core.Keyword))?G__33879_34037.fqn:null);
switch (G__33879_34038__$1) {
case "compute":
var c__33696__auto___34040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__34036,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (__34036,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function (state_33892){
var state_val_33893 = (state_33892[(1)]);
if((state_val_33893 === (1))){
var state_33892__$1 = state_33892;
var statearr_33894_34041 = state_33892__$1;
(statearr_33894_34041[(2)] = null);

(statearr_33894_34041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33893 === (2))){
var state_33892__$1 = state_33892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33892__$1,(4),jobs);
} else {
if((state_val_33893 === (3))){
var inst_33890 = (state_33892[(2)]);
var state_33892__$1 = state_33892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33892__$1,inst_33890);
} else {
if((state_val_33893 === (4))){
var inst_33882 = (state_33892[(2)]);
var inst_33883 = process.call(null,inst_33882);
var state_33892__$1 = state_33892;
if(cljs.core.truth_(inst_33883)){
var statearr_33895_34042 = state_33892__$1;
(statearr_33895_34042[(1)] = (5));

} else {
var statearr_33896_34043 = state_33892__$1;
(statearr_33896_34043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33893 === (5))){
var state_33892__$1 = state_33892;
var statearr_33897_34044 = state_33892__$1;
(statearr_33897_34044[(2)] = null);

(statearr_33897_34044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33893 === (6))){
var state_33892__$1 = state_33892;
var statearr_33898_34045 = state_33892__$1;
(statearr_33898_34045[(2)] = null);

(statearr_33898_34045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33893 === (7))){
var inst_33888 = (state_33892[(2)]);
var state_33892__$1 = state_33892;
var statearr_33899_34046 = state_33892__$1;
(statearr_33899_34046[(2)] = inst_33888);

(statearr_33899_34046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34036,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
;
return ((function (__34036,switch__33601__auto__,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_33900 = [null,null,null,null,null,null,null];
(statearr_33900[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__);

(statearr_33900[(1)] = (1));

return statearr_33900;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1 = (function (state_33892){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_33892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e33901){if((e33901 instanceof Object)){
var ex__33605__auto__ = e33901;
var statearr_33902_34047 = state_33892;
(statearr_33902_34047[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33892);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33901;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34048 = state_33892;
state_33892 = G__34048;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = function(state_33892){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1.call(this,state_33892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__;
})()
;})(__34036,switch__33601__auto__,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
})();
var state__33698__auto__ = (function (){var statearr_33903 = f__33697__auto__.call(null);
(statearr_33903[(6)] = c__33696__auto___34040);

return statearr_33903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(__34036,c__33696__auto___34040,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
);


break;
case "async":
var c__33696__auto___34049 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__34036,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (__34036,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function (state_33916){
var state_val_33917 = (state_33916[(1)]);
if((state_val_33917 === (1))){
var state_33916__$1 = state_33916;
var statearr_33918_34050 = state_33916__$1;
(statearr_33918_34050[(2)] = null);

(statearr_33918_34050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33917 === (2))){
var state_33916__$1 = state_33916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33916__$1,(4),jobs);
} else {
if((state_val_33917 === (3))){
var inst_33914 = (state_33916[(2)]);
var state_33916__$1 = state_33916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33916__$1,inst_33914);
} else {
if((state_val_33917 === (4))){
var inst_33906 = (state_33916[(2)]);
var inst_33907 = async.call(null,inst_33906);
var state_33916__$1 = state_33916;
if(cljs.core.truth_(inst_33907)){
var statearr_33919_34051 = state_33916__$1;
(statearr_33919_34051[(1)] = (5));

} else {
var statearr_33920_34052 = state_33916__$1;
(statearr_33920_34052[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33917 === (5))){
var state_33916__$1 = state_33916;
var statearr_33921_34053 = state_33916__$1;
(statearr_33921_34053[(2)] = null);

(statearr_33921_34053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33917 === (6))){
var state_33916__$1 = state_33916;
var statearr_33922_34054 = state_33916__$1;
(statearr_33922_34054[(2)] = null);

(statearr_33922_34054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33917 === (7))){
var inst_33912 = (state_33916[(2)]);
var state_33916__$1 = state_33916;
var statearr_33923_34055 = state_33916__$1;
(statearr_33923_34055[(2)] = inst_33912);

(statearr_33923_34055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34036,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
;
return ((function (__34036,switch__33601__auto__,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_33924 = [null,null,null,null,null,null,null];
(statearr_33924[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__);

(statearr_33924[(1)] = (1));

return statearr_33924;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1 = (function (state_33916){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_33916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e33925){if((e33925 instanceof Object)){
var ex__33605__auto__ = e33925;
var statearr_33926_34056 = state_33916;
(statearr_33926_34056[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33925;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34057 = state_33916;
state_33916 = G__34057;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = function(state_33916){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1.call(this,state_33916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__;
})()
;})(__34036,switch__33601__auto__,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
})();
var state__33698__auto__ = (function (){var statearr_33927 = f__33697__auto__.call(null);
(statearr_33927[(6)] = c__33696__auto___34049);

return statearr_33927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(__34036,c__33696__auto___34049,G__33879_34037,G__33879_34038__$1,n__4607__auto___34035,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33879_34038__$1)].join('')));

}

var G__34058 = (__34036 + (1));
__34036 = G__34058;
continue;
} else {
}
break;
}

var c__33696__auto___34059 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34059,jobs,results,process,async){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34059,jobs,results,process,async){
return (function (state_33949){
var state_val_33950 = (state_33949[(1)]);
if((state_val_33950 === (7))){
var inst_33945 = (state_33949[(2)]);
var state_33949__$1 = state_33949;
var statearr_33951_34060 = state_33949__$1;
(statearr_33951_34060[(2)] = inst_33945);

(statearr_33951_34060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33950 === (1))){
var state_33949__$1 = state_33949;
var statearr_33952_34061 = state_33949__$1;
(statearr_33952_34061[(2)] = null);

(statearr_33952_34061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33950 === (4))){
var inst_33930 = (state_33949[(7)]);
var inst_33930__$1 = (state_33949[(2)]);
var inst_33931 = (inst_33930__$1 == null);
var state_33949__$1 = (function (){var statearr_33953 = state_33949;
(statearr_33953[(7)] = inst_33930__$1);

return statearr_33953;
})();
if(cljs.core.truth_(inst_33931)){
var statearr_33954_34062 = state_33949__$1;
(statearr_33954_34062[(1)] = (5));

} else {
var statearr_33955_34063 = state_33949__$1;
(statearr_33955_34063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33950 === (6))){
var inst_33930 = (state_33949[(7)]);
var inst_33935 = (state_33949[(8)]);
var inst_33935__$1 = cljs.core.async.chan.call(null,(1));
var inst_33936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33937 = [inst_33930,inst_33935__$1];
var inst_33938 = (new cljs.core.PersistentVector(null,2,(5),inst_33936,inst_33937,null));
var state_33949__$1 = (function (){var statearr_33956 = state_33949;
(statearr_33956[(8)] = inst_33935__$1);

return statearr_33956;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33949__$1,(8),jobs,inst_33938);
} else {
if((state_val_33950 === (3))){
var inst_33947 = (state_33949[(2)]);
var state_33949__$1 = state_33949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33949__$1,inst_33947);
} else {
if((state_val_33950 === (2))){
var state_33949__$1 = state_33949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33949__$1,(4),from);
} else {
if((state_val_33950 === (9))){
var inst_33942 = (state_33949[(2)]);
var state_33949__$1 = (function (){var statearr_33957 = state_33949;
(statearr_33957[(9)] = inst_33942);

return statearr_33957;
})();
var statearr_33958_34064 = state_33949__$1;
(statearr_33958_34064[(2)] = null);

(statearr_33958_34064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33950 === (5))){
var inst_33933 = cljs.core.async.close_BANG_.call(null,jobs);
var state_33949__$1 = state_33949;
var statearr_33959_34065 = state_33949__$1;
(statearr_33959_34065[(2)] = inst_33933);

(statearr_33959_34065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33950 === (8))){
var inst_33935 = (state_33949[(8)]);
var inst_33940 = (state_33949[(2)]);
var state_33949__$1 = (function (){var statearr_33960 = state_33949;
(statearr_33960[(10)] = inst_33940);

return statearr_33960;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33949__$1,(9),results,inst_33935);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___34059,jobs,results,process,async))
;
return ((function (switch__33601__auto__,c__33696__auto___34059,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_33961 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33961[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__);

(statearr_33961[(1)] = (1));

return statearr_33961;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1 = (function (state_33949){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_33949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e33962){if((e33962 instanceof Object)){
var ex__33605__auto__ = e33962;
var statearr_33963_34066 = state_33949;
(statearr_33963_34066[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33962;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34067 = state_33949;
state_33949 = G__34067;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = function(state_33949){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1.call(this,state_33949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34059,jobs,results,process,async))
})();
var state__33698__auto__ = (function (){var statearr_33964 = f__33697__auto__.call(null);
(statearr_33964[(6)] = c__33696__auto___34059);

return statearr_33964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34059,jobs,results,process,async))
);


var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__,jobs,results,process,async){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__,jobs,results,process,async){
return (function (state_34002){
var state_val_34003 = (state_34002[(1)]);
if((state_val_34003 === (7))){
var inst_33998 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
var statearr_34004_34068 = state_34002__$1;
(statearr_34004_34068[(2)] = inst_33998);

(statearr_34004_34068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (20))){
var state_34002__$1 = state_34002;
var statearr_34005_34069 = state_34002__$1;
(statearr_34005_34069[(2)] = null);

(statearr_34005_34069[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (1))){
var state_34002__$1 = state_34002;
var statearr_34006_34070 = state_34002__$1;
(statearr_34006_34070[(2)] = null);

(statearr_34006_34070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (4))){
var inst_33967 = (state_34002[(7)]);
var inst_33967__$1 = (state_34002[(2)]);
var inst_33968 = (inst_33967__$1 == null);
var state_34002__$1 = (function (){var statearr_34007 = state_34002;
(statearr_34007[(7)] = inst_33967__$1);

return statearr_34007;
})();
if(cljs.core.truth_(inst_33968)){
var statearr_34008_34071 = state_34002__$1;
(statearr_34008_34071[(1)] = (5));

} else {
var statearr_34009_34072 = state_34002__$1;
(statearr_34009_34072[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (15))){
var inst_33980 = (state_34002[(8)]);
var state_34002__$1 = state_34002;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34002__$1,(18),to,inst_33980);
} else {
if((state_val_34003 === (21))){
var inst_33993 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
var statearr_34010_34073 = state_34002__$1;
(statearr_34010_34073[(2)] = inst_33993);

(statearr_34010_34073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (13))){
var inst_33995 = (state_34002[(2)]);
var state_34002__$1 = (function (){var statearr_34011 = state_34002;
(statearr_34011[(9)] = inst_33995);

return statearr_34011;
})();
var statearr_34012_34074 = state_34002__$1;
(statearr_34012_34074[(2)] = null);

(statearr_34012_34074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (6))){
var inst_33967 = (state_34002[(7)]);
var state_34002__$1 = state_34002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34002__$1,(11),inst_33967);
} else {
if((state_val_34003 === (17))){
var inst_33988 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
if(cljs.core.truth_(inst_33988)){
var statearr_34013_34075 = state_34002__$1;
(statearr_34013_34075[(1)] = (19));

} else {
var statearr_34014_34076 = state_34002__$1;
(statearr_34014_34076[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (3))){
var inst_34000 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34002__$1,inst_34000);
} else {
if((state_val_34003 === (12))){
var inst_33977 = (state_34002[(10)]);
var state_34002__$1 = state_34002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34002__$1,(14),inst_33977);
} else {
if((state_val_34003 === (2))){
var state_34002__$1 = state_34002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34002__$1,(4),results);
} else {
if((state_val_34003 === (19))){
var state_34002__$1 = state_34002;
var statearr_34015_34077 = state_34002__$1;
(statearr_34015_34077[(2)] = null);

(statearr_34015_34077[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (11))){
var inst_33977 = (state_34002[(2)]);
var state_34002__$1 = (function (){var statearr_34016 = state_34002;
(statearr_34016[(10)] = inst_33977);

return statearr_34016;
})();
var statearr_34017_34078 = state_34002__$1;
(statearr_34017_34078[(2)] = null);

(statearr_34017_34078[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (9))){
var state_34002__$1 = state_34002;
var statearr_34018_34079 = state_34002__$1;
(statearr_34018_34079[(2)] = null);

(statearr_34018_34079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (5))){
var state_34002__$1 = state_34002;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34019_34080 = state_34002__$1;
(statearr_34019_34080[(1)] = (8));

} else {
var statearr_34020_34081 = state_34002__$1;
(statearr_34020_34081[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (14))){
var inst_33980 = (state_34002[(8)]);
var inst_33982 = (state_34002[(11)]);
var inst_33980__$1 = (state_34002[(2)]);
var inst_33981 = (inst_33980__$1 == null);
var inst_33982__$1 = cljs.core.not.call(null,inst_33981);
var state_34002__$1 = (function (){var statearr_34021 = state_34002;
(statearr_34021[(8)] = inst_33980__$1);

(statearr_34021[(11)] = inst_33982__$1);

return statearr_34021;
})();
if(inst_33982__$1){
var statearr_34022_34082 = state_34002__$1;
(statearr_34022_34082[(1)] = (15));

} else {
var statearr_34023_34083 = state_34002__$1;
(statearr_34023_34083[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (16))){
var inst_33982 = (state_34002[(11)]);
var state_34002__$1 = state_34002;
var statearr_34024_34084 = state_34002__$1;
(statearr_34024_34084[(2)] = inst_33982);

(statearr_34024_34084[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (10))){
var inst_33974 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
var statearr_34025_34085 = state_34002__$1;
(statearr_34025_34085[(2)] = inst_33974);

(statearr_34025_34085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (18))){
var inst_33985 = (state_34002[(2)]);
var state_34002__$1 = state_34002;
var statearr_34026_34086 = state_34002__$1;
(statearr_34026_34086[(2)] = inst_33985);

(statearr_34026_34086[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34003 === (8))){
var inst_33971 = cljs.core.async.close_BANG_.call(null,to);
var state_34002__$1 = state_34002;
var statearr_34027_34087 = state_34002__$1;
(statearr_34027_34087[(2)] = inst_33971);

(statearr_34027_34087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto__,jobs,results,process,async))
;
return ((function (switch__33601__auto__,c__33696__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_34028 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34028[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__);

(statearr_34028[(1)] = (1));

return statearr_34028;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1 = (function (state_34002){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34029){if((e34029 instanceof Object)){
var ex__33605__auto__ = e34029;
var statearr_34030_34088 = state_34002;
(statearr_34030_34088[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34089 = state_34002;
state_34002 = G__34089;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__ = function(state_34002){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1.call(this,state_34002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__,jobs,results,process,async))
})();
var state__33698__auto__ = (function (){var statearr_34031 = f__33697__auto__.call(null);
(statearr_34031[(6)] = c__33696__auto__);

return statearr_34031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__,jobs,results,process,async))
);

return c__33696__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__34091 = arguments.length;
switch (G__34091) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__34094 = arguments.length;
switch (G__34094) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__34097 = arguments.length;
switch (G__34097) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__33696__auto___34146 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34146,tc,fc){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34146,tc,fc){
return (function (state_34123){
var state_val_34124 = (state_34123[(1)]);
if((state_val_34124 === (7))){
var inst_34119 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
var statearr_34125_34147 = state_34123__$1;
(statearr_34125_34147[(2)] = inst_34119);

(statearr_34125_34147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (1))){
var state_34123__$1 = state_34123;
var statearr_34126_34148 = state_34123__$1;
(statearr_34126_34148[(2)] = null);

(statearr_34126_34148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (4))){
var inst_34100 = (state_34123[(7)]);
var inst_34100__$1 = (state_34123[(2)]);
var inst_34101 = (inst_34100__$1 == null);
var state_34123__$1 = (function (){var statearr_34127 = state_34123;
(statearr_34127[(7)] = inst_34100__$1);

return statearr_34127;
})();
if(cljs.core.truth_(inst_34101)){
var statearr_34128_34149 = state_34123__$1;
(statearr_34128_34149[(1)] = (5));

} else {
var statearr_34129_34150 = state_34123__$1;
(statearr_34129_34150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (13))){
var state_34123__$1 = state_34123;
var statearr_34130_34151 = state_34123__$1;
(statearr_34130_34151[(2)] = null);

(statearr_34130_34151[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (6))){
var inst_34100 = (state_34123[(7)]);
var inst_34106 = p.call(null,inst_34100);
var state_34123__$1 = state_34123;
if(cljs.core.truth_(inst_34106)){
var statearr_34131_34152 = state_34123__$1;
(statearr_34131_34152[(1)] = (9));

} else {
var statearr_34132_34153 = state_34123__$1;
(statearr_34132_34153[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (3))){
var inst_34121 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34123__$1,inst_34121);
} else {
if((state_val_34124 === (12))){
var state_34123__$1 = state_34123;
var statearr_34133_34154 = state_34123__$1;
(statearr_34133_34154[(2)] = null);

(statearr_34133_34154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (2))){
var state_34123__$1 = state_34123;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34123__$1,(4),ch);
} else {
if((state_val_34124 === (11))){
var inst_34100 = (state_34123[(7)]);
var inst_34110 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34123__$1,(8),inst_34110,inst_34100);
} else {
if((state_val_34124 === (9))){
var state_34123__$1 = state_34123;
var statearr_34134_34155 = state_34123__$1;
(statearr_34134_34155[(2)] = tc);

(statearr_34134_34155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (5))){
var inst_34103 = cljs.core.async.close_BANG_.call(null,tc);
var inst_34104 = cljs.core.async.close_BANG_.call(null,fc);
var state_34123__$1 = (function (){var statearr_34135 = state_34123;
(statearr_34135[(8)] = inst_34103);

return statearr_34135;
})();
var statearr_34136_34156 = state_34123__$1;
(statearr_34136_34156[(2)] = inst_34104);

(statearr_34136_34156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (14))){
var inst_34117 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
var statearr_34137_34157 = state_34123__$1;
(statearr_34137_34157[(2)] = inst_34117);

(statearr_34137_34157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (10))){
var state_34123__$1 = state_34123;
var statearr_34138_34158 = state_34123__$1;
(statearr_34138_34158[(2)] = fc);

(statearr_34138_34158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (8))){
var inst_34112 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
if(cljs.core.truth_(inst_34112)){
var statearr_34139_34159 = state_34123__$1;
(statearr_34139_34159[(1)] = (12));

} else {
var statearr_34140_34160 = state_34123__$1;
(statearr_34140_34160[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___34146,tc,fc))
;
return ((function (switch__33601__auto__,c__33696__auto___34146,tc,fc){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_34141 = [null,null,null,null,null,null,null,null,null];
(statearr_34141[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_34141[(1)] = (1));

return statearr_34141;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_34123){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34142){if((e34142 instanceof Object)){
var ex__33605__auto__ = e34142;
var statearr_34143_34161 = state_34123;
(statearr_34143_34161[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34162 = state_34123;
state_34123 = G__34162;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_34123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_34123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34146,tc,fc))
})();
var state__33698__auto__ = (function (){var statearr_34144 = f__33697__auto__.call(null);
(statearr_34144[(6)] = c__33696__auto___34146);

return statearr_34144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34146,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__){
return (function (state_34183){
var state_val_34184 = (state_34183[(1)]);
if((state_val_34184 === (7))){
var inst_34179 = (state_34183[(2)]);
var state_34183__$1 = state_34183;
var statearr_34185_34203 = state_34183__$1;
(statearr_34185_34203[(2)] = inst_34179);

(statearr_34185_34203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (1))){
var inst_34163 = init;
var state_34183__$1 = (function (){var statearr_34186 = state_34183;
(statearr_34186[(7)] = inst_34163);

return statearr_34186;
})();
var statearr_34187_34204 = state_34183__$1;
(statearr_34187_34204[(2)] = null);

(statearr_34187_34204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (4))){
var inst_34166 = (state_34183[(8)]);
var inst_34166__$1 = (state_34183[(2)]);
var inst_34167 = (inst_34166__$1 == null);
var state_34183__$1 = (function (){var statearr_34188 = state_34183;
(statearr_34188[(8)] = inst_34166__$1);

return statearr_34188;
})();
if(cljs.core.truth_(inst_34167)){
var statearr_34189_34205 = state_34183__$1;
(statearr_34189_34205[(1)] = (5));

} else {
var statearr_34190_34206 = state_34183__$1;
(statearr_34190_34206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (6))){
var inst_34170 = (state_34183[(9)]);
var inst_34166 = (state_34183[(8)]);
var inst_34163 = (state_34183[(7)]);
var inst_34170__$1 = f.call(null,inst_34163,inst_34166);
var inst_34171 = cljs.core.reduced_QMARK_.call(null,inst_34170__$1);
var state_34183__$1 = (function (){var statearr_34191 = state_34183;
(statearr_34191[(9)] = inst_34170__$1);

return statearr_34191;
})();
if(inst_34171){
var statearr_34192_34207 = state_34183__$1;
(statearr_34192_34207[(1)] = (8));

} else {
var statearr_34193_34208 = state_34183__$1;
(statearr_34193_34208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (3))){
var inst_34181 = (state_34183[(2)]);
var state_34183__$1 = state_34183;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34183__$1,inst_34181);
} else {
if((state_val_34184 === (2))){
var state_34183__$1 = state_34183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34183__$1,(4),ch);
} else {
if((state_val_34184 === (9))){
var inst_34170 = (state_34183[(9)]);
var inst_34163 = inst_34170;
var state_34183__$1 = (function (){var statearr_34194 = state_34183;
(statearr_34194[(7)] = inst_34163);

return statearr_34194;
})();
var statearr_34195_34209 = state_34183__$1;
(statearr_34195_34209[(2)] = null);

(statearr_34195_34209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (5))){
var inst_34163 = (state_34183[(7)]);
var state_34183__$1 = state_34183;
var statearr_34196_34210 = state_34183__$1;
(statearr_34196_34210[(2)] = inst_34163);

(statearr_34196_34210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (10))){
var inst_34177 = (state_34183[(2)]);
var state_34183__$1 = state_34183;
var statearr_34197_34211 = state_34183__$1;
(statearr_34197_34211[(2)] = inst_34177);

(statearr_34197_34211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34184 === (8))){
var inst_34170 = (state_34183[(9)]);
var inst_34173 = cljs.core.deref.call(null,inst_34170);
var state_34183__$1 = state_34183;
var statearr_34198_34212 = state_34183__$1;
(statearr_34198_34212[(2)] = inst_34173);

(statearr_34198_34212[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto__))
;
return ((function (switch__33601__auto__,c__33696__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__33602__auto__ = null;
var cljs$core$async$reduce_$_state_machine__33602__auto____0 = (function (){
var statearr_34199 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34199[(0)] = cljs$core$async$reduce_$_state_machine__33602__auto__);

(statearr_34199[(1)] = (1));

return statearr_34199;
});
var cljs$core$async$reduce_$_state_machine__33602__auto____1 = (function (state_34183){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34183);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34200){if((e34200 instanceof Object)){
var ex__33605__auto__ = e34200;
var statearr_34201_34213 = state_34183;
(statearr_34201_34213[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34183);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34214 = state_34183;
state_34183 = G__34214;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__33602__auto__ = function(state_34183){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__33602__auto____1.call(this,state_34183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__33602__auto____0;
cljs$core$async$reduce_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__33602__auto____1;
return cljs$core$async$reduce_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__))
})();
var state__33698__auto__ = (function (){var statearr_34202 = f__33697__auto__.call(null);
(statearr_34202[(6)] = c__33696__auto__);

return statearr_34202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__))
);

return c__33696__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__,f__$1){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__,f__$1){
return (function (state_34220){
var state_val_34221 = (state_34220[(1)]);
if((state_val_34221 === (1))){
var inst_34215 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_34220__$1 = state_34220;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34220__$1,(2),inst_34215);
} else {
if((state_val_34221 === (2))){
var inst_34217 = (state_34220[(2)]);
var inst_34218 = f__$1.call(null,inst_34217);
var state_34220__$1 = state_34220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34220__$1,inst_34218);
} else {
return null;
}
}
});})(c__33696__auto__,f__$1))
;
return ((function (switch__33601__auto__,c__33696__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__33602__auto__ = null;
var cljs$core$async$transduce_$_state_machine__33602__auto____0 = (function (){
var statearr_34222 = [null,null,null,null,null,null,null];
(statearr_34222[(0)] = cljs$core$async$transduce_$_state_machine__33602__auto__);

(statearr_34222[(1)] = (1));

return statearr_34222;
});
var cljs$core$async$transduce_$_state_machine__33602__auto____1 = (function (state_34220){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34223){if((e34223 instanceof Object)){
var ex__33605__auto__ = e34223;
var statearr_34224_34226 = state_34220;
(statearr_34224_34226[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34223;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34227 = state_34220;
state_34220 = G__34227;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__33602__auto__ = function(state_34220){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__33602__auto____1.call(this,state_34220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__33602__auto____0;
cljs$core$async$transduce_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__33602__auto____1;
return cljs$core$async$transduce_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__,f__$1))
})();
var state__33698__auto__ = (function (){var statearr_34225 = f__33697__auto__.call(null);
(statearr_34225[(6)] = c__33696__auto__);

return statearr_34225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__,f__$1))
);

return c__33696__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__34229 = arguments.length;
switch (G__34229) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__){
return (function (state_34254){
var state_val_34255 = (state_34254[(1)]);
if((state_val_34255 === (7))){
var inst_34236 = (state_34254[(2)]);
var state_34254__$1 = state_34254;
var statearr_34256_34277 = state_34254__$1;
(statearr_34256_34277[(2)] = inst_34236);

(statearr_34256_34277[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (1))){
var inst_34230 = cljs.core.seq.call(null,coll);
var inst_34231 = inst_34230;
var state_34254__$1 = (function (){var statearr_34257 = state_34254;
(statearr_34257[(7)] = inst_34231);

return statearr_34257;
})();
var statearr_34258_34278 = state_34254__$1;
(statearr_34258_34278[(2)] = null);

(statearr_34258_34278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (4))){
var inst_34231 = (state_34254[(7)]);
var inst_34234 = cljs.core.first.call(null,inst_34231);
var state_34254__$1 = state_34254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34254__$1,(7),ch,inst_34234);
} else {
if((state_val_34255 === (13))){
var inst_34248 = (state_34254[(2)]);
var state_34254__$1 = state_34254;
var statearr_34259_34279 = state_34254__$1;
(statearr_34259_34279[(2)] = inst_34248);

(statearr_34259_34279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (6))){
var inst_34239 = (state_34254[(2)]);
var state_34254__$1 = state_34254;
if(cljs.core.truth_(inst_34239)){
var statearr_34260_34280 = state_34254__$1;
(statearr_34260_34280[(1)] = (8));

} else {
var statearr_34261_34281 = state_34254__$1;
(statearr_34261_34281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (3))){
var inst_34252 = (state_34254[(2)]);
var state_34254__$1 = state_34254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34254__$1,inst_34252);
} else {
if((state_val_34255 === (12))){
var state_34254__$1 = state_34254;
var statearr_34262_34282 = state_34254__$1;
(statearr_34262_34282[(2)] = null);

(statearr_34262_34282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (2))){
var inst_34231 = (state_34254[(7)]);
var state_34254__$1 = state_34254;
if(cljs.core.truth_(inst_34231)){
var statearr_34263_34283 = state_34254__$1;
(statearr_34263_34283[(1)] = (4));

} else {
var statearr_34264_34284 = state_34254__$1;
(statearr_34264_34284[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (11))){
var inst_34245 = cljs.core.async.close_BANG_.call(null,ch);
var state_34254__$1 = state_34254;
var statearr_34265_34285 = state_34254__$1;
(statearr_34265_34285[(2)] = inst_34245);

(statearr_34265_34285[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (9))){
var state_34254__$1 = state_34254;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34266_34286 = state_34254__$1;
(statearr_34266_34286[(1)] = (11));

} else {
var statearr_34267_34287 = state_34254__$1;
(statearr_34267_34287[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (5))){
var inst_34231 = (state_34254[(7)]);
var state_34254__$1 = state_34254;
var statearr_34268_34288 = state_34254__$1;
(statearr_34268_34288[(2)] = inst_34231);

(statearr_34268_34288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (10))){
var inst_34250 = (state_34254[(2)]);
var state_34254__$1 = state_34254;
var statearr_34269_34289 = state_34254__$1;
(statearr_34269_34289[(2)] = inst_34250);

(statearr_34269_34289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34255 === (8))){
var inst_34231 = (state_34254[(7)]);
var inst_34241 = cljs.core.next.call(null,inst_34231);
var inst_34231__$1 = inst_34241;
var state_34254__$1 = (function (){var statearr_34270 = state_34254;
(statearr_34270[(7)] = inst_34231__$1);

return statearr_34270;
})();
var statearr_34271_34290 = state_34254__$1;
(statearr_34271_34290[(2)] = null);

(statearr_34271_34290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto__))
;
return ((function (switch__33601__auto__,c__33696__auto__){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_34272 = [null,null,null,null,null,null,null,null];
(statearr_34272[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_34272[(1)] = (1));

return statearr_34272;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_34254){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34273){if((e34273 instanceof Object)){
var ex__33605__auto__ = e34273;
var statearr_34274_34291 = state_34254;
(statearr_34274_34291[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34292 = state_34254;
state_34254 = G__34292;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_34254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_34254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__))
})();
var state__33698__auto__ = (function (){var statearr_34275 = f__33697__auto__.call(null);
(statearr_34275[(6)] = c__33696__auto__);

return statearr_34275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__))
);

return c__33696__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34293 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34293 = (function (ch,cs,meta34294){
this.ch = ch;
this.cs = cs;
this.meta34294 = meta34294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_34295,meta34294__$1){
var self__ = this;
var _34295__$1 = this;
return (new cljs.core.async.t_cljs$core$async34293(self__.ch,self__.cs,meta34294__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_34295){
var self__ = this;
var _34295__$1 = this;
return self__.meta34294;
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta34294","meta34294",1582094397,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async34293.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34293";

cljs.core.async.t_cljs$core$async34293.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async34293");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34293.
 */
cljs.core.async.__GT_t_cljs$core$async34293 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async34293(ch__$1,cs__$1,meta34294){
return (new cljs.core.async.t_cljs$core$async34293(ch__$1,cs__$1,meta34294));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async34293(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__33696__auto___34515 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34515,cs,m,dchan,dctr,done){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34515,cs,m,dchan,dctr,done){
return (function (state_34430){
var state_val_34431 = (state_34430[(1)]);
if((state_val_34431 === (7))){
var inst_34426 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34432_34516 = state_34430__$1;
(statearr_34432_34516[(2)] = inst_34426);

(statearr_34432_34516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (20))){
var inst_34329 = (state_34430[(7)]);
var inst_34341 = cljs.core.first.call(null,inst_34329);
var inst_34342 = cljs.core.nth.call(null,inst_34341,(0),null);
var inst_34343 = cljs.core.nth.call(null,inst_34341,(1),null);
var state_34430__$1 = (function (){var statearr_34433 = state_34430;
(statearr_34433[(8)] = inst_34342);

return statearr_34433;
})();
if(cljs.core.truth_(inst_34343)){
var statearr_34434_34517 = state_34430__$1;
(statearr_34434_34517[(1)] = (22));

} else {
var statearr_34435_34518 = state_34430__$1;
(statearr_34435_34518[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (27))){
var inst_34373 = (state_34430[(9)]);
var inst_34298 = (state_34430[(10)]);
var inst_34378 = (state_34430[(11)]);
var inst_34371 = (state_34430[(12)]);
var inst_34378__$1 = cljs.core._nth.call(null,inst_34371,inst_34373);
var inst_34379 = cljs.core.async.put_BANG_.call(null,inst_34378__$1,inst_34298,done);
var state_34430__$1 = (function (){var statearr_34436 = state_34430;
(statearr_34436[(11)] = inst_34378__$1);

return statearr_34436;
})();
if(cljs.core.truth_(inst_34379)){
var statearr_34437_34519 = state_34430__$1;
(statearr_34437_34519[(1)] = (30));

} else {
var statearr_34438_34520 = state_34430__$1;
(statearr_34438_34520[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (1))){
var state_34430__$1 = state_34430;
var statearr_34439_34521 = state_34430__$1;
(statearr_34439_34521[(2)] = null);

(statearr_34439_34521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (24))){
var inst_34329 = (state_34430[(7)]);
var inst_34348 = (state_34430[(2)]);
var inst_34349 = cljs.core.next.call(null,inst_34329);
var inst_34307 = inst_34349;
var inst_34308 = null;
var inst_34309 = (0);
var inst_34310 = (0);
var state_34430__$1 = (function (){var statearr_34440 = state_34430;
(statearr_34440[(13)] = inst_34310);

(statearr_34440[(14)] = inst_34308);

(statearr_34440[(15)] = inst_34307);

(statearr_34440[(16)] = inst_34348);

(statearr_34440[(17)] = inst_34309);

return statearr_34440;
})();
var statearr_34441_34522 = state_34430__$1;
(statearr_34441_34522[(2)] = null);

(statearr_34441_34522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (39))){
var state_34430__$1 = state_34430;
var statearr_34445_34523 = state_34430__$1;
(statearr_34445_34523[(2)] = null);

(statearr_34445_34523[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (4))){
var inst_34298 = (state_34430[(10)]);
var inst_34298__$1 = (state_34430[(2)]);
var inst_34299 = (inst_34298__$1 == null);
var state_34430__$1 = (function (){var statearr_34446 = state_34430;
(statearr_34446[(10)] = inst_34298__$1);

return statearr_34446;
})();
if(cljs.core.truth_(inst_34299)){
var statearr_34447_34524 = state_34430__$1;
(statearr_34447_34524[(1)] = (5));

} else {
var statearr_34448_34525 = state_34430__$1;
(statearr_34448_34525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (15))){
var inst_34310 = (state_34430[(13)]);
var inst_34308 = (state_34430[(14)]);
var inst_34307 = (state_34430[(15)]);
var inst_34309 = (state_34430[(17)]);
var inst_34325 = (state_34430[(2)]);
var inst_34326 = (inst_34310 + (1));
var tmp34442 = inst_34308;
var tmp34443 = inst_34307;
var tmp34444 = inst_34309;
var inst_34307__$1 = tmp34443;
var inst_34308__$1 = tmp34442;
var inst_34309__$1 = tmp34444;
var inst_34310__$1 = inst_34326;
var state_34430__$1 = (function (){var statearr_34449 = state_34430;
(statearr_34449[(13)] = inst_34310__$1);

(statearr_34449[(14)] = inst_34308__$1);

(statearr_34449[(18)] = inst_34325);

(statearr_34449[(15)] = inst_34307__$1);

(statearr_34449[(17)] = inst_34309__$1);

return statearr_34449;
})();
var statearr_34450_34526 = state_34430__$1;
(statearr_34450_34526[(2)] = null);

(statearr_34450_34526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (21))){
var inst_34352 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34454_34527 = state_34430__$1;
(statearr_34454_34527[(2)] = inst_34352);

(statearr_34454_34527[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (31))){
var inst_34378 = (state_34430[(11)]);
var inst_34382 = done.call(null,null);
var inst_34383 = cljs.core.async.untap_STAR_.call(null,m,inst_34378);
var state_34430__$1 = (function (){var statearr_34455 = state_34430;
(statearr_34455[(19)] = inst_34382);

return statearr_34455;
})();
var statearr_34456_34528 = state_34430__$1;
(statearr_34456_34528[(2)] = inst_34383);

(statearr_34456_34528[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (32))){
var inst_34372 = (state_34430[(20)]);
var inst_34373 = (state_34430[(9)]);
var inst_34370 = (state_34430[(21)]);
var inst_34371 = (state_34430[(12)]);
var inst_34385 = (state_34430[(2)]);
var inst_34386 = (inst_34373 + (1));
var tmp34451 = inst_34372;
var tmp34452 = inst_34370;
var tmp34453 = inst_34371;
var inst_34370__$1 = tmp34452;
var inst_34371__$1 = tmp34453;
var inst_34372__$1 = tmp34451;
var inst_34373__$1 = inst_34386;
var state_34430__$1 = (function (){var statearr_34457 = state_34430;
(statearr_34457[(20)] = inst_34372__$1);

(statearr_34457[(22)] = inst_34385);

(statearr_34457[(9)] = inst_34373__$1);

(statearr_34457[(21)] = inst_34370__$1);

(statearr_34457[(12)] = inst_34371__$1);

return statearr_34457;
})();
var statearr_34458_34529 = state_34430__$1;
(statearr_34458_34529[(2)] = null);

(statearr_34458_34529[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (40))){
var inst_34398 = (state_34430[(23)]);
var inst_34402 = done.call(null,null);
var inst_34403 = cljs.core.async.untap_STAR_.call(null,m,inst_34398);
var state_34430__$1 = (function (){var statearr_34459 = state_34430;
(statearr_34459[(24)] = inst_34402);

return statearr_34459;
})();
var statearr_34460_34530 = state_34430__$1;
(statearr_34460_34530[(2)] = inst_34403);

(statearr_34460_34530[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (33))){
var inst_34389 = (state_34430[(25)]);
var inst_34391 = cljs.core.chunked_seq_QMARK_.call(null,inst_34389);
var state_34430__$1 = state_34430;
if(inst_34391){
var statearr_34461_34531 = state_34430__$1;
(statearr_34461_34531[(1)] = (36));

} else {
var statearr_34462_34532 = state_34430__$1;
(statearr_34462_34532[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (13))){
var inst_34319 = (state_34430[(26)]);
var inst_34322 = cljs.core.async.close_BANG_.call(null,inst_34319);
var state_34430__$1 = state_34430;
var statearr_34463_34533 = state_34430__$1;
(statearr_34463_34533[(2)] = inst_34322);

(statearr_34463_34533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (22))){
var inst_34342 = (state_34430[(8)]);
var inst_34345 = cljs.core.async.close_BANG_.call(null,inst_34342);
var state_34430__$1 = state_34430;
var statearr_34464_34534 = state_34430__$1;
(statearr_34464_34534[(2)] = inst_34345);

(statearr_34464_34534[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (36))){
var inst_34389 = (state_34430[(25)]);
var inst_34393 = cljs.core.chunk_first.call(null,inst_34389);
var inst_34394 = cljs.core.chunk_rest.call(null,inst_34389);
var inst_34395 = cljs.core.count.call(null,inst_34393);
var inst_34370 = inst_34394;
var inst_34371 = inst_34393;
var inst_34372 = inst_34395;
var inst_34373 = (0);
var state_34430__$1 = (function (){var statearr_34465 = state_34430;
(statearr_34465[(20)] = inst_34372);

(statearr_34465[(9)] = inst_34373);

(statearr_34465[(21)] = inst_34370);

(statearr_34465[(12)] = inst_34371);

return statearr_34465;
})();
var statearr_34466_34535 = state_34430__$1;
(statearr_34466_34535[(2)] = null);

(statearr_34466_34535[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (41))){
var inst_34389 = (state_34430[(25)]);
var inst_34405 = (state_34430[(2)]);
var inst_34406 = cljs.core.next.call(null,inst_34389);
var inst_34370 = inst_34406;
var inst_34371 = null;
var inst_34372 = (0);
var inst_34373 = (0);
var state_34430__$1 = (function (){var statearr_34467 = state_34430;
(statearr_34467[(20)] = inst_34372);

(statearr_34467[(27)] = inst_34405);

(statearr_34467[(9)] = inst_34373);

(statearr_34467[(21)] = inst_34370);

(statearr_34467[(12)] = inst_34371);

return statearr_34467;
})();
var statearr_34468_34536 = state_34430__$1;
(statearr_34468_34536[(2)] = null);

(statearr_34468_34536[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (43))){
var state_34430__$1 = state_34430;
var statearr_34469_34537 = state_34430__$1;
(statearr_34469_34537[(2)] = null);

(statearr_34469_34537[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (29))){
var inst_34414 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34470_34538 = state_34430__$1;
(statearr_34470_34538[(2)] = inst_34414);

(statearr_34470_34538[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (44))){
var inst_34423 = (state_34430[(2)]);
var state_34430__$1 = (function (){var statearr_34471 = state_34430;
(statearr_34471[(28)] = inst_34423);

return statearr_34471;
})();
var statearr_34472_34539 = state_34430__$1;
(statearr_34472_34539[(2)] = null);

(statearr_34472_34539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (6))){
var inst_34362 = (state_34430[(29)]);
var inst_34361 = cljs.core.deref.call(null,cs);
var inst_34362__$1 = cljs.core.keys.call(null,inst_34361);
var inst_34363 = cljs.core.count.call(null,inst_34362__$1);
var inst_34364 = cljs.core.reset_BANG_.call(null,dctr,inst_34363);
var inst_34369 = cljs.core.seq.call(null,inst_34362__$1);
var inst_34370 = inst_34369;
var inst_34371 = null;
var inst_34372 = (0);
var inst_34373 = (0);
var state_34430__$1 = (function (){var statearr_34473 = state_34430;
(statearr_34473[(29)] = inst_34362__$1);

(statearr_34473[(30)] = inst_34364);

(statearr_34473[(20)] = inst_34372);

(statearr_34473[(9)] = inst_34373);

(statearr_34473[(21)] = inst_34370);

(statearr_34473[(12)] = inst_34371);

return statearr_34473;
})();
var statearr_34474_34540 = state_34430__$1;
(statearr_34474_34540[(2)] = null);

(statearr_34474_34540[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (28))){
var inst_34389 = (state_34430[(25)]);
var inst_34370 = (state_34430[(21)]);
var inst_34389__$1 = cljs.core.seq.call(null,inst_34370);
var state_34430__$1 = (function (){var statearr_34475 = state_34430;
(statearr_34475[(25)] = inst_34389__$1);

return statearr_34475;
})();
if(inst_34389__$1){
var statearr_34476_34541 = state_34430__$1;
(statearr_34476_34541[(1)] = (33));

} else {
var statearr_34477_34542 = state_34430__$1;
(statearr_34477_34542[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (25))){
var inst_34372 = (state_34430[(20)]);
var inst_34373 = (state_34430[(9)]);
var inst_34375 = (inst_34373 < inst_34372);
var inst_34376 = inst_34375;
var state_34430__$1 = state_34430;
if(cljs.core.truth_(inst_34376)){
var statearr_34478_34543 = state_34430__$1;
(statearr_34478_34543[(1)] = (27));

} else {
var statearr_34479_34544 = state_34430__$1;
(statearr_34479_34544[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (34))){
var state_34430__$1 = state_34430;
var statearr_34480_34545 = state_34430__$1;
(statearr_34480_34545[(2)] = null);

(statearr_34480_34545[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (17))){
var state_34430__$1 = state_34430;
var statearr_34481_34546 = state_34430__$1;
(statearr_34481_34546[(2)] = null);

(statearr_34481_34546[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (3))){
var inst_34428 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34430__$1,inst_34428);
} else {
if((state_val_34431 === (12))){
var inst_34357 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34482_34547 = state_34430__$1;
(statearr_34482_34547[(2)] = inst_34357);

(statearr_34482_34547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (2))){
var state_34430__$1 = state_34430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34430__$1,(4),ch);
} else {
if((state_val_34431 === (23))){
var state_34430__$1 = state_34430;
var statearr_34483_34548 = state_34430__$1;
(statearr_34483_34548[(2)] = null);

(statearr_34483_34548[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (35))){
var inst_34412 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34484_34549 = state_34430__$1;
(statearr_34484_34549[(2)] = inst_34412);

(statearr_34484_34549[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (19))){
var inst_34329 = (state_34430[(7)]);
var inst_34333 = cljs.core.chunk_first.call(null,inst_34329);
var inst_34334 = cljs.core.chunk_rest.call(null,inst_34329);
var inst_34335 = cljs.core.count.call(null,inst_34333);
var inst_34307 = inst_34334;
var inst_34308 = inst_34333;
var inst_34309 = inst_34335;
var inst_34310 = (0);
var state_34430__$1 = (function (){var statearr_34485 = state_34430;
(statearr_34485[(13)] = inst_34310);

(statearr_34485[(14)] = inst_34308);

(statearr_34485[(15)] = inst_34307);

(statearr_34485[(17)] = inst_34309);

return statearr_34485;
})();
var statearr_34486_34550 = state_34430__$1;
(statearr_34486_34550[(2)] = null);

(statearr_34486_34550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (11))){
var inst_34307 = (state_34430[(15)]);
var inst_34329 = (state_34430[(7)]);
var inst_34329__$1 = cljs.core.seq.call(null,inst_34307);
var state_34430__$1 = (function (){var statearr_34487 = state_34430;
(statearr_34487[(7)] = inst_34329__$1);

return statearr_34487;
})();
if(inst_34329__$1){
var statearr_34488_34551 = state_34430__$1;
(statearr_34488_34551[(1)] = (16));

} else {
var statearr_34489_34552 = state_34430__$1;
(statearr_34489_34552[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (9))){
var inst_34359 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34490_34553 = state_34430__$1;
(statearr_34490_34553[(2)] = inst_34359);

(statearr_34490_34553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (5))){
var inst_34305 = cljs.core.deref.call(null,cs);
var inst_34306 = cljs.core.seq.call(null,inst_34305);
var inst_34307 = inst_34306;
var inst_34308 = null;
var inst_34309 = (0);
var inst_34310 = (0);
var state_34430__$1 = (function (){var statearr_34491 = state_34430;
(statearr_34491[(13)] = inst_34310);

(statearr_34491[(14)] = inst_34308);

(statearr_34491[(15)] = inst_34307);

(statearr_34491[(17)] = inst_34309);

return statearr_34491;
})();
var statearr_34492_34554 = state_34430__$1;
(statearr_34492_34554[(2)] = null);

(statearr_34492_34554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (14))){
var state_34430__$1 = state_34430;
var statearr_34493_34555 = state_34430__$1;
(statearr_34493_34555[(2)] = null);

(statearr_34493_34555[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (45))){
var inst_34420 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34494_34556 = state_34430__$1;
(statearr_34494_34556[(2)] = inst_34420);

(statearr_34494_34556[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (26))){
var inst_34362 = (state_34430[(29)]);
var inst_34416 = (state_34430[(2)]);
var inst_34417 = cljs.core.seq.call(null,inst_34362);
var state_34430__$1 = (function (){var statearr_34495 = state_34430;
(statearr_34495[(31)] = inst_34416);

return statearr_34495;
})();
if(inst_34417){
var statearr_34496_34557 = state_34430__$1;
(statearr_34496_34557[(1)] = (42));

} else {
var statearr_34497_34558 = state_34430__$1;
(statearr_34497_34558[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (16))){
var inst_34329 = (state_34430[(7)]);
var inst_34331 = cljs.core.chunked_seq_QMARK_.call(null,inst_34329);
var state_34430__$1 = state_34430;
if(inst_34331){
var statearr_34498_34559 = state_34430__$1;
(statearr_34498_34559[(1)] = (19));

} else {
var statearr_34499_34560 = state_34430__$1;
(statearr_34499_34560[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (38))){
var inst_34409 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34500_34561 = state_34430__$1;
(statearr_34500_34561[(2)] = inst_34409);

(statearr_34500_34561[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (30))){
var state_34430__$1 = state_34430;
var statearr_34501_34562 = state_34430__$1;
(statearr_34501_34562[(2)] = null);

(statearr_34501_34562[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (10))){
var inst_34310 = (state_34430[(13)]);
var inst_34308 = (state_34430[(14)]);
var inst_34318 = cljs.core._nth.call(null,inst_34308,inst_34310);
var inst_34319 = cljs.core.nth.call(null,inst_34318,(0),null);
var inst_34320 = cljs.core.nth.call(null,inst_34318,(1),null);
var state_34430__$1 = (function (){var statearr_34502 = state_34430;
(statearr_34502[(26)] = inst_34319);

return statearr_34502;
})();
if(cljs.core.truth_(inst_34320)){
var statearr_34503_34563 = state_34430__$1;
(statearr_34503_34563[(1)] = (13));

} else {
var statearr_34504_34564 = state_34430__$1;
(statearr_34504_34564[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (18))){
var inst_34355 = (state_34430[(2)]);
var state_34430__$1 = state_34430;
var statearr_34505_34565 = state_34430__$1;
(statearr_34505_34565[(2)] = inst_34355);

(statearr_34505_34565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (42))){
var state_34430__$1 = state_34430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34430__$1,(45),dchan);
} else {
if((state_val_34431 === (37))){
var inst_34398 = (state_34430[(23)]);
var inst_34389 = (state_34430[(25)]);
var inst_34298 = (state_34430[(10)]);
var inst_34398__$1 = cljs.core.first.call(null,inst_34389);
var inst_34399 = cljs.core.async.put_BANG_.call(null,inst_34398__$1,inst_34298,done);
var state_34430__$1 = (function (){var statearr_34506 = state_34430;
(statearr_34506[(23)] = inst_34398__$1);

return statearr_34506;
})();
if(cljs.core.truth_(inst_34399)){
var statearr_34507_34566 = state_34430__$1;
(statearr_34507_34566[(1)] = (39));

} else {
var statearr_34508_34567 = state_34430__$1;
(statearr_34508_34567[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34431 === (8))){
var inst_34310 = (state_34430[(13)]);
var inst_34309 = (state_34430[(17)]);
var inst_34312 = (inst_34310 < inst_34309);
var inst_34313 = inst_34312;
var state_34430__$1 = state_34430;
if(cljs.core.truth_(inst_34313)){
var statearr_34509_34568 = state_34430__$1;
(statearr_34509_34568[(1)] = (10));

} else {
var statearr_34510_34569 = state_34430__$1;
(statearr_34510_34569[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___34515,cs,m,dchan,dctr,done))
;
return ((function (switch__33601__auto__,c__33696__auto___34515,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__33602__auto__ = null;
var cljs$core$async$mult_$_state_machine__33602__auto____0 = (function (){
var statearr_34511 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34511[(0)] = cljs$core$async$mult_$_state_machine__33602__auto__);

(statearr_34511[(1)] = (1));

return statearr_34511;
});
var cljs$core$async$mult_$_state_machine__33602__auto____1 = (function (state_34430){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34512){if((e34512 instanceof Object)){
var ex__33605__auto__ = e34512;
var statearr_34513_34570 = state_34430;
(statearr_34513_34570[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34571 = state_34430;
state_34430 = G__34571;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__33602__auto__ = function(state_34430){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__33602__auto____1.call(this,state_34430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__33602__auto____0;
cljs$core$async$mult_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__33602__auto____1;
return cljs$core$async$mult_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34515,cs,m,dchan,dctr,done))
})();
var state__33698__auto__ = (function (){var statearr_34514 = f__33697__auto__.call(null);
(statearr_34514[(6)] = c__33696__auto___34515);

return statearr_34514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34515,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__34573 = arguments.length;
switch (G__34573) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___34585 = arguments.length;
var i__4731__auto___34586 = (0);
while(true){
if((i__4731__auto___34586 < len__4730__auto___34585)){
args__4736__auto__.push((arguments[i__4731__auto___34586]));

var G__34587 = (i__4731__auto___34586 + (1));
i__4731__auto___34586 = G__34587;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__34579){
var map__34580 = p__34579;
var map__34580__$1 = (((((!((map__34580 == null))))?(((((map__34580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34580.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34580):map__34580);
var opts = map__34580__$1;
var statearr_34582_34588 = state;
(statearr_34582_34588[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,((function (map__34580,map__34580__$1,opts){
return (function (val){
var statearr_34583_34589 = state;
(statearr_34583_34589[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__34580,map__34580__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_34584_34590 = state;
(statearr_34584_34590[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq34575){
var G__34576 = cljs.core.first.call(null,seq34575);
var seq34575__$1 = cljs.core.next.call(null,seq34575);
var G__34577 = cljs.core.first.call(null,seq34575__$1);
var seq34575__$2 = cljs.core.next.call(null,seq34575__$1);
var G__34578 = cljs.core.first.call(null,seq34575__$2);
var seq34575__$3 = cljs.core.next.call(null,seq34575__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34576,G__34577,G__34578,seq34575__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34591 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34591 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta34592){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta34592 = meta34592;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34593,meta34592__$1){
var self__ = this;
var _34593__$1 = this;
return (new cljs.core.async.t_cljs$core$async34591(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta34592__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34593){
var self__ = this;
var _34593__$1 = this;
return self__.meta34592;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta34592","meta34592",-416813986,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34591.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34591.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34591";

cljs.core.async.t_cljs$core$async34591.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async34591");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34591.
 */
cljs.core.async.__GT_t_cljs$core$async34591 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async34591(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34592){
return (new cljs.core.async.t_cljs$core$async34591(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34592));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async34591(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33696__auto___34755 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_34695){
var state_val_34696 = (state_34695[(1)]);
if((state_val_34696 === (7))){
var inst_34610 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
var statearr_34697_34756 = state_34695__$1;
(statearr_34697_34756[(2)] = inst_34610);

(statearr_34697_34756[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (20))){
var inst_34622 = (state_34695[(7)]);
var state_34695__$1 = state_34695;
var statearr_34698_34757 = state_34695__$1;
(statearr_34698_34757[(2)] = inst_34622);

(statearr_34698_34757[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (27))){
var state_34695__$1 = state_34695;
var statearr_34699_34758 = state_34695__$1;
(statearr_34699_34758[(2)] = null);

(statearr_34699_34758[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (1))){
var inst_34597 = (state_34695[(8)]);
var inst_34597__$1 = calc_state.call(null);
var inst_34599 = (inst_34597__$1 == null);
var inst_34600 = cljs.core.not.call(null,inst_34599);
var state_34695__$1 = (function (){var statearr_34700 = state_34695;
(statearr_34700[(8)] = inst_34597__$1);

return statearr_34700;
})();
if(inst_34600){
var statearr_34701_34759 = state_34695__$1;
(statearr_34701_34759[(1)] = (2));

} else {
var statearr_34702_34760 = state_34695__$1;
(statearr_34702_34760[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (24))){
var inst_34646 = (state_34695[(9)]);
var inst_34655 = (state_34695[(10)]);
var inst_34669 = (state_34695[(11)]);
var inst_34669__$1 = inst_34646.call(null,inst_34655);
var state_34695__$1 = (function (){var statearr_34703 = state_34695;
(statearr_34703[(11)] = inst_34669__$1);

return statearr_34703;
})();
if(cljs.core.truth_(inst_34669__$1)){
var statearr_34704_34761 = state_34695__$1;
(statearr_34704_34761[(1)] = (29));

} else {
var statearr_34705_34762 = state_34695__$1;
(statearr_34705_34762[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (4))){
var inst_34613 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34613)){
var statearr_34706_34763 = state_34695__$1;
(statearr_34706_34763[(1)] = (8));

} else {
var statearr_34707_34764 = state_34695__$1;
(statearr_34707_34764[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (15))){
var inst_34640 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34640)){
var statearr_34708_34765 = state_34695__$1;
(statearr_34708_34765[(1)] = (19));

} else {
var statearr_34709_34766 = state_34695__$1;
(statearr_34709_34766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (21))){
var inst_34645 = (state_34695[(12)]);
var inst_34645__$1 = (state_34695[(2)]);
var inst_34646 = cljs.core.get.call(null,inst_34645__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_34647 = cljs.core.get.call(null,inst_34645__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_34648 = cljs.core.get.call(null,inst_34645__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_34695__$1 = (function (){var statearr_34710 = state_34695;
(statearr_34710[(13)] = inst_34647);

(statearr_34710[(9)] = inst_34646);

(statearr_34710[(12)] = inst_34645__$1);

return statearr_34710;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_34695__$1,(22),inst_34648);
} else {
if((state_val_34696 === (31))){
var inst_34677 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34677)){
var statearr_34711_34767 = state_34695__$1;
(statearr_34711_34767[(1)] = (32));

} else {
var statearr_34712_34768 = state_34695__$1;
(statearr_34712_34768[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (32))){
var inst_34654 = (state_34695[(14)]);
var state_34695__$1 = state_34695;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34695__$1,(35),out,inst_34654);
} else {
if((state_val_34696 === (33))){
var inst_34645 = (state_34695[(12)]);
var inst_34622 = inst_34645;
var state_34695__$1 = (function (){var statearr_34713 = state_34695;
(statearr_34713[(7)] = inst_34622);

return statearr_34713;
})();
var statearr_34714_34769 = state_34695__$1;
(statearr_34714_34769[(2)] = null);

(statearr_34714_34769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (13))){
var inst_34622 = (state_34695[(7)]);
var inst_34629 = inst_34622.cljs$lang$protocol_mask$partition0$;
var inst_34630 = (inst_34629 & (64));
var inst_34631 = inst_34622.cljs$core$ISeq$;
var inst_34632 = (cljs.core.PROTOCOL_SENTINEL === inst_34631);
var inst_34633 = ((inst_34630) || (inst_34632));
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34633)){
var statearr_34715_34770 = state_34695__$1;
(statearr_34715_34770[(1)] = (16));

} else {
var statearr_34716_34771 = state_34695__$1;
(statearr_34716_34771[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (22))){
var inst_34655 = (state_34695[(10)]);
var inst_34654 = (state_34695[(14)]);
var inst_34653 = (state_34695[(2)]);
var inst_34654__$1 = cljs.core.nth.call(null,inst_34653,(0),null);
var inst_34655__$1 = cljs.core.nth.call(null,inst_34653,(1),null);
var inst_34656 = (inst_34654__$1 == null);
var inst_34657 = cljs.core._EQ_.call(null,inst_34655__$1,change);
var inst_34658 = ((inst_34656) || (inst_34657));
var state_34695__$1 = (function (){var statearr_34717 = state_34695;
(statearr_34717[(10)] = inst_34655__$1);

(statearr_34717[(14)] = inst_34654__$1);

return statearr_34717;
})();
if(cljs.core.truth_(inst_34658)){
var statearr_34718_34772 = state_34695__$1;
(statearr_34718_34772[(1)] = (23));

} else {
var statearr_34719_34773 = state_34695__$1;
(statearr_34719_34773[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (36))){
var inst_34645 = (state_34695[(12)]);
var inst_34622 = inst_34645;
var state_34695__$1 = (function (){var statearr_34720 = state_34695;
(statearr_34720[(7)] = inst_34622);

return statearr_34720;
})();
var statearr_34721_34774 = state_34695__$1;
(statearr_34721_34774[(2)] = null);

(statearr_34721_34774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (29))){
var inst_34669 = (state_34695[(11)]);
var state_34695__$1 = state_34695;
var statearr_34722_34775 = state_34695__$1;
(statearr_34722_34775[(2)] = inst_34669);

(statearr_34722_34775[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (6))){
var state_34695__$1 = state_34695;
var statearr_34723_34776 = state_34695__$1;
(statearr_34723_34776[(2)] = false);

(statearr_34723_34776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (28))){
var inst_34665 = (state_34695[(2)]);
var inst_34666 = calc_state.call(null);
var inst_34622 = inst_34666;
var state_34695__$1 = (function (){var statearr_34724 = state_34695;
(statearr_34724[(15)] = inst_34665);

(statearr_34724[(7)] = inst_34622);

return statearr_34724;
})();
var statearr_34725_34777 = state_34695__$1;
(statearr_34725_34777[(2)] = null);

(statearr_34725_34777[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (25))){
var inst_34691 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
var statearr_34726_34778 = state_34695__$1;
(statearr_34726_34778[(2)] = inst_34691);

(statearr_34726_34778[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (34))){
var inst_34689 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
var statearr_34727_34779 = state_34695__$1;
(statearr_34727_34779[(2)] = inst_34689);

(statearr_34727_34779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (17))){
var state_34695__$1 = state_34695;
var statearr_34728_34780 = state_34695__$1;
(statearr_34728_34780[(2)] = false);

(statearr_34728_34780[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (3))){
var state_34695__$1 = state_34695;
var statearr_34729_34781 = state_34695__$1;
(statearr_34729_34781[(2)] = false);

(statearr_34729_34781[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (12))){
var inst_34693 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34695__$1,inst_34693);
} else {
if((state_val_34696 === (2))){
var inst_34597 = (state_34695[(8)]);
var inst_34602 = inst_34597.cljs$lang$protocol_mask$partition0$;
var inst_34603 = (inst_34602 & (64));
var inst_34604 = inst_34597.cljs$core$ISeq$;
var inst_34605 = (cljs.core.PROTOCOL_SENTINEL === inst_34604);
var inst_34606 = ((inst_34603) || (inst_34605));
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34606)){
var statearr_34730_34782 = state_34695__$1;
(statearr_34730_34782[(1)] = (5));

} else {
var statearr_34731_34783 = state_34695__$1;
(statearr_34731_34783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (23))){
var inst_34654 = (state_34695[(14)]);
var inst_34660 = (inst_34654 == null);
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34660)){
var statearr_34732_34784 = state_34695__$1;
(statearr_34732_34784[(1)] = (26));

} else {
var statearr_34733_34785 = state_34695__$1;
(statearr_34733_34785[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (35))){
var inst_34680 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
if(cljs.core.truth_(inst_34680)){
var statearr_34734_34786 = state_34695__$1;
(statearr_34734_34786[(1)] = (36));

} else {
var statearr_34735_34787 = state_34695__$1;
(statearr_34735_34787[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (19))){
var inst_34622 = (state_34695[(7)]);
var inst_34642 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34622);
var state_34695__$1 = state_34695;
var statearr_34736_34788 = state_34695__$1;
(statearr_34736_34788[(2)] = inst_34642);

(statearr_34736_34788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (11))){
var inst_34622 = (state_34695[(7)]);
var inst_34626 = (inst_34622 == null);
var inst_34627 = cljs.core.not.call(null,inst_34626);
var state_34695__$1 = state_34695;
if(inst_34627){
var statearr_34737_34789 = state_34695__$1;
(statearr_34737_34789[(1)] = (13));

} else {
var statearr_34738_34790 = state_34695__$1;
(statearr_34738_34790[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (9))){
var inst_34597 = (state_34695[(8)]);
var state_34695__$1 = state_34695;
var statearr_34739_34791 = state_34695__$1;
(statearr_34739_34791[(2)] = inst_34597);

(statearr_34739_34791[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (5))){
var state_34695__$1 = state_34695;
var statearr_34740_34792 = state_34695__$1;
(statearr_34740_34792[(2)] = true);

(statearr_34740_34792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (14))){
var state_34695__$1 = state_34695;
var statearr_34741_34793 = state_34695__$1;
(statearr_34741_34793[(2)] = false);

(statearr_34741_34793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (26))){
var inst_34655 = (state_34695[(10)]);
var inst_34662 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_34655);
var state_34695__$1 = state_34695;
var statearr_34742_34794 = state_34695__$1;
(statearr_34742_34794[(2)] = inst_34662);

(statearr_34742_34794[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (16))){
var state_34695__$1 = state_34695;
var statearr_34743_34795 = state_34695__$1;
(statearr_34743_34795[(2)] = true);

(statearr_34743_34795[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (38))){
var inst_34685 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
var statearr_34744_34796 = state_34695__$1;
(statearr_34744_34796[(2)] = inst_34685);

(statearr_34744_34796[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (30))){
var inst_34647 = (state_34695[(13)]);
var inst_34646 = (state_34695[(9)]);
var inst_34655 = (state_34695[(10)]);
var inst_34672 = cljs.core.empty_QMARK_.call(null,inst_34646);
var inst_34673 = inst_34647.call(null,inst_34655);
var inst_34674 = cljs.core.not.call(null,inst_34673);
var inst_34675 = ((inst_34672) && (inst_34674));
var state_34695__$1 = state_34695;
var statearr_34745_34797 = state_34695__$1;
(statearr_34745_34797[(2)] = inst_34675);

(statearr_34745_34797[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (10))){
var inst_34597 = (state_34695[(8)]);
var inst_34618 = (state_34695[(2)]);
var inst_34619 = cljs.core.get.call(null,inst_34618,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_34620 = cljs.core.get.call(null,inst_34618,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_34621 = cljs.core.get.call(null,inst_34618,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_34622 = inst_34597;
var state_34695__$1 = (function (){var statearr_34746 = state_34695;
(statearr_34746[(16)] = inst_34621);

(statearr_34746[(17)] = inst_34619);

(statearr_34746[(7)] = inst_34622);

(statearr_34746[(18)] = inst_34620);

return statearr_34746;
})();
var statearr_34747_34798 = state_34695__$1;
(statearr_34747_34798[(2)] = null);

(statearr_34747_34798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (18))){
var inst_34637 = (state_34695[(2)]);
var state_34695__$1 = state_34695;
var statearr_34748_34799 = state_34695__$1;
(statearr_34748_34799[(2)] = inst_34637);

(statearr_34748_34799[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (37))){
var state_34695__$1 = state_34695;
var statearr_34749_34800 = state_34695__$1;
(statearr_34749_34800[(2)] = null);

(statearr_34749_34800[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34696 === (8))){
var inst_34597 = (state_34695[(8)]);
var inst_34615 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34597);
var state_34695__$1 = state_34695;
var statearr_34750_34801 = state_34695__$1;
(statearr_34750_34801[(2)] = inst_34615);

(statearr_34750_34801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__33601__auto__,c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__33602__auto__ = null;
var cljs$core$async$mix_$_state_machine__33602__auto____0 = (function (){
var statearr_34751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34751[(0)] = cljs$core$async$mix_$_state_machine__33602__auto__);

(statearr_34751[(1)] = (1));

return statearr_34751;
});
var cljs$core$async$mix_$_state_machine__33602__auto____1 = (function (state_34695){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34752){if((e34752 instanceof Object)){
var ex__33605__auto__ = e34752;
var statearr_34753_34802 = state_34695;
(statearr_34753_34802[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34803 = state_34695;
state_34695 = G__34803;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__33602__auto__ = function(state_34695){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__33602__auto____1.call(this,state_34695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__33602__auto____0;
cljs$core$async$mix_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__33602__auto____1;
return cljs$core$async$mix_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__33698__auto__ = (function (){var statearr_34754 = f__33697__auto__.call(null);
(statearr_34754[(6)] = c__33696__auto___34755);

return statearr_34754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34755,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__34805 = arguments.length;
switch (G__34805) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__34809 = arguments.length;
switch (G__34809) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__34807_SHARP_){
if(cljs.core.truth_(p1__34807_SHARP_.call(null,topic))){
return p1__34807_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__34807_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async34810 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34810 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta34811){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta34811 = meta34811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_34812,meta34811__$1){
var self__ = this;
var _34812__$1 = this;
return (new cljs.core.async.t_cljs$core$async34810(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta34811__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_34812){
var self__ = this;
var _34812__$1 = this;
return self__.meta34811;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta34811","meta34811",-1774556745,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34810";

cljs.core.async.t_cljs$core$async34810.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async34810");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34810.
 */
cljs.core.async.__GT_t_cljs$core$async34810 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async34810(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34811){
return (new cljs.core.async.t_cljs$core$async34810(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34811));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async34810(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33696__auto___34930 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___34930,mults,ensure_mult,p){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___34930,mults,ensure_mult,p){
return (function (state_34884){
var state_val_34885 = (state_34884[(1)]);
if((state_val_34885 === (7))){
var inst_34880 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34886_34931 = state_34884__$1;
(statearr_34886_34931[(2)] = inst_34880);

(statearr_34886_34931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (20))){
var state_34884__$1 = state_34884;
var statearr_34887_34932 = state_34884__$1;
(statearr_34887_34932[(2)] = null);

(statearr_34887_34932[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (1))){
var state_34884__$1 = state_34884;
var statearr_34888_34933 = state_34884__$1;
(statearr_34888_34933[(2)] = null);

(statearr_34888_34933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (24))){
var inst_34863 = (state_34884[(7)]);
var inst_34872 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_34863);
var state_34884__$1 = state_34884;
var statearr_34889_34934 = state_34884__$1;
(statearr_34889_34934[(2)] = inst_34872);

(statearr_34889_34934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (4))){
var inst_34815 = (state_34884[(8)]);
var inst_34815__$1 = (state_34884[(2)]);
var inst_34816 = (inst_34815__$1 == null);
var state_34884__$1 = (function (){var statearr_34890 = state_34884;
(statearr_34890[(8)] = inst_34815__$1);

return statearr_34890;
})();
if(cljs.core.truth_(inst_34816)){
var statearr_34891_34935 = state_34884__$1;
(statearr_34891_34935[(1)] = (5));

} else {
var statearr_34892_34936 = state_34884__$1;
(statearr_34892_34936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (15))){
var inst_34857 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34893_34937 = state_34884__$1;
(statearr_34893_34937[(2)] = inst_34857);

(statearr_34893_34937[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (21))){
var inst_34877 = (state_34884[(2)]);
var state_34884__$1 = (function (){var statearr_34894 = state_34884;
(statearr_34894[(9)] = inst_34877);

return statearr_34894;
})();
var statearr_34895_34938 = state_34884__$1;
(statearr_34895_34938[(2)] = null);

(statearr_34895_34938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (13))){
var inst_34839 = (state_34884[(10)]);
var inst_34841 = cljs.core.chunked_seq_QMARK_.call(null,inst_34839);
var state_34884__$1 = state_34884;
if(inst_34841){
var statearr_34896_34939 = state_34884__$1;
(statearr_34896_34939[(1)] = (16));

} else {
var statearr_34897_34940 = state_34884__$1;
(statearr_34897_34940[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (22))){
var inst_34869 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
if(cljs.core.truth_(inst_34869)){
var statearr_34898_34941 = state_34884__$1;
(statearr_34898_34941[(1)] = (23));

} else {
var statearr_34899_34942 = state_34884__$1;
(statearr_34899_34942[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (6))){
var inst_34863 = (state_34884[(7)]);
var inst_34865 = (state_34884[(11)]);
var inst_34815 = (state_34884[(8)]);
var inst_34863__$1 = topic_fn.call(null,inst_34815);
var inst_34864 = cljs.core.deref.call(null,mults);
var inst_34865__$1 = cljs.core.get.call(null,inst_34864,inst_34863__$1);
var state_34884__$1 = (function (){var statearr_34900 = state_34884;
(statearr_34900[(7)] = inst_34863__$1);

(statearr_34900[(11)] = inst_34865__$1);

return statearr_34900;
})();
if(cljs.core.truth_(inst_34865__$1)){
var statearr_34901_34943 = state_34884__$1;
(statearr_34901_34943[(1)] = (19));

} else {
var statearr_34902_34944 = state_34884__$1;
(statearr_34902_34944[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (25))){
var inst_34874 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34903_34945 = state_34884__$1;
(statearr_34903_34945[(2)] = inst_34874);

(statearr_34903_34945[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (17))){
var inst_34839 = (state_34884[(10)]);
var inst_34848 = cljs.core.first.call(null,inst_34839);
var inst_34849 = cljs.core.async.muxch_STAR_.call(null,inst_34848);
var inst_34850 = cljs.core.async.close_BANG_.call(null,inst_34849);
var inst_34851 = cljs.core.next.call(null,inst_34839);
var inst_34825 = inst_34851;
var inst_34826 = null;
var inst_34827 = (0);
var inst_34828 = (0);
var state_34884__$1 = (function (){var statearr_34904 = state_34884;
(statearr_34904[(12)] = inst_34826);

(statearr_34904[(13)] = inst_34828);

(statearr_34904[(14)] = inst_34850);

(statearr_34904[(15)] = inst_34827);

(statearr_34904[(16)] = inst_34825);

return statearr_34904;
})();
var statearr_34905_34946 = state_34884__$1;
(statearr_34905_34946[(2)] = null);

(statearr_34905_34946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (3))){
var inst_34882 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34884__$1,inst_34882);
} else {
if((state_val_34885 === (12))){
var inst_34859 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34906_34947 = state_34884__$1;
(statearr_34906_34947[(2)] = inst_34859);

(statearr_34906_34947[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (2))){
var state_34884__$1 = state_34884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34884__$1,(4),ch);
} else {
if((state_val_34885 === (23))){
var state_34884__$1 = state_34884;
var statearr_34907_34948 = state_34884__$1;
(statearr_34907_34948[(2)] = null);

(statearr_34907_34948[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (19))){
var inst_34865 = (state_34884[(11)]);
var inst_34815 = (state_34884[(8)]);
var inst_34867 = cljs.core.async.muxch_STAR_.call(null,inst_34865);
var state_34884__$1 = state_34884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34884__$1,(22),inst_34867,inst_34815);
} else {
if((state_val_34885 === (11))){
var inst_34825 = (state_34884[(16)]);
var inst_34839 = (state_34884[(10)]);
var inst_34839__$1 = cljs.core.seq.call(null,inst_34825);
var state_34884__$1 = (function (){var statearr_34908 = state_34884;
(statearr_34908[(10)] = inst_34839__$1);

return statearr_34908;
})();
if(inst_34839__$1){
var statearr_34909_34949 = state_34884__$1;
(statearr_34909_34949[(1)] = (13));

} else {
var statearr_34910_34950 = state_34884__$1;
(statearr_34910_34950[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (9))){
var inst_34861 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34911_34951 = state_34884__$1;
(statearr_34911_34951[(2)] = inst_34861);

(statearr_34911_34951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (5))){
var inst_34822 = cljs.core.deref.call(null,mults);
var inst_34823 = cljs.core.vals.call(null,inst_34822);
var inst_34824 = cljs.core.seq.call(null,inst_34823);
var inst_34825 = inst_34824;
var inst_34826 = null;
var inst_34827 = (0);
var inst_34828 = (0);
var state_34884__$1 = (function (){var statearr_34912 = state_34884;
(statearr_34912[(12)] = inst_34826);

(statearr_34912[(13)] = inst_34828);

(statearr_34912[(15)] = inst_34827);

(statearr_34912[(16)] = inst_34825);

return statearr_34912;
})();
var statearr_34913_34952 = state_34884__$1;
(statearr_34913_34952[(2)] = null);

(statearr_34913_34952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (14))){
var state_34884__$1 = state_34884;
var statearr_34917_34953 = state_34884__$1;
(statearr_34917_34953[(2)] = null);

(statearr_34917_34953[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (16))){
var inst_34839 = (state_34884[(10)]);
var inst_34843 = cljs.core.chunk_first.call(null,inst_34839);
var inst_34844 = cljs.core.chunk_rest.call(null,inst_34839);
var inst_34845 = cljs.core.count.call(null,inst_34843);
var inst_34825 = inst_34844;
var inst_34826 = inst_34843;
var inst_34827 = inst_34845;
var inst_34828 = (0);
var state_34884__$1 = (function (){var statearr_34918 = state_34884;
(statearr_34918[(12)] = inst_34826);

(statearr_34918[(13)] = inst_34828);

(statearr_34918[(15)] = inst_34827);

(statearr_34918[(16)] = inst_34825);

return statearr_34918;
})();
var statearr_34919_34954 = state_34884__$1;
(statearr_34919_34954[(2)] = null);

(statearr_34919_34954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (10))){
var inst_34826 = (state_34884[(12)]);
var inst_34828 = (state_34884[(13)]);
var inst_34827 = (state_34884[(15)]);
var inst_34825 = (state_34884[(16)]);
var inst_34833 = cljs.core._nth.call(null,inst_34826,inst_34828);
var inst_34834 = cljs.core.async.muxch_STAR_.call(null,inst_34833);
var inst_34835 = cljs.core.async.close_BANG_.call(null,inst_34834);
var inst_34836 = (inst_34828 + (1));
var tmp34914 = inst_34826;
var tmp34915 = inst_34827;
var tmp34916 = inst_34825;
var inst_34825__$1 = tmp34916;
var inst_34826__$1 = tmp34914;
var inst_34827__$1 = tmp34915;
var inst_34828__$1 = inst_34836;
var state_34884__$1 = (function (){var statearr_34920 = state_34884;
(statearr_34920[(12)] = inst_34826__$1);

(statearr_34920[(17)] = inst_34835);

(statearr_34920[(13)] = inst_34828__$1);

(statearr_34920[(15)] = inst_34827__$1);

(statearr_34920[(16)] = inst_34825__$1);

return statearr_34920;
})();
var statearr_34921_34955 = state_34884__$1;
(statearr_34921_34955[(2)] = null);

(statearr_34921_34955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (18))){
var inst_34854 = (state_34884[(2)]);
var state_34884__$1 = state_34884;
var statearr_34922_34956 = state_34884__$1;
(statearr_34922_34956[(2)] = inst_34854);

(statearr_34922_34956[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34885 === (8))){
var inst_34828 = (state_34884[(13)]);
var inst_34827 = (state_34884[(15)]);
var inst_34830 = (inst_34828 < inst_34827);
var inst_34831 = inst_34830;
var state_34884__$1 = state_34884;
if(cljs.core.truth_(inst_34831)){
var statearr_34923_34957 = state_34884__$1;
(statearr_34923_34957[(1)] = (10));

} else {
var statearr_34924_34958 = state_34884__$1;
(statearr_34924_34958[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___34930,mults,ensure_mult,p))
;
return ((function (switch__33601__auto__,c__33696__auto___34930,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_34925 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34925[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_34925[(1)] = (1));

return statearr_34925;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_34884){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_34884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e34926){if((e34926 instanceof Object)){
var ex__33605__auto__ = e34926;
var statearr_34927_34959 = state_34884;
(statearr_34927_34959[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34960 = state_34884;
state_34884 = G__34960;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_34884){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_34884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___34930,mults,ensure_mult,p))
})();
var state__33698__auto__ = (function (){var statearr_34928 = f__33697__auto__.call(null);
(statearr_34928[(6)] = c__33696__auto___34930);

return statearr_34928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___34930,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__34962 = arguments.length;
switch (G__34962) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__34965 = arguments.length;
switch (G__34965) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__34968 = arguments.length;
switch (G__34968) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__33696__auto___35035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_35007){
var state_val_35008 = (state_35007[(1)]);
if((state_val_35008 === (7))){
var state_35007__$1 = state_35007;
var statearr_35009_35036 = state_35007__$1;
(statearr_35009_35036[(2)] = null);

(statearr_35009_35036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (1))){
var state_35007__$1 = state_35007;
var statearr_35010_35037 = state_35007__$1;
(statearr_35010_35037[(2)] = null);

(statearr_35010_35037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (4))){
var inst_34971 = (state_35007[(7)]);
var inst_34973 = (inst_34971 < cnt);
var state_35007__$1 = state_35007;
if(cljs.core.truth_(inst_34973)){
var statearr_35011_35038 = state_35007__$1;
(statearr_35011_35038[(1)] = (6));

} else {
var statearr_35012_35039 = state_35007__$1;
(statearr_35012_35039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (15))){
var inst_35003 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35013_35040 = state_35007__$1;
(statearr_35013_35040[(2)] = inst_35003);

(statearr_35013_35040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (13))){
var inst_34996 = cljs.core.async.close_BANG_.call(null,out);
var state_35007__$1 = state_35007;
var statearr_35014_35041 = state_35007__$1;
(statearr_35014_35041[(2)] = inst_34996);

(statearr_35014_35041[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (6))){
var state_35007__$1 = state_35007;
var statearr_35015_35042 = state_35007__$1;
(statearr_35015_35042[(2)] = null);

(statearr_35015_35042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (3))){
var inst_35005 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35007__$1,inst_35005);
} else {
if((state_val_35008 === (12))){
var inst_34993 = (state_35007[(8)]);
var inst_34993__$1 = (state_35007[(2)]);
var inst_34994 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_34993__$1);
var state_35007__$1 = (function (){var statearr_35016 = state_35007;
(statearr_35016[(8)] = inst_34993__$1);

return statearr_35016;
})();
if(cljs.core.truth_(inst_34994)){
var statearr_35017_35043 = state_35007__$1;
(statearr_35017_35043[(1)] = (13));

} else {
var statearr_35018_35044 = state_35007__$1;
(statearr_35018_35044[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (2))){
var inst_34970 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_34971 = (0);
var state_35007__$1 = (function (){var statearr_35019 = state_35007;
(statearr_35019[(7)] = inst_34971);

(statearr_35019[(9)] = inst_34970);

return statearr_35019;
})();
var statearr_35020_35045 = state_35007__$1;
(statearr_35020_35045[(2)] = null);

(statearr_35020_35045[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (11))){
var inst_34971 = (state_35007[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_35007,(10),Object,null,(9));
var inst_34980 = chs__$1.call(null,inst_34971);
var inst_34981 = done.call(null,inst_34971);
var inst_34982 = cljs.core.async.take_BANG_.call(null,inst_34980,inst_34981);
var state_35007__$1 = state_35007;
var statearr_35021_35046 = state_35007__$1;
(statearr_35021_35046[(2)] = inst_34982);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35007__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (9))){
var inst_34971 = (state_35007[(7)]);
var inst_34984 = (state_35007[(2)]);
var inst_34985 = (inst_34971 + (1));
var inst_34971__$1 = inst_34985;
var state_35007__$1 = (function (){var statearr_35022 = state_35007;
(statearr_35022[(7)] = inst_34971__$1);

(statearr_35022[(10)] = inst_34984);

return statearr_35022;
})();
var statearr_35023_35047 = state_35007__$1;
(statearr_35023_35047[(2)] = null);

(statearr_35023_35047[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (5))){
var inst_34991 = (state_35007[(2)]);
var state_35007__$1 = (function (){var statearr_35024 = state_35007;
(statearr_35024[(11)] = inst_34991);

return statearr_35024;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35007__$1,(12),dchan);
} else {
if((state_val_35008 === (14))){
var inst_34993 = (state_35007[(8)]);
var inst_34998 = cljs.core.apply.call(null,f,inst_34993);
var state_35007__$1 = state_35007;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35007__$1,(16),out,inst_34998);
} else {
if((state_val_35008 === (16))){
var inst_35000 = (state_35007[(2)]);
var state_35007__$1 = (function (){var statearr_35025 = state_35007;
(statearr_35025[(12)] = inst_35000);

return statearr_35025;
})();
var statearr_35026_35048 = state_35007__$1;
(statearr_35026_35048[(2)] = null);

(statearr_35026_35048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (10))){
var inst_34975 = (state_35007[(2)]);
var inst_34976 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_35007__$1 = (function (){var statearr_35027 = state_35007;
(statearr_35027[(13)] = inst_34975);

return statearr_35027;
})();
var statearr_35028_35049 = state_35007__$1;
(statearr_35028_35049[(2)] = inst_34976);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35007__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35008 === (8))){
var inst_34989 = (state_35007[(2)]);
var state_35007__$1 = state_35007;
var statearr_35029_35050 = state_35007__$1;
(statearr_35029_35050[(2)] = inst_34989);

(statearr_35029_35050[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__33601__auto__,c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35030 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35030[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35030[(1)] = (1));

return statearr_35030;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35007){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35031){if((e35031 instanceof Object)){
var ex__33605__auto__ = e35031;
var statearr_35032_35051 = state_35007;
(statearr_35032_35051[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35007);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35052 = state_35007;
state_35007 = G__35052;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35007){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__33698__auto__ = (function (){var statearr_35033 = f__33697__auto__.call(null);
(statearr_35033[(6)] = c__33696__auto___35035);

return statearr_35033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35035,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__35055 = arguments.length;
switch (G__35055) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35109 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35109,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35109,out){
return (function (state_35087){
var state_val_35088 = (state_35087[(1)]);
if((state_val_35088 === (7))){
var inst_35067 = (state_35087[(7)]);
var inst_35066 = (state_35087[(8)]);
var inst_35066__$1 = (state_35087[(2)]);
var inst_35067__$1 = cljs.core.nth.call(null,inst_35066__$1,(0),null);
var inst_35068 = cljs.core.nth.call(null,inst_35066__$1,(1),null);
var inst_35069 = (inst_35067__$1 == null);
var state_35087__$1 = (function (){var statearr_35089 = state_35087;
(statearr_35089[(7)] = inst_35067__$1);

(statearr_35089[(9)] = inst_35068);

(statearr_35089[(8)] = inst_35066__$1);

return statearr_35089;
})();
if(cljs.core.truth_(inst_35069)){
var statearr_35090_35110 = state_35087__$1;
(statearr_35090_35110[(1)] = (8));

} else {
var statearr_35091_35111 = state_35087__$1;
(statearr_35091_35111[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (1))){
var inst_35056 = cljs.core.vec.call(null,chs);
var inst_35057 = inst_35056;
var state_35087__$1 = (function (){var statearr_35092 = state_35087;
(statearr_35092[(10)] = inst_35057);

return statearr_35092;
})();
var statearr_35093_35112 = state_35087__$1;
(statearr_35093_35112[(2)] = null);

(statearr_35093_35112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (4))){
var inst_35057 = (state_35087[(10)]);
var state_35087__$1 = state_35087;
return cljs.core.async.ioc_alts_BANG_.call(null,state_35087__$1,(7),inst_35057);
} else {
if((state_val_35088 === (6))){
var inst_35083 = (state_35087[(2)]);
var state_35087__$1 = state_35087;
var statearr_35094_35113 = state_35087__$1;
(statearr_35094_35113[(2)] = inst_35083);

(statearr_35094_35113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (3))){
var inst_35085 = (state_35087[(2)]);
var state_35087__$1 = state_35087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35087__$1,inst_35085);
} else {
if((state_val_35088 === (2))){
var inst_35057 = (state_35087[(10)]);
var inst_35059 = cljs.core.count.call(null,inst_35057);
var inst_35060 = (inst_35059 > (0));
var state_35087__$1 = state_35087;
if(cljs.core.truth_(inst_35060)){
var statearr_35096_35114 = state_35087__$1;
(statearr_35096_35114[(1)] = (4));

} else {
var statearr_35097_35115 = state_35087__$1;
(statearr_35097_35115[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (11))){
var inst_35057 = (state_35087[(10)]);
var inst_35076 = (state_35087[(2)]);
var tmp35095 = inst_35057;
var inst_35057__$1 = tmp35095;
var state_35087__$1 = (function (){var statearr_35098 = state_35087;
(statearr_35098[(11)] = inst_35076);

(statearr_35098[(10)] = inst_35057__$1);

return statearr_35098;
})();
var statearr_35099_35116 = state_35087__$1;
(statearr_35099_35116[(2)] = null);

(statearr_35099_35116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (9))){
var inst_35067 = (state_35087[(7)]);
var state_35087__$1 = state_35087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35087__$1,(11),out,inst_35067);
} else {
if((state_val_35088 === (5))){
var inst_35081 = cljs.core.async.close_BANG_.call(null,out);
var state_35087__$1 = state_35087;
var statearr_35100_35117 = state_35087__$1;
(statearr_35100_35117[(2)] = inst_35081);

(statearr_35100_35117[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (10))){
var inst_35079 = (state_35087[(2)]);
var state_35087__$1 = state_35087;
var statearr_35101_35118 = state_35087__$1;
(statearr_35101_35118[(2)] = inst_35079);

(statearr_35101_35118[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35088 === (8))){
var inst_35067 = (state_35087[(7)]);
var inst_35057 = (state_35087[(10)]);
var inst_35068 = (state_35087[(9)]);
var inst_35066 = (state_35087[(8)]);
var inst_35071 = (function (){var cs = inst_35057;
var vec__35062 = inst_35066;
var v = inst_35067;
var c = inst_35068;
return ((function (cs,vec__35062,v,c,inst_35067,inst_35057,inst_35068,inst_35066,state_val_35088,c__33696__auto___35109,out){
return (function (p1__35053_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__35053_SHARP_);
});
;})(cs,vec__35062,v,c,inst_35067,inst_35057,inst_35068,inst_35066,state_val_35088,c__33696__auto___35109,out))
})();
var inst_35072 = cljs.core.filterv.call(null,inst_35071,inst_35057);
var inst_35057__$1 = inst_35072;
var state_35087__$1 = (function (){var statearr_35102 = state_35087;
(statearr_35102[(10)] = inst_35057__$1);

return statearr_35102;
})();
var statearr_35103_35119 = state_35087__$1;
(statearr_35103_35119[(2)] = null);

(statearr_35103_35119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35109,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35109,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35104 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35104[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35104[(1)] = (1));

return statearr_35104;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35087){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35105){if((e35105 instanceof Object)){
var ex__33605__auto__ = e35105;
var statearr_35106_35120 = state_35087;
(statearr_35106_35120[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35121 = state_35087;
state_35087 = G__35121;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35087){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35109,out))
})();
var state__33698__auto__ = (function (){var statearr_35107 = f__33697__auto__.call(null);
(statearr_35107[(6)] = c__33696__auto___35109);

return statearr_35107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35109,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__35123 = arguments.length;
switch (G__35123) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35168 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35168,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35168,out){
return (function (state_35147){
var state_val_35148 = (state_35147[(1)]);
if((state_val_35148 === (7))){
var inst_35129 = (state_35147[(7)]);
var inst_35129__$1 = (state_35147[(2)]);
var inst_35130 = (inst_35129__$1 == null);
var inst_35131 = cljs.core.not.call(null,inst_35130);
var state_35147__$1 = (function (){var statearr_35149 = state_35147;
(statearr_35149[(7)] = inst_35129__$1);

return statearr_35149;
})();
if(inst_35131){
var statearr_35150_35169 = state_35147__$1;
(statearr_35150_35169[(1)] = (8));

} else {
var statearr_35151_35170 = state_35147__$1;
(statearr_35151_35170[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (1))){
var inst_35124 = (0);
var state_35147__$1 = (function (){var statearr_35152 = state_35147;
(statearr_35152[(8)] = inst_35124);

return statearr_35152;
})();
var statearr_35153_35171 = state_35147__$1;
(statearr_35153_35171[(2)] = null);

(statearr_35153_35171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (4))){
var state_35147__$1 = state_35147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35147__$1,(7),ch);
} else {
if((state_val_35148 === (6))){
var inst_35142 = (state_35147[(2)]);
var state_35147__$1 = state_35147;
var statearr_35154_35172 = state_35147__$1;
(statearr_35154_35172[(2)] = inst_35142);

(statearr_35154_35172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (3))){
var inst_35144 = (state_35147[(2)]);
var inst_35145 = cljs.core.async.close_BANG_.call(null,out);
var state_35147__$1 = (function (){var statearr_35155 = state_35147;
(statearr_35155[(9)] = inst_35144);

return statearr_35155;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35147__$1,inst_35145);
} else {
if((state_val_35148 === (2))){
var inst_35124 = (state_35147[(8)]);
var inst_35126 = (inst_35124 < n);
var state_35147__$1 = state_35147;
if(cljs.core.truth_(inst_35126)){
var statearr_35156_35173 = state_35147__$1;
(statearr_35156_35173[(1)] = (4));

} else {
var statearr_35157_35174 = state_35147__$1;
(statearr_35157_35174[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (11))){
var inst_35124 = (state_35147[(8)]);
var inst_35134 = (state_35147[(2)]);
var inst_35135 = (inst_35124 + (1));
var inst_35124__$1 = inst_35135;
var state_35147__$1 = (function (){var statearr_35158 = state_35147;
(statearr_35158[(10)] = inst_35134);

(statearr_35158[(8)] = inst_35124__$1);

return statearr_35158;
})();
var statearr_35159_35175 = state_35147__$1;
(statearr_35159_35175[(2)] = null);

(statearr_35159_35175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (9))){
var state_35147__$1 = state_35147;
var statearr_35160_35176 = state_35147__$1;
(statearr_35160_35176[(2)] = null);

(statearr_35160_35176[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (5))){
var state_35147__$1 = state_35147;
var statearr_35161_35177 = state_35147__$1;
(statearr_35161_35177[(2)] = null);

(statearr_35161_35177[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (10))){
var inst_35139 = (state_35147[(2)]);
var state_35147__$1 = state_35147;
var statearr_35162_35178 = state_35147__$1;
(statearr_35162_35178[(2)] = inst_35139);

(statearr_35162_35178[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35148 === (8))){
var inst_35129 = (state_35147[(7)]);
var state_35147__$1 = state_35147;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35147__$1,(11),out,inst_35129);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35168,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35168,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35163 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35163[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35163[(1)] = (1));

return statearr_35163;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35147){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35164){if((e35164 instanceof Object)){
var ex__33605__auto__ = e35164;
var statearr_35165_35179 = state_35147;
(statearr_35165_35179[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35147);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35164;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35180 = state_35147;
state_35147 = G__35180;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35147){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35168,out))
})();
var state__33698__auto__ = (function (){var statearr_35166 = f__33697__auto__.call(null);
(statearr_35166[(6)] = c__33696__auto___35168);

return statearr_35166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35168,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35182 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35182 = (function (f,ch,meta35183){
this.f = f;
this.ch = ch;
this.meta35183 = meta35183;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35184,meta35183__$1){
var self__ = this;
var _35184__$1 = this;
return (new cljs.core.async.t_cljs$core$async35182(self__.f,self__.ch,meta35183__$1));
});

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35184){
var self__ = this;
var _35184__$1 = this;
return self__.meta35183;
});

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35185 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35185 = (function (f,ch,meta35183,_,fn1,meta35186){
this.f = f;
this.ch = ch;
this.meta35183 = meta35183;
this._ = _;
this.fn1 = fn1;
this.meta35186 = meta35186;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_35187,meta35186__$1){
var self__ = this;
var _35187__$1 = this;
return (new cljs.core.async.t_cljs$core$async35185(self__.f,self__.ch,self__.meta35183,self__._,self__.fn1,meta35186__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_35187){
var self__ = this;
var _35187__$1 = this;
return self__.meta35186;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__35181_SHARP_){
return f1.call(null,(((p1__35181_SHARP_ == null))?null:self__.f.call(null,p1__35181_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35183","meta35183",-1572395639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async35182","cljs.core.async/t_cljs$core$async35182",1996852775,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta35186","meta35186",-257868298,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35185.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35185.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35185";

cljs.core.async.t_cljs$core$async35185.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async35185");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35185.
 */
cljs.core.async.__GT_t_cljs$core$async35185 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35185(f__$1,ch__$1,meta35183__$1,___$2,fn1__$1,meta35186){
return (new cljs.core.async.t_cljs$core$async35185(f__$1,ch__$1,meta35183__$1,___$2,fn1__$1,meta35186));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async35185(self__.f,self__.ch,self__.meta35183,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35182.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async35182.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35183","meta35183",-1572395639,null)], null);
});

cljs.core.async.t_cljs$core$async35182.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35182.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35182";

cljs.core.async.t_cljs$core$async35182.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async35182");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35182.
 */
cljs.core.async.__GT_t_cljs$core$async35182 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35182(f__$1,ch__$1,meta35183){
return (new cljs.core.async.t_cljs$core$async35182(f__$1,ch__$1,meta35183));
});

}

return (new cljs.core.async.t_cljs$core$async35182(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35188 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35188 = (function (f,ch,meta35189){
this.f = f;
this.ch = ch;
this.meta35189 = meta35189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35190,meta35189__$1){
var self__ = this;
var _35190__$1 = this;
return (new cljs.core.async.t_cljs$core$async35188(self__.f,self__.ch,meta35189__$1));
});

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35190){
var self__ = this;
var _35190__$1 = this;
return self__.meta35189;
});

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35188.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async35188.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35189","meta35189",1317950385,null)], null);
});

cljs.core.async.t_cljs$core$async35188.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35188.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35188";

cljs.core.async.t_cljs$core$async35188.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async35188");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35188.
 */
cljs.core.async.__GT_t_cljs$core$async35188 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35188(f__$1,ch__$1,meta35189){
return (new cljs.core.async.t_cljs$core$async35188(f__$1,ch__$1,meta35189));
});

}

return (new cljs.core.async.t_cljs$core$async35188(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35191 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35191 = (function (p,ch,meta35192){
this.p = p;
this.ch = ch;
this.meta35192 = meta35192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35193,meta35192__$1){
var self__ = this;
var _35193__$1 = this;
return (new cljs.core.async.t_cljs$core$async35191(self__.p,self__.ch,meta35192__$1));
});

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35193){
var self__ = this;
var _35193__$1 = this;
return self__.meta35192;
});

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35191.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async35191.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35192","meta35192",-1174927231,null)], null);
});

cljs.core.async.t_cljs$core$async35191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35191";

cljs.core.async.t_cljs$core$async35191.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async35191");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35191.
 */
cljs.core.async.__GT_t_cljs$core$async35191 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35191(p__$1,ch__$1,meta35192){
return (new cljs.core.async.t_cljs$core$async35191(p__$1,ch__$1,meta35192));
});

}

return (new cljs.core.async.t_cljs$core$async35191(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__35195 = arguments.length;
switch (G__35195) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35235 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35235,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35235,out){
return (function (state_35216){
var state_val_35217 = (state_35216[(1)]);
if((state_val_35217 === (7))){
var inst_35212 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35218_35236 = state_35216__$1;
(statearr_35218_35236[(2)] = inst_35212);

(statearr_35218_35236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (1))){
var state_35216__$1 = state_35216;
var statearr_35219_35237 = state_35216__$1;
(statearr_35219_35237[(2)] = null);

(statearr_35219_35237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (4))){
var inst_35198 = (state_35216[(7)]);
var inst_35198__$1 = (state_35216[(2)]);
var inst_35199 = (inst_35198__$1 == null);
var state_35216__$1 = (function (){var statearr_35220 = state_35216;
(statearr_35220[(7)] = inst_35198__$1);

return statearr_35220;
})();
if(cljs.core.truth_(inst_35199)){
var statearr_35221_35238 = state_35216__$1;
(statearr_35221_35238[(1)] = (5));

} else {
var statearr_35222_35239 = state_35216__$1;
(statearr_35222_35239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (6))){
var inst_35198 = (state_35216[(7)]);
var inst_35203 = p.call(null,inst_35198);
var state_35216__$1 = state_35216;
if(cljs.core.truth_(inst_35203)){
var statearr_35223_35240 = state_35216__$1;
(statearr_35223_35240[(1)] = (8));

} else {
var statearr_35224_35241 = state_35216__$1;
(statearr_35224_35241[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (3))){
var inst_35214 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35216__$1,inst_35214);
} else {
if((state_val_35217 === (2))){
var state_35216__$1 = state_35216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35216__$1,(4),ch);
} else {
if((state_val_35217 === (11))){
var inst_35206 = (state_35216[(2)]);
var state_35216__$1 = state_35216;
var statearr_35225_35242 = state_35216__$1;
(statearr_35225_35242[(2)] = inst_35206);

(statearr_35225_35242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (9))){
var state_35216__$1 = state_35216;
var statearr_35226_35243 = state_35216__$1;
(statearr_35226_35243[(2)] = null);

(statearr_35226_35243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (5))){
var inst_35201 = cljs.core.async.close_BANG_.call(null,out);
var state_35216__$1 = state_35216;
var statearr_35227_35244 = state_35216__$1;
(statearr_35227_35244[(2)] = inst_35201);

(statearr_35227_35244[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (10))){
var inst_35209 = (state_35216[(2)]);
var state_35216__$1 = (function (){var statearr_35228 = state_35216;
(statearr_35228[(8)] = inst_35209);

return statearr_35228;
})();
var statearr_35229_35245 = state_35216__$1;
(statearr_35229_35245[(2)] = null);

(statearr_35229_35245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35217 === (8))){
var inst_35198 = (state_35216[(7)]);
var state_35216__$1 = state_35216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35216__$1,(11),out,inst_35198);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35235,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35235,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35230 = [null,null,null,null,null,null,null,null,null];
(statearr_35230[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35230[(1)] = (1));

return statearr_35230;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35216){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35231){if((e35231 instanceof Object)){
var ex__33605__auto__ = e35231;
var statearr_35232_35246 = state_35216;
(statearr_35232_35246[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35231;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35247 = state_35216;
state_35216 = G__35247;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35216){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35235,out))
})();
var state__33698__auto__ = (function (){var statearr_35233 = f__33697__auto__.call(null);
(statearr_35233[(6)] = c__33696__auto___35235);

return statearr_35233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35235,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__35249 = arguments.length;
switch (G__35249) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__){
return (function (state_35312){
var state_val_35313 = (state_35312[(1)]);
if((state_val_35313 === (7))){
var inst_35308 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
var statearr_35314_35352 = state_35312__$1;
(statearr_35314_35352[(2)] = inst_35308);

(statearr_35314_35352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (20))){
var inst_35278 = (state_35312[(7)]);
var inst_35289 = (state_35312[(2)]);
var inst_35290 = cljs.core.next.call(null,inst_35278);
var inst_35264 = inst_35290;
var inst_35265 = null;
var inst_35266 = (0);
var inst_35267 = (0);
var state_35312__$1 = (function (){var statearr_35315 = state_35312;
(statearr_35315[(8)] = inst_35265);

(statearr_35315[(9)] = inst_35266);

(statearr_35315[(10)] = inst_35264);

(statearr_35315[(11)] = inst_35289);

(statearr_35315[(12)] = inst_35267);

return statearr_35315;
})();
var statearr_35316_35353 = state_35312__$1;
(statearr_35316_35353[(2)] = null);

(statearr_35316_35353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (1))){
var state_35312__$1 = state_35312;
var statearr_35317_35354 = state_35312__$1;
(statearr_35317_35354[(2)] = null);

(statearr_35317_35354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (4))){
var inst_35253 = (state_35312[(13)]);
var inst_35253__$1 = (state_35312[(2)]);
var inst_35254 = (inst_35253__$1 == null);
var state_35312__$1 = (function (){var statearr_35318 = state_35312;
(statearr_35318[(13)] = inst_35253__$1);

return statearr_35318;
})();
if(cljs.core.truth_(inst_35254)){
var statearr_35319_35355 = state_35312__$1;
(statearr_35319_35355[(1)] = (5));

} else {
var statearr_35320_35356 = state_35312__$1;
(statearr_35320_35356[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (15))){
var state_35312__$1 = state_35312;
var statearr_35324_35357 = state_35312__$1;
(statearr_35324_35357[(2)] = null);

(statearr_35324_35357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (21))){
var state_35312__$1 = state_35312;
var statearr_35325_35358 = state_35312__$1;
(statearr_35325_35358[(2)] = null);

(statearr_35325_35358[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (13))){
var inst_35265 = (state_35312[(8)]);
var inst_35266 = (state_35312[(9)]);
var inst_35264 = (state_35312[(10)]);
var inst_35267 = (state_35312[(12)]);
var inst_35274 = (state_35312[(2)]);
var inst_35275 = (inst_35267 + (1));
var tmp35321 = inst_35265;
var tmp35322 = inst_35266;
var tmp35323 = inst_35264;
var inst_35264__$1 = tmp35323;
var inst_35265__$1 = tmp35321;
var inst_35266__$1 = tmp35322;
var inst_35267__$1 = inst_35275;
var state_35312__$1 = (function (){var statearr_35326 = state_35312;
(statearr_35326[(8)] = inst_35265__$1);

(statearr_35326[(9)] = inst_35266__$1);

(statearr_35326[(10)] = inst_35264__$1);

(statearr_35326[(14)] = inst_35274);

(statearr_35326[(12)] = inst_35267__$1);

return statearr_35326;
})();
var statearr_35327_35359 = state_35312__$1;
(statearr_35327_35359[(2)] = null);

(statearr_35327_35359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (22))){
var state_35312__$1 = state_35312;
var statearr_35328_35360 = state_35312__$1;
(statearr_35328_35360[(2)] = null);

(statearr_35328_35360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (6))){
var inst_35253 = (state_35312[(13)]);
var inst_35262 = f.call(null,inst_35253);
var inst_35263 = cljs.core.seq.call(null,inst_35262);
var inst_35264 = inst_35263;
var inst_35265 = null;
var inst_35266 = (0);
var inst_35267 = (0);
var state_35312__$1 = (function (){var statearr_35329 = state_35312;
(statearr_35329[(8)] = inst_35265);

(statearr_35329[(9)] = inst_35266);

(statearr_35329[(10)] = inst_35264);

(statearr_35329[(12)] = inst_35267);

return statearr_35329;
})();
var statearr_35330_35361 = state_35312__$1;
(statearr_35330_35361[(2)] = null);

(statearr_35330_35361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (17))){
var inst_35278 = (state_35312[(7)]);
var inst_35282 = cljs.core.chunk_first.call(null,inst_35278);
var inst_35283 = cljs.core.chunk_rest.call(null,inst_35278);
var inst_35284 = cljs.core.count.call(null,inst_35282);
var inst_35264 = inst_35283;
var inst_35265 = inst_35282;
var inst_35266 = inst_35284;
var inst_35267 = (0);
var state_35312__$1 = (function (){var statearr_35331 = state_35312;
(statearr_35331[(8)] = inst_35265);

(statearr_35331[(9)] = inst_35266);

(statearr_35331[(10)] = inst_35264);

(statearr_35331[(12)] = inst_35267);

return statearr_35331;
})();
var statearr_35332_35362 = state_35312__$1;
(statearr_35332_35362[(2)] = null);

(statearr_35332_35362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (3))){
var inst_35310 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35312__$1,inst_35310);
} else {
if((state_val_35313 === (12))){
var inst_35298 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
var statearr_35333_35363 = state_35312__$1;
(statearr_35333_35363[(2)] = inst_35298);

(statearr_35333_35363[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (2))){
var state_35312__$1 = state_35312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35312__$1,(4),in$);
} else {
if((state_val_35313 === (23))){
var inst_35306 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
var statearr_35334_35364 = state_35312__$1;
(statearr_35334_35364[(2)] = inst_35306);

(statearr_35334_35364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (19))){
var inst_35293 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
var statearr_35335_35365 = state_35312__$1;
(statearr_35335_35365[(2)] = inst_35293);

(statearr_35335_35365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (11))){
var inst_35278 = (state_35312[(7)]);
var inst_35264 = (state_35312[(10)]);
var inst_35278__$1 = cljs.core.seq.call(null,inst_35264);
var state_35312__$1 = (function (){var statearr_35336 = state_35312;
(statearr_35336[(7)] = inst_35278__$1);

return statearr_35336;
})();
if(inst_35278__$1){
var statearr_35337_35366 = state_35312__$1;
(statearr_35337_35366[(1)] = (14));

} else {
var statearr_35338_35367 = state_35312__$1;
(statearr_35338_35367[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (9))){
var inst_35300 = (state_35312[(2)]);
var inst_35301 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_35312__$1 = (function (){var statearr_35339 = state_35312;
(statearr_35339[(15)] = inst_35300);

return statearr_35339;
})();
if(cljs.core.truth_(inst_35301)){
var statearr_35340_35368 = state_35312__$1;
(statearr_35340_35368[(1)] = (21));

} else {
var statearr_35341_35369 = state_35312__$1;
(statearr_35341_35369[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (5))){
var inst_35256 = cljs.core.async.close_BANG_.call(null,out);
var state_35312__$1 = state_35312;
var statearr_35342_35370 = state_35312__$1;
(statearr_35342_35370[(2)] = inst_35256);

(statearr_35342_35370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (14))){
var inst_35278 = (state_35312[(7)]);
var inst_35280 = cljs.core.chunked_seq_QMARK_.call(null,inst_35278);
var state_35312__$1 = state_35312;
if(inst_35280){
var statearr_35343_35371 = state_35312__$1;
(statearr_35343_35371[(1)] = (17));

} else {
var statearr_35344_35372 = state_35312__$1;
(statearr_35344_35372[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (16))){
var inst_35296 = (state_35312[(2)]);
var state_35312__$1 = state_35312;
var statearr_35345_35373 = state_35312__$1;
(statearr_35345_35373[(2)] = inst_35296);

(statearr_35345_35373[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35313 === (10))){
var inst_35265 = (state_35312[(8)]);
var inst_35267 = (state_35312[(12)]);
var inst_35272 = cljs.core._nth.call(null,inst_35265,inst_35267);
var state_35312__$1 = state_35312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35312__$1,(13),out,inst_35272);
} else {
if((state_val_35313 === (18))){
var inst_35278 = (state_35312[(7)]);
var inst_35287 = cljs.core.first.call(null,inst_35278);
var state_35312__$1 = state_35312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35312__$1,(20),out,inst_35287);
} else {
if((state_val_35313 === (8))){
var inst_35266 = (state_35312[(9)]);
var inst_35267 = (state_35312[(12)]);
var inst_35269 = (inst_35267 < inst_35266);
var inst_35270 = inst_35269;
var state_35312__$1 = state_35312;
if(cljs.core.truth_(inst_35270)){
var statearr_35346_35374 = state_35312__$1;
(statearr_35346_35374[(1)] = (10));

} else {
var statearr_35347_35375 = state_35312__$1;
(statearr_35347_35375[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto__))
;
return ((function (switch__33601__auto__,c__33696__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____0 = (function (){
var statearr_35348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35348[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__);

(statearr_35348[(1)] = (1));

return statearr_35348;
});
var cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____1 = (function (state_35312){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35349){if((e35349 instanceof Object)){
var ex__33605__auto__ = e35349;
var statearr_35350_35376 = state_35312;
(statearr_35350_35376[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35377 = state_35312;
state_35312 = G__35377;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__ = function(state_35312){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____1.call(this,state_35312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__33602__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__))
})();
var state__33698__auto__ = (function (){var statearr_35351 = f__33697__auto__.call(null);
(statearr_35351[(6)] = c__33696__auto__);

return statearr_35351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__))
);

return c__33696__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__35379 = arguments.length;
switch (G__35379) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__35382 = arguments.length;
switch (G__35382) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__35385 = arguments.length;
switch (G__35385) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35432 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35432,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35432,out){
return (function (state_35409){
var state_val_35410 = (state_35409[(1)]);
if((state_val_35410 === (7))){
var inst_35404 = (state_35409[(2)]);
var state_35409__$1 = state_35409;
var statearr_35411_35433 = state_35409__$1;
(statearr_35411_35433[(2)] = inst_35404);

(statearr_35411_35433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (1))){
var inst_35386 = null;
var state_35409__$1 = (function (){var statearr_35412 = state_35409;
(statearr_35412[(7)] = inst_35386);

return statearr_35412;
})();
var statearr_35413_35434 = state_35409__$1;
(statearr_35413_35434[(2)] = null);

(statearr_35413_35434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (4))){
var inst_35389 = (state_35409[(8)]);
var inst_35389__$1 = (state_35409[(2)]);
var inst_35390 = (inst_35389__$1 == null);
var inst_35391 = cljs.core.not.call(null,inst_35390);
var state_35409__$1 = (function (){var statearr_35414 = state_35409;
(statearr_35414[(8)] = inst_35389__$1);

return statearr_35414;
})();
if(inst_35391){
var statearr_35415_35435 = state_35409__$1;
(statearr_35415_35435[(1)] = (5));

} else {
var statearr_35416_35436 = state_35409__$1;
(statearr_35416_35436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (6))){
var state_35409__$1 = state_35409;
var statearr_35417_35437 = state_35409__$1;
(statearr_35417_35437[(2)] = null);

(statearr_35417_35437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (3))){
var inst_35406 = (state_35409[(2)]);
var inst_35407 = cljs.core.async.close_BANG_.call(null,out);
var state_35409__$1 = (function (){var statearr_35418 = state_35409;
(statearr_35418[(9)] = inst_35406);

return statearr_35418;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35409__$1,inst_35407);
} else {
if((state_val_35410 === (2))){
var state_35409__$1 = state_35409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35409__$1,(4),ch);
} else {
if((state_val_35410 === (11))){
var inst_35389 = (state_35409[(8)]);
var inst_35398 = (state_35409[(2)]);
var inst_35386 = inst_35389;
var state_35409__$1 = (function (){var statearr_35419 = state_35409;
(statearr_35419[(10)] = inst_35398);

(statearr_35419[(7)] = inst_35386);

return statearr_35419;
})();
var statearr_35420_35438 = state_35409__$1;
(statearr_35420_35438[(2)] = null);

(statearr_35420_35438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (9))){
var inst_35389 = (state_35409[(8)]);
var state_35409__$1 = state_35409;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35409__$1,(11),out,inst_35389);
} else {
if((state_val_35410 === (5))){
var inst_35389 = (state_35409[(8)]);
var inst_35386 = (state_35409[(7)]);
var inst_35393 = cljs.core._EQ_.call(null,inst_35389,inst_35386);
var state_35409__$1 = state_35409;
if(inst_35393){
var statearr_35422_35439 = state_35409__$1;
(statearr_35422_35439[(1)] = (8));

} else {
var statearr_35423_35440 = state_35409__$1;
(statearr_35423_35440[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (10))){
var inst_35401 = (state_35409[(2)]);
var state_35409__$1 = state_35409;
var statearr_35424_35441 = state_35409__$1;
(statearr_35424_35441[(2)] = inst_35401);

(statearr_35424_35441[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35410 === (8))){
var inst_35386 = (state_35409[(7)]);
var tmp35421 = inst_35386;
var inst_35386__$1 = tmp35421;
var state_35409__$1 = (function (){var statearr_35425 = state_35409;
(statearr_35425[(7)] = inst_35386__$1);

return statearr_35425;
})();
var statearr_35426_35442 = state_35409__$1;
(statearr_35426_35442[(2)] = null);

(statearr_35426_35442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35432,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35432,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35427 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35427[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35427[(1)] = (1));

return statearr_35427;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35409){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35428){if((e35428 instanceof Object)){
var ex__33605__auto__ = e35428;
var statearr_35429_35443 = state_35409;
(statearr_35429_35443[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35428;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35444 = state_35409;
state_35409 = G__35444;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35409){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35432,out))
})();
var state__33698__auto__ = (function (){var statearr_35430 = f__33697__auto__.call(null);
(statearr_35430[(6)] = c__33696__auto___35432);

return statearr_35430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35432,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__35446 = arguments.length;
switch (G__35446) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35512,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35512,out){
return (function (state_35484){
var state_val_35485 = (state_35484[(1)]);
if((state_val_35485 === (7))){
var inst_35480 = (state_35484[(2)]);
var state_35484__$1 = state_35484;
var statearr_35486_35513 = state_35484__$1;
(statearr_35486_35513[(2)] = inst_35480);

(statearr_35486_35513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (1))){
var inst_35447 = (new Array(n));
var inst_35448 = inst_35447;
var inst_35449 = (0);
var state_35484__$1 = (function (){var statearr_35487 = state_35484;
(statearr_35487[(7)] = inst_35449);

(statearr_35487[(8)] = inst_35448);

return statearr_35487;
})();
var statearr_35488_35514 = state_35484__$1;
(statearr_35488_35514[(2)] = null);

(statearr_35488_35514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (4))){
var inst_35452 = (state_35484[(9)]);
var inst_35452__$1 = (state_35484[(2)]);
var inst_35453 = (inst_35452__$1 == null);
var inst_35454 = cljs.core.not.call(null,inst_35453);
var state_35484__$1 = (function (){var statearr_35489 = state_35484;
(statearr_35489[(9)] = inst_35452__$1);

return statearr_35489;
})();
if(inst_35454){
var statearr_35490_35515 = state_35484__$1;
(statearr_35490_35515[(1)] = (5));

} else {
var statearr_35491_35516 = state_35484__$1;
(statearr_35491_35516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (15))){
var inst_35474 = (state_35484[(2)]);
var state_35484__$1 = state_35484;
var statearr_35492_35517 = state_35484__$1;
(statearr_35492_35517[(2)] = inst_35474);

(statearr_35492_35517[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (13))){
var state_35484__$1 = state_35484;
var statearr_35493_35518 = state_35484__$1;
(statearr_35493_35518[(2)] = null);

(statearr_35493_35518[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (6))){
var inst_35449 = (state_35484[(7)]);
var inst_35470 = (inst_35449 > (0));
var state_35484__$1 = state_35484;
if(cljs.core.truth_(inst_35470)){
var statearr_35494_35519 = state_35484__$1;
(statearr_35494_35519[(1)] = (12));

} else {
var statearr_35495_35520 = state_35484__$1;
(statearr_35495_35520[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (3))){
var inst_35482 = (state_35484[(2)]);
var state_35484__$1 = state_35484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35484__$1,inst_35482);
} else {
if((state_val_35485 === (12))){
var inst_35448 = (state_35484[(8)]);
var inst_35472 = cljs.core.vec.call(null,inst_35448);
var state_35484__$1 = state_35484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35484__$1,(15),out,inst_35472);
} else {
if((state_val_35485 === (2))){
var state_35484__$1 = state_35484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35484__$1,(4),ch);
} else {
if((state_val_35485 === (11))){
var inst_35464 = (state_35484[(2)]);
var inst_35465 = (new Array(n));
var inst_35448 = inst_35465;
var inst_35449 = (0);
var state_35484__$1 = (function (){var statearr_35496 = state_35484;
(statearr_35496[(10)] = inst_35464);

(statearr_35496[(7)] = inst_35449);

(statearr_35496[(8)] = inst_35448);

return statearr_35496;
})();
var statearr_35497_35521 = state_35484__$1;
(statearr_35497_35521[(2)] = null);

(statearr_35497_35521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (9))){
var inst_35448 = (state_35484[(8)]);
var inst_35462 = cljs.core.vec.call(null,inst_35448);
var state_35484__$1 = state_35484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35484__$1,(11),out,inst_35462);
} else {
if((state_val_35485 === (5))){
var inst_35452 = (state_35484[(9)]);
var inst_35449 = (state_35484[(7)]);
var inst_35448 = (state_35484[(8)]);
var inst_35457 = (state_35484[(11)]);
var inst_35456 = (inst_35448[inst_35449] = inst_35452);
var inst_35457__$1 = (inst_35449 + (1));
var inst_35458 = (inst_35457__$1 < n);
var state_35484__$1 = (function (){var statearr_35498 = state_35484;
(statearr_35498[(12)] = inst_35456);

(statearr_35498[(11)] = inst_35457__$1);

return statearr_35498;
})();
if(cljs.core.truth_(inst_35458)){
var statearr_35499_35522 = state_35484__$1;
(statearr_35499_35522[(1)] = (8));

} else {
var statearr_35500_35523 = state_35484__$1;
(statearr_35500_35523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (14))){
var inst_35477 = (state_35484[(2)]);
var inst_35478 = cljs.core.async.close_BANG_.call(null,out);
var state_35484__$1 = (function (){var statearr_35502 = state_35484;
(statearr_35502[(13)] = inst_35477);

return statearr_35502;
})();
var statearr_35503_35524 = state_35484__$1;
(statearr_35503_35524[(2)] = inst_35478);

(statearr_35503_35524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (10))){
var inst_35468 = (state_35484[(2)]);
var state_35484__$1 = state_35484;
var statearr_35504_35525 = state_35484__$1;
(statearr_35504_35525[(2)] = inst_35468);

(statearr_35504_35525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35485 === (8))){
var inst_35448 = (state_35484[(8)]);
var inst_35457 = (state_35484[(11)]);
var tmp35501 = inst_35448;
var inst_35448__$1 = tmp35501;
var inst_35449 = inst_35457;
var state_35484__$1 = (function (){var statearr_35505 = state_35484;
(statearr_35505[(7)] = inst_35449);

(statearr_35505[(8)] = inst_35448__$1);

return statearr_35505;
})();
var statearr_35506_35526 = state_35484__$1;
(statearr_35506_35526[(2)] = null);

(statearr_35506_35526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35512,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35512,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35507 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35507[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35507[(1)] = (1));

return statearr_35507;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35484){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35508){if((e35508 instanceof Object)){
var ex__33605__auto__ = e35508;
var statearr_35509_35527 = state_35484;
(statearr_35509_35527[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35484);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35528 = state_35484;
state_35484 = G__35528;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35512,out))
})();
var state__33698__auto__ = (function (){var statearr_35510 = f__33697__auto__.call(null);
(statearr_35510[(6)] = c__33696__auto___35512);

return statearr_35510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35512,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__35530 = arguments.length;
switch (G__35530) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33696__auto___35600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___35600,out){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___35600,out){
return (function (state_35572){
var state_val_35573 = (state_35572[(1)]);
if((state_val_35573 === (7))){
var inst_35568 = (state_35572[(2)]);
var state_35572__$1 = state_35572;
var statearr_35574_35601 = state_35572__$1;
(statearr_35574_35601[(2)] = inst_35568);

(statearr_35574_35601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (1))){
var inst_35531 = [];
var inst_35532 = inst_35531;
var inst_35533 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_35572__$1 = (function (){var statearr_35575 = state_35572;
(statearr_35575[(7)] = inst_35533);

(statearr_35575[(8)] = inst_35532);

return statearr_35575;
})();
var statearr_35576_35602 = state_35572__$1;
(statearr_35576_35602[(2)] = null);

(statearr_35576_35602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (4))){
var inst_35536 = (state_35572[(9)]);
var inst_35536__$1 = (state_35572[(2)]);
var inst_35537 = (inst_35536__$1 == null);
var inst_35538 = cljs.core.not.call(null,inst_35537);
var state_35572__$1 = (function (){var statearr_35577 = state_35572;
(statearr_35577[(9)] = inst_35536__$1);

return statearr_35577;
})();
if(inst_35538){
var statearr_35578_35603 = state_35572__$1;
(statearr_35578_35603[(1)] = (5));

} else {
var statearr_35579_35604 = state_35572__$1;
(statearr_35579_35604[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (15))){
var inst_35562 = (state_35572[(2)]);
var state_35572__$1 = state_35572;
var statearr_35580_35605 = state_35572__$1;
(statearr_35580_35605[(2)] = inst_35562);

(statearr_35580_35605[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (13))){
var state_35572__$1 = state_35572;
var statearr_35581_35606 = state_35572__$1;
(statearr_35581_35606[(2)] = null);

(statearr_35581_35606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (6))){
var inst_35532 = (state_35572[(8)]);
var inst_35557 = inst_35532.length;
var inst_35558 = (inst_35557 > (0));
var state_35572__$1 = state_35572;
if(cljs.core.truth_(inst_35558)){
var statearr_35582_35607 = state_35572__$1;
(statearr_35582_35607[(1)] = (12));

} else {
var statearr_35583_35608 = state_35572__$1;
(statearr_35583_35608[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (3))){
var inst_35570 = (state_35572[(2)]);
var state_35572__$1 = state_35572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35572__$1,inst_35570);
} else {
if((state_val_35573 === (12))){
var inst_35532 = (state_35572[(8)]);
var inst_35560 = cljs.core.vec.call(null,inst_35532);
var state_35572__$1 = state_35572;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35572__$1,(15),out,inst_35560);
} else {
if((state_val_35573 === (2))){
var state_35572__$1 = state_35572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35572__$1,(4),ch);
} else {
if((state_val_35573 === (11))){
var inst_35536 = (state_35572[(9)]);
var inst_35540 = (state_35572[(10)]);
var inst_35550 = (state_35572[(2)]);
var inst_35551 = [];
var inst_35552 = inst_35551.push(inst_35536);
var inst_35532 = inst_35551;
var inst_35533 = inst_35540;
var state_35572__$1 = (function (){var statearr_35584 = state_35572;
(statearr_35584[(11)] = inst_35552);

(statearr_35584[(7)] = inst_35533);

(statearr_35584[(12)] = inst_35550);

(statearr_35584[(8)] = inst_35532);

return statearr_35584;
})();
var statearr_35585_35609 = state_35572__$1;
(statearr_35585_35609[(2)] = null);

(statearr_35585_35609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (9))){
var inst_35532 = (state_35572[(8)]);
var inst_35548 = cljs.core.vec.call(null,inst_35532);
var state_35572__$1 = state_35572;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35572__$1,(11),out,inst_35548);
} else {
if((state_val_35573 === (5))){
var inst_35536 = (state_35572[(9)]);
var inst_35533 = (state_35572[(7)]);
var inst_35540 = (state_35572[(10)]);
var inst_35540__$1 = f.call(null,inst_35536);
var inst_35541 = cljs.core._EQ_.call(null,inst_35540__$1,inst_35533);
var inst_35542 = cljs.core.keyword_identical_QMARK_.call(null,inst_35533,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_35543 = ((inst_35541) || (inst_35542));
var state_35572__$1 = (function (){var statearr_35586 = state_35572;
(statearr_35586[(10)] = inst_35540__$1);

return statearr_35586;
})();
if(cljs.core.truth_(inst_35543)){
var statearr_35587_35610 = state_35572__$1;
(statearr_35587_35610[(1)] = (8));

} else {
var statearr_35588_35611 = state_35572__$1;
(statearr_35588_35611[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (14))){
var inst_35565 = (state_35572[(2)]);
var inst_35566 = cljs.core.async.close_BANG_.call(null,out);
var state_35572__$1 = (function (){var statearr_35590 = state_35572;
(statearr_35590[(13)] = inst_35565);

return statearr_35590;
})();
var statearr_35591_35612 = state_35572__$1;
(statearr_35591_35612[(2)] = inst_35566);

(statearr_35591_35612[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (10))){
var inst_35555 = (state_35572[(2)]);
var state_35572__$1 = state_35572;
var statearr_35592_35613 = state_35572__$1;
(statearr_35592_35613[(2)] = inst_35555);

(statearr_35592_35613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35573 === (8))){
var inst_35536 = (state_35572[(9)]);
var inst_35540 = (state_35572[(10)]);
var inst_35532 = (state_35572[(8)]);
var inst_35545 = inst_35532.push(inst_35536);
var tmp35589 = inst_35532;
var inst_35532__$1 = tmp35589;
var inst_35533 = inst_35540;
var state_35572__$1 = (function (){var statearr_35593 = state_35572;
(statearr_35593[(14)] = inst_35545);

(statearr_35593[(7)] = inst_35533);

(statearr_35593[(8)] = inst_35532__$1);

return statearr_35593;
})();
var statearr_35594_35614 = state_35572__$1;
(statearr_35594_35614[(2)] = null);

(statearr_35594_35614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___35600,out))
;
return ((function (switch__33601__auto__,c__33696__auto___35600,out){
return (function() {
var cljs$core$async$state_machine__33602__auto__ = null;
var cljs$core$async$state_machine__33602__auto____0 = (function (){
var statearr_35595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35595[(0)] = cljs$core$async$state_machine__33602__auto__);

(statearr_35595[(1)] = (1));

return statearr_35595;
});
var cljs$core$async$state_machine__33602__auto____1 = (function (state_35572){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_35572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e35596){if((e35596 instanceof Object)){
var ex__33605__auto__ = e35596;
var statearr_35597_35615 = state_35572;
(statearr_35597_35615[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35616 = state_35572;
state_35572 = G__35616;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
cljs$core$async$state_machine__33602__auto__ = function(state_35572){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33602__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33602__auto____1.call(this,state_35572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33602__auto____0;
cljs$core$async$state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33602__auto____1;
return cljs$core$async$state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___35600,out))
})();
var state__33698__auto__ = (function (){var statearr_35598 = f__33697__auto__.call(null);
(statearr_35598[(6)] = c__33696__auto___35600);

return statearr_35598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___35600,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1571863659212
