(ns
  ^{:added "0.4.0"}
  mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node
  (:require [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node
             coerce
             comment
             fn
             forms
             integer
             keyword
             meta
             protocols
             quote
             reader-macro
             seq
             string
             token
             uneval
             whitespace]
            [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.potemkin :refer [import-vars]]))

;; ## API Facade

(import-vars
  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.protocols
   coerce
   children
   child-sexprs
   concat-strings
   inner?
   length
   printable-only?
   replace-children
   sexpr
   sexprs
   string
   tag]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.comment
   comment-node
   comment?]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.fn
   fn-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.forms
   forms-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.integer
   integer-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.keyword
   keyword-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.meta
   meta-node
   raw-meta-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.reader-macro
   deref-node
   eval-node
   reader-macro-node
   var-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.seq
   list-node
   map-node
   set-node
   vector-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.string
   string-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.quote
   quote-node
   syntax-quote-node
   unquote-node
   unquote-splicing-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.token
   token-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.uneval
   uneval-node]

  [mranderson045.cljfmt.v0v3v0.rewrite-clj.v0v4v12.rewrite-clj.node.whitespace
   comma-separated
   line-separated
   linebreak?
   newlines
   newline-node
   spaces
   whitespace-node
   whitespace?])

;; ## Predicates

(defn whitespace-or-comment?
  "Check whether the given node represents whitespace or comment."
  [node]
  (or (whitespace? node)
      (comment? node)))

;; ## Value

(defn ^{:deprecated "0.4.0"} value
  "DEPRECATED: Get first child as a pair of tag/sexpr (if inner node),
   or just the node's own sexpr. (use explicit analysis of `children`
   `child-sexprs` instead) "
  [node]
  (if (inner? node)
    (some-> (children node)
            (first)
            ((juxt tag sexpr)))
    (sexpr node)))
