(ns ^:no-doc cider.inlined-deps.cljfmt.v0v5v3.rewrite-clj.v0v4v12.rewrite-clj.node.string
  (:require [cider.inlined-deps.cljfmt.v0v5v3.rewrite-clj.v0v4v12.rewrite-clj.node.protocols :as node]
            [cider.inlined-deps.toolsreader.v0v10v0.clojure.tools.reader.edn :as edn]
            [clojure.string :as string]))

;; ## Node

(defn- wrap-string
  [s]
  (format "\"%s\"" s))

(defn- join-lines
  [lines]
  (string/join "\n" lines))

(defrecord StringNode [lines]
  node/Node
  (tag [_]
    (if (next lines)
      :multi-line
      :token))
  (printable-only? [_]
    false)
  (sexpr [_]
    (join-lines
      (map
        (comp edn/read-string wrap-string)
        lines)))
  (length [_]
    (+ 2 (reduce + (map count lines))))
  (string [_]
    (wrap-string (join-lines lines)))

  Object
  (toString [this]
    (node/string this)))

(node/make-printable! StringNode)

;; ## Constructors

(defn string-node
  "Create node representing a string value.
   Takes either a seq of strings or a single one."
  [lines]
  (if (string? lines)
    (->StringNode [lines])
    (->StringNode lines)))
