(ns cider.inlined-deps.toolsreader.v1v1v1.cljs.tools.reader.reader-types)

(defmacro log-source
  "If reader is a SourceLoggingPushbackReader, execute body in a source
  logging context. Otherwise, execute body, returning the result."
  [reader & body]
  `(if (and (source-logging-reader? ~reader)
            (not (cider.inlined-deps.toolsreader.v1v1v1.cljs.tools.reader.impl.utils/whitespace? (peek-char ~reader))))
     (log-source* ~reader (^:once fn* [] ~@body))
     (do ~@body)))