(ns cider.nrepl.middleware.resource
  (:require
   [cider.nrepl.middleware.util.error-handling :refer [with-safe-transport]]
   [cider.nrepl.inlined-deps.orchard.v0v5v0-beta10.orchard.misc :as u]
   [cider.nrepl.inlined-deps.orchard.v0v5v0-beta10.orchard.resource :as resource]))

(defn handle-resource [handler msg]
  (with-safe-transport handler msg
    "resource" {:resource-path (resource/resource-path (:name msg))}
    "resources-list" {:resources-list (u/transform-value (resource/resource-maps))}))
