/*
 * Decompiled with CFR 0.152.
 */
package cidernrepl0224SNAPSHOT.difflib.myers;

import cidernrepl0224SNAPSHOT.difflib.myers.DiffNode;
import cidernrepl0224SNAPSHOT.difflib.myers.DifferentiationFailedException;
import cidernrepl0224SNAPSHOT.difflib.myers.Equalizer;
import cidernrepl0224SNAPSHOT.difflib.myers.PathNode;
import cidernrepl0224SNAPSHOT.difflib.myers.Snake;
import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffAlgorithm;
import difflib.InsertDelta;
import difflib.Patch;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> DEFAULT_EQUALIZER = new Equalizer<T>(){

        @Override
        public boolean equals(T original, T revised) {
            return original.equals(revised);
        }
    };
    private final Equalizer<T> equalizer;

    public MyersDiff() {
        this.equalizer = this.DEFAULT_EQUALIZER;
    }

    public MyersDiff(Equalizer<T> equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException("equalizer must not be null");
        }
        this.equalizer = equalizer;
    }

    @Override
    public Patch<T> diff(T[] original, T[] revised) {
        return this.diff(Arrays.asList(original), Arrays.asList(revised));
    }

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        if (original == null) {
            throw new IllegalArgumentException("original list must not be null");
        }
        if (revised == null) {
            throw new IllegalArgumentException("revised list must not be null");
        }
        try {
            PathNode path = this.buildPath(original, revised);
            return this.buildRevision(path, original, revised);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            return new Patch();
        }
    }

    public PathNode buildPath(List<T> orig, List<T> rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    private boolean equals(T orig, T rev) {
        return this.equalizer.equals(orig, rev);
    }

    public Patch<T> buildRevision(PathNode path, List<T> orig, List<T> rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = null;
            delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch;
    }

    private List<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }

    public static <T> T[] copyOfRange2(T[] original, int from, int to) {
        return MyersDiff.copyOfRange2(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange2(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

