(ns cider.nrepl.middleware.classpath
  (:require
   [cider.nrepl.middleware.util.error-handling :refer [with-safe-transport]]
   [clojure.java.io :as io]
   [cider.nrepl.inlined-deps.orchard.v0v5v10.orchard.java.classpath :as cp]))

(defn classpath-reply [msg]
  {:classpath (->> (cp/classpath)
                   (map io/as-file)
                   (map str))})

(defn handle-classpath [handler msg]
  (with-safe-transport handler msg
    "classpath" classpath-reply))
