/*
 * Decompiled with CFR 0.152.
 */
package cidernrepl0371.difflib;

import cidernrepl0371.difflib.ChangeDelta;
import cidernrepl0371.difflib.Chunk;
import cidernrepl0371.difflib.DeleteDelta;
import cidernrepl0371.difflib.Delta;
import cidernrepl0371.difflib.DiffRow;
import cidernrepl0371.difflib.DiffUtils;
import cidernrepl0371.difflib.InsertDelta;
import cidernrepl0371.difflib.Patch;
import cidernrepl0371.difflib.StringUtills;
import cidernrepl0371.difflib.myers.Equalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffRowGenerator {
    private final boolean showInlineDiffs;
    private final boolean ignoreWhiteSpaces;
    private final boolean ignoreBlankLines;
    private final String InlineOldTag;
    private final String InlineNewTag;
    private final String InlineOldCssClass;
    private final String InlineNewCssClass;
    private final int columnWidth;
    private final Equalizer<String> equalizer;

    private DiffRowGenerator(Builder builder) {
        this.showInlineDiffs = builder.showInlineDiffs;
        this.ignoreWhiteSpaces = builder.ignoreWhiteSpaces;
        this.ignoreBlankLines = builder.ignoreBlankLines;
        this.InlineOldTag = builder.InlineOldTag;
        this.InlineNewTag = builder.InlineNewTag;
        this.InlineOldCssClass = builder.InlineOldCssClass;
        this.InlineNewCssClass = builder.InlineNewCssClass;
        this.columnWidth = builder.columnWidth;
        this.equalizer = new Equalizer<String>(){

            @Override
            public boolean equals(String original, String revised) {
                if (DiffRowGenerator.this.ignoreWhiteSpaces) {
                    original = original.trim().replaceAll("\\s+", " ");
                    revised = revised.trim().replaceAll("\\s+", " ");
                }
                return original.equals(revised);
            }
        };
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised) {
        return this.generateDiffRows(original, revised, DiffUtils.diff(original, revised, this.equalizer));
    }

    private List<String> removeBlankLines(List<String> lines2) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines2) {
            if (line.trim().length() == 0) {
                result.add("");
            }
            result.add(line);
        }
        return result;
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised, Patch<String> patch) {
        original = StringUtills.normalize(original);
        revised = StringUtills.normalize(revised);
        original = StringUtills.wrapText(original, this.columnWidth);
        revised = StringUtills.wrapText(revised, this.columnWidth);
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        int endPos = 0;
        List<Delta<String>> deltaList = patch.getDeltas();
        for (int i = 0; i < deltaList.size(); ++i) {
            int j;
            Delta<String> delta = deltaList.get(i);
            Chunk<String> orig = delta.getOriginal();
            Chunk<String> rev = delta.getRevised();
            orig.setLines(StringUtills.normalize(orig.getLines()));
            rev.setLines(StringUtills.normalize(rev.getLines()));
            orig.setLines(StringUtills.wrapText(orig.getLines(), this.columnWidth));
            rev.setLines(StringUtills.wrapText(rev.getLines(), this.columnWidth));
            for (String line : original.subList(endPos, orig.getPosition())) {
                diffRows.add(new DiffRow(DiffRow.Tag.EQUAL, line, line));
            }
            if (delta.getClass().equals(InsertDelta.class)) {
                endPos = orig.last() + 1;
                for (String line : rev.getLines()) {
                    diffRows.add(new DiffRow(DiffRow.Tag.INSERT, "", line));
                }
                continue;
            }
            if (delta.getClass().equals(DeleteDelta.class)) {
                endPos = orig.last() + 1;
                for (String line : orig.getLines()) {
                    diffRows.add(new DiffRow(DiffRow.Tag.DELETE, line, ""));
                }
                continue;
            }
            if (this.showInlineDiffs) {
                this.addInlineDiffs(delta);
            }
            if (orig.size() == rev.size()) {
                for (j = 0; j < orig.size(); ++j) {
                    diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orig.getLines().get(j), rev.getLines().get(j)));
                }
            } else if (orig.size() > rev.size()) {
                for (j = 0; j < orig.size(); ++j) {
                    diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orig.getLines().get(j), rev.getLines().size() > j ? rev.getLines().get(j) : ""));
                }
            } else {
                for (j = 0; j < rev.size(); ++j) {
                    diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orig.getLines().size() > j ? orig.getLines().get(j) : "", rev.getLines().get(j)));
                }
            }
            endPos = orig.last() + 1;
        }
        for (String line : original.subList(endPos, original.size())) {
            diffRows.add(new DiffRow(DiffRow.Tag.EQUAL, line, line));
        }
        return diffRows;
    }

    private void addInlineDiffs(Delta<String> delta) {
        List<String> orig = delta.getOriginal().getLines();
        List<String> rev = delta.getRevised().getLines();
        LinkedList<String> origList = new LinkedList<String>();
        char[] arr$ = DiffRowGenerator.join(orig, "\n").toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character character = Character.valueOf(arr$[i$]);
            origList.add(character.toString());
        }
        LinkedList<String> revList = new LinkedList<String>();
        char[] arr$2 = DiffRowGenerator.join(rev, "\n").toCharArray();
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            Character character = Character.valueOf(arr$2[i$]);
            revList.add(character.toString());
        }
        List inlineDeltas = DiffUtils.diff(origList, revList).getDeltas();
        if (inlineDeltas.size() < 3) {
            Collections.reverse(inlineDeltas);
            for (Delta inlineDelta : inlineDeltas) {
                Chunk inlineOrig = inlineDelta.getOriginal();
                Chunk inlineRev = inlineDelta.getRevised();
                if (inlineDelta.getClass().equals(DeleteDelta.class)) {
                    origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.InlineOldTag, this.InlineOldCssClass);
                    continue;
                }
                if (inlineDelta.getClass().equals(InsertDelta.class)) {
                    revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.InlineNewTag, this.InlineNewCssClass);
                    continue;
                }
                if (!inlineDelta.getClass().equals(ChangeDelta.class)) continue;
                origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.InlineOldTag, this.InlineOldCssClass);
                revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.InlineNewTag, this.InlineNewCssClass);
            }
            StringBuilder origResult = new StringBuilder();
            StringBuilder revResult = new StringBuilder();
            for (String character : origList) {
                origResult.append(character);
            }
            for (String character : revList) {
                revResult.append(character);
            }
            delta.getOriginal().setLines(Arrays.asList(origResult.toString().split("\n")));
            delta.getRevised().setLines(Arrays.asList(revResult.toString().split("\n")));
        }
    }

    public static LinkedList<String> wrapInTag(LinkedList<String> sequence, int startPosition, int endPosition, String tag2, String cssClass) {
        LinkedList result = (LinkedList)sequence.clone();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag2);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag2);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        result.add(startPosition, startTag);
        result.add(endPosition, endTag);
        return result;
    }

    public static String wrapInTag(String line, String tag2, String cssClass) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag2);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag2);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        return startTag + line + endTag;
    }

    private static <T> String join(Iterable<T> objs, String delimiter) {
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public static class Builder {
        private boolean showInlineDiffs = false;
        private boolean ignoreWhiteSpaces = false;
        private boolean ignoreBlankLines = false;
        private String InlineOldTag = "span";
        private String InlineNewTag = "span";
        private String InlineOldCssClass = "editOldInline";
        private String InlineNewCssClass = "editNewInline";
        private int columnWidth = 80;

        public Builder showInlineDiffs(boolean val) {
            this.showInlineDiffs = val;
            return this;
        }

        public Builder ignoreWhiteSpaces(boolean val) {
            this.ignoreWhiteSpaces = val;
            return this;
        }

        public Builder ignoreBlankLines(boolean val) {
            this.ignoreBlankLines = val;
            return this;
        }

        public Builder InlineOldTag(String tag2) {
            this.InlineOldTag = tag2;
            return this;
        }

        public Builder InlineNewTag(String tag2) {
            this.InlineNewTag = tag2;
            return this;
        }

        public Builder InlineOldCssClass(String cssClass) {
            this.InlineOldCssClass = cssClass;
            return this;
        }

        public Builder InlineNewCssClass(String cssClass) {
            this.InlineNewCssClass = cssClass;
            return this;
        }

        public Builder columnWidth(int width) {
            if (width > 0) {
                this.columnWidth = width;
            }
            return this;
        }

        public DiffRowGenerator build() {
            return new DiffRowGenerator(this);
        }
    }
}

