(ns cider.nrepl.middleware.xref
  (:require [clojure.repl :as repl]))

(defn- recursive-contains? [coll obj]
  "True if coll contains obj. Obj can't be a seq"
  (not (empty? (filter #(= obj %) (flatten coll)))))

(defn- var-name [var]
  (let [var-meta (meta var)
        name (:name var-meta)
        ns (str (:ns var-meta))]
    (when (and name ns)
      (symbol (str ns "/" name)))))

(defn- does-var-call-fn [var fn]
  "Checks if a var calls a function named 'fn"
  (if-let [name (var-name var)]
    (if-let [source (repl/source-fn name)]
               (let [node (read-string source)]
                 (if (recursive-contains? node fn)
                   var
                   false)))))

(defn- does-ns-refer-to-var? [ns var]
  (ns-resolve ns var))

(defn all-vars-who-call [sym]
  (filter
   ifn?
   (filter
    #(identity %)
    (map #(does-var-call-fn % sym)
         (flatten
          (map vals
               (map ns-interns
                    (filter #(does-ns-refer-to-var? % sym)
                            (all-ns)))))))))
