(ns ^:no-doc deps.cljfmt.v0v1v10.deps.rewrite-clj.v0v4v12.rewrite-clj.parser.keyword
  (:require [deps.cljfmt.v0v1v10.deps.rewrite-clj.v0v4v12.rewrite-clj.node :as node]
            [deps.cljfmt.v0v1v10.deps.rewrite-clj.v0v4v12.rewrite-clj.parser.utils :as u]
            [deps.toolsreader.v0v9v1.clojure.tools.reader
             [edn :as edn]
             [reader-types :as r]]))

(defn parse-keyword
  [reader]
  (u/ignore reader)
  (if-let [c (r/peek-char reader)]
    (if (= c \:)
      (node/keyword-node
        (edn/read reader)
        true)
      (do
        (r/unread reader \:)
        (node/keyword-node (edn/read reader))))
    (u/throw-reader reader "unexpected EOF while reading keyword.")))
