(ns deps.compliment.v0v2v2-20150420v104236-2.compliment.sources.keywords
  "Completion for keywords interned globally across the application"
  (:require [deps.compliment.v0v2v2-20150420v104236-2.compliment.sources :refer [defsource]]
            [deps.compliment.v0v2v2-20150420v104236-2.compliment.utils :refer [defmemoized]])
  (:import java.lang.reflect.Field))

(defmemoized ^:private keywords-table
  []
  (let [^Field field (.getDeclaredField clojure.lang.Keyword "table")]
    (.setAccessible field true)
    (.get field nil)))

(defn candidates
  [prefix _ _]
  (when (= (first prefix) \:)
    (for [[kw _] (keywords-table)
          :when (.startsWith (str kw) (subs prefix 1))]
      (str ":" kw))))

(defsource ::keywords
  :candidates #'candidates
  :doc (constantly nil)
  :tag-fn (fn [m _] (assoc m :type :keyword)))
