(ns circle.util.except
  (:use [slingshot.slingshot :only (throw+)]))

(defn throwf [& args]
  (throw (Exception. (apply format args))))

(defmacro throw-if [test & format-args]
  `(when ~test
     (throwf ~@format-args)))

(defmacro throw-if+ [test data str & format]
  `(when ~test
     (throw+ ~data ~str ~@format)))

(defmacro throw-if-not [test & format-args]
  `(when (not ~test)
     (throwf ~@format-args)))

(defmacro throw-if-not+ [test data str & format]
  `(when (not ~test)
     (throw+ ~data ~str ~@format)))