(ns circle.util.stateful-fn
  (:require [circle.util.except :refer (throwf)]))

(defn stateful-fn*
  "Takes a seq of no argument fns. Returns a new fn that calls each fn in turn."
  [fns]
  (let [state (atom fns)]
    (fn [& _]
      (if (not (zero? (count @state)))
        (let [f (first @state)]
          (try
            (apply f [])
            (finally
             (swap! state rest))))
        (throwf "no more values")))))

(defmacro thunk-exprs
  "Takes a seq of unevaluated exprs. Returns a seq of no argument fns, that call each of the exprs in turn"
  [exprs]
  (into [] (map (fn [v]
                  `(fn []
                     ~v)) exprs)))

(defmacro stateful-fn
  "Takes a seq of unevaluated expressions. Returns a function that evaluates and returns each expression in turn. Throws if stateful-fn is called more times than there are values provided."
  [& exprs]
  `(stateful-fn* (thunk-exprs ~exprs)))