(ns citizen.os
  (require [clojure.string :as string]))

(def ^:private raw-os (System/getProperty "os.name"))
(def ^:private os (string/lower-case raw-os))

(def linux? (.startsWith ^String os "linux"))
(def mac? (.startsWith ^String os "mac"))
(def windows? (.startsWith ^String os "windows"))
(def unix? (not windows?)) ;Pretty dumb assumption

(defn with-os [os body]
  (case os
    (:linux :nux) (cond linux? body)
    (:mac :osx :darwin) (cond mac? body)
    (:windows :win) (cond windows? body)
    (:unix :nix) (cond unix? body)
    nil))

(defn with-os-linux [body]
  (with-os :linux body))

(defn with-os-mac [body]
  (with-os :mac body))

(defn with-os-windows [body]
  (with-os :windows body))

(defn with-os-unix [body]
  (with-os :unix body))
