(ns citizen.os)

(def ^:private os (System/getProperty "os.name"))

(def linux? (.startsWith ^String os "Linux"))
(def mac? (.startsWith ^String os "Mac"))
(def windows? (.startsWith ^String os "Windows"))
(def unix? (not windows?)) ;Pretty dumb assumption

(defn with-os [os body]
  (case os
    (:linux :nux) (cond linux? body)
    (:mac :osx :darwin) (cond mac? body)
    (:windows :win) (cond windows? body)
    (:unix :nix) (cond unix? body)
    nil))

(defn with-os-linux [body]
  (with-os :linux body))

(defn with-os-mac [body]
  (with-os :mac body))

(defn with-os-windows [body]
  (with-os :windows body))

(defn with-os-unix [body]
  (with-os :unix body))
