/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.dann.math;

import java.io.Serializable;
import java.util.List;

public class Vector
implements Serializable {
    private static final long serialVersionUID = -1488734312355605257L;
    private final double[] coordinates;
    private static final String DIMENSIONS_BELOW_ONE = "dimensions can not be less than or equal to zero";
    private Double distanceCache = null;

    public Vector(int dimensions) {
        if (dimensions <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        this.coordinates = new double[dimensions];
    }

    public Vector(double ... coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates can not be null!");
        }
        if (coordinates.length <= 0) {
            throw new IllegalArgumentException("coordinates must have atleast one member, 0 dimensions isnt valid!");
        }
        this.coordinates = (double[])coordinates.clone();
    }

    public Vector(List<Double> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates can not be null!");
        }
        if (coordinates.size() <= 0) {
            throw new IllegalArgumentException("coordinates must have atleast one member, 0 dimensions isnt valid!");
        }
        this.coordinates = new double[coordinates.size()];
        int coordinatesIndex = 0;
        for (Double coordinate : coordinates) {
            this.coordinates[coordinatesIndex++] = coordinate;
        }
    }

    public Vector(Vector copy) {
        this.coordinates = (double[])copy.coordinates.clone();
    }

    public int getDimensions() {
        return this.coordinates.length;
    }

    public Vector setCoordinate(double coordinate, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality of this point");
        }
        double[] coords = (double[])this.coordinates.clone();
        coords[dimension - 1] = coordinate;
        return new Vector(coords);
    }

    public double getCoordinate(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality of this point");
        }
        return this.coordinates[dimension - 1];
    }

    public Vector setDistance(double distance) {
        Vector newVector = new Vector(this.coordinates);
        double[] newCoords = newVector.coordinates;
        double oldDistance = this.getDistance();
        double scalar = distance / oldDistance;
        int newCoordsIndex = 0;
        while (newCoordsIndex < newCoords.length) {
            int n = newCoordsIndex++;
            newCoords[n] = newCoords[n] * scalar;
        }
        return newVector;
    }

    public Vector setAngularComponent(double angle, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension - 1 > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality (minus 1) of this point");
        }
        Vector newVector = new Vector(this);
        double[] newCoords = newVector.coordinates;
        for (int cartesianDimension = 1; cartesianDimension <= this.getDimensions(); ++cartesianDimension) {
            double sphericalProducts = this.getDistance();
            for (int angleDimension = 1; angleDimension <= (cartesianDimension >= this.getDimensions() ? this.getDimensions() - 1 : cartesianDimension); ++angleDimension) {
                if (angleDimension < cartesianDimension) {
                    if (angleDimension == dimension) {
                        sphericalProducts *= Math.sin(angle);
                        continue;
                    }
                    sphericalProducts *= Math.sin(this.getAngularComponent(angleDimension));
                    continue;
                }
                if (angleDimension == dimension) {
                    sphericalProducts *= Math.cos(angle);
                    continue;
                }
                sphericalProducts *= Math.cos(this.getAngularComponent(angleDimension));
            }
            newCoords[cartesianDimension - 1] = sphericalProducts;
        }
        return newVector;
    }

    public double getDistance() {
        if (this.distanceCache == null) {
            double[] currentCoords = (double[])this.coordinates.clone();
            double squaredSum = 0.0;
            for (double coordinate : currentCoords) {
                squaredSum += Math.pow(coordinate, 2.0);
            }
            this.distanceCache = Math.sqrt(squaredSum);
        }
        return this.distanceCache;
    }

    public double getAngularComponent(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension - 1 > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality (minus 1) of this point");
        }
        double[] currentCoords = (double[])this.coordinates.clone();
        double squaredSum = 0.0;
        for (int coordinateIndex = currentCoords.length - 1; coordinateIndex >= dimension; --coordinateIndex) {
            squaredSum += Math.pow(currentCoords[coordinateIndex], 2.0);
        }
        if (dimension == this.getDimensions() - 1) {
            return Math.atan2(Math.sqrt(squaredSum), currentCoords[dimension - 1]);
        }
        if (currentCoords[dimension - 1] == 0.0) {
            return 1.5707963267948966;
        }
        return Math.atan(Math.sqrt(squaredSum) / currentCoords[dimension - 1]);
    }

    public double getNorm(int order) {
        double poweredSum = 0.0;
        for (double coordinate : this.coordinates) {
            poweredSum += Math.pow(Math.abs(coordinate), order);
        }
        return Math.pow(poweredSum, 1.0 / (double)order);
    }

    public double getNorm() {
        return this.getNorm(2);
    }

    public double getNormInfinity() {
        double maximum = 0.0;
        for (double coordinate : this.coordinates) {
            if (!(maximum < coordinate)) continue;
            maximum = coordinate;
        }
        return maximum;
    }

    public boolean isOrigin() {
        for (double coordinate : this.coordinates) {
            if (coordinate == 0.0) continue;
            return false;
        }
        return true;
    }

    public Vector calculateRelativeTo(Vector absolutePoint) {
        if (absolutePoint == null) {
            throw new IllegalArgumentException("absolutePoint can not be null!");
        }
        double[] currentCoords = (double[])this.coordinates.clone();
        double[] absoluteCoords = (double[])absolutePoint.coordinates.clone();
        if (absoluteCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("absolutePoint must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        for (int coordIndex = 0; coordIndex < currentCoords.length; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] - absoluteCoords[coordIndex];
        }
        return new Vector(relativeCoords);
    }

    public Vector add(Vector pointToAdd) {
        if (pointToAdd == null) {
            throw new IllegalArgumentException("pointToAdd can not be null!");
        }
        double[] currentCoords = (double[])this.coordinates.clone();
        double[] addCoords = (double[])pointToAdd.coordinates.clone();
        if (addCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("pointToAdd must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        for (int coordIndex = 0; coordIndex < currentCoords.length; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] + addCoords[coordIndex];
        }
        return new Vector(relativeCoords);
    }

    public Vector subtract(Vector pointToAdd) {
        if (pointToAdd == null) {
            throw new IllegalArgumentException("pointToAdd can not be null!");
        }
        double[] currentCoords = (double[])this.coordinates.clone();
        double[] addCoords = (double[])pointToAdd.coordinates.clone();
        if (addCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("pointToAdd must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        for (int coordIndex = 0; coordIndex < currentCoords.length; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] - addCoords[coordIndex];
        }
        return new Vector(relativeCoords);
    }

    public double dotProduct(Vector operand) {
        if (this.coordinates.length != operand.coordinates.length) {
            throw new IllegalArgumentException("operand must have the same number of dimensions as this vector.");
        }
        double result = 0.0;
        for (int coordIndex = 0; coordIndex < this.coordinates.length; ++coordIndex) {
            result += this.coordinates[coordIndex] * operand.coordinates[coordIndex];
        }
        return result;
    }

    public boolean isNaN() {
        for (double coordinate : this.coordinates) {
            if (!Double.isNaN(coordinate)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        for (double coordinate : this.coordinates) {
            if (!Double.isInfinite(coordinate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        double[] currentCoords = (double[])this.coordinates.clone();
        StringBuilder stringValue = new StringBuilder(currentCoords.length * 5 + 2);
        stringValue.append('{');
        for (int dimension = 0; dimension < currentCoords.length; ++dimension) {
            stringValue.append(currentCoords[dimension]);
            if (dimension >= currentCoords.length - 1) continue;
            stringValue.append(',');
        }
        stringValue.append('}');
        return stringValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringHypersphere() {
        Vector vector = this;
        synchronized (vector) {
            StringBuilder retString = new StringBuilder(this.getDimensions() * 6);
            retString.append(this.getDistance());
            retString.append('@');
            for (int angleDimension = 1; angleDimension < this.getDimensions(); ++angleDimension) {
                retString.append(this.getAngularComponent(angleDimension));
                if (angleDimension >= this.getDimensions() - 1) continue;
                retString.append(',');
            }
            return retString.toString();
        }
    }

    public int hashCode() {
        double[] currentCoords = (double[])this.coordinates.clone();
        int hashcode = 0;
        for (double coordinate : currentCoords) {
            hashcode += hashcode ^ Double.valueOf(coordinate).hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object compareWithObject) {
        if (!(compareWithObject instanceof Vector)) {
            return false;
        }
        Vector compareWith = (Vector)compareWithObject;
        double[] currentCoords = this.coordinates;
        double[] otherCoords = compareWith.coordinates;
        if (currentCoords.length != otherCoords.length) {
            return false;
        }
        for (int dimension = 0; dimension <= currentCoords.length; ++dimension) {
            if (currentCoords[dimension] == otherCoords[dimension]) continue;
            return false;
        }
        return true;
    }
}

