/*
 * Decompiled with CFR 0.152.
 */
package example;

import au.com.seasoft.ham.InteropEdge;
import au.com.seasoft.ham.InteropNode;
import com.syncleus.dann.graph.Graph;
import example.SetupExampleGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TestExampleGraph {
    private SetupExampleGraph graph = new SetupExampleGraph();

    private Graph getGraph() {
        return this.graph.getGraph();
    }

    @Test
    public void nodesWereAdded() {
        Assert.assertEquals((long)12L, (long)this.graph.getGraph().getNodes().size());
    }

    @Test
    public void edgesWereAdded() {
        Assert.assertEquals((long)14L, (long)this.graph.getGraph().getEdges().size());
    }

    @Test
    public void adjacentNodes() {
        InteropNode node9 = new InteropNode(9);
        HashSet<Integer> expectedAdjacentNodes = new HashSet<Integer>();
        expectedAdjacentNodes.add(8);
        expectedAdjacentNodes.add(10);
        expectedAdjacentNodes.add(11);
        List<InteropNode> adjacentNodes = this.getGraph().getAdjacentNodes(node9);
        Assert.assertEquals(expectedAdjacentNodes, new HashSet<Integer>(InteropNode.convertToInts(adjacentNodes)));
    }

    @Test
    public void adjacentEdges() {
        InteropNode node9 = new InteropNode(9);
        HashSet<InteropEdge> expectedAdjacentEdges = new HashSet<InteropEdge>();
        expectedAdjacentEdges.add(new InteropEdge(new InteropNode(9), new InteropNode(11)));
        expectedAdjacentEdges.add(new InteropEdge(new InteropNode(9), new InteropNode(10)));
        expectedAdjacentEdges.add(new InteropEdge(new InteropNode(8), new InteropNode(9)));
        Set adjacentEdges = this.getGraph().getAdjacentEdges(node9);
        Assert.assertEquals(expectedAdjacentEdges, adjacentEdges);
    }

    @Test
    public void traversableNodes1() {
        InteropNode node12 = new InteropNode(12);
        ArrayList expectedTraversableNodes = new ArrayList();
        List<InteropNode> traversableNodes = this.getGraph().getTraversableNodes(node12);
        Assert.assertEquals(expectedTraversableNodes, traversableNodes);
    }

    @Test
    public void traversableNodes2() {
        InteropNode node1 = new InteropNode(1);
        ArrayList<InteropNode> expectedTraversableNodes = new ArrayList<InteropNode>();
        expectedTraversableNodes.add(new InteropNode(3));
        List<InteropNode> traversableNodes = this.getGraph().getTraversableNodes(node1);
        Assert.assertEquals(expectedTraversableNodes, traversableNodes);
    }

    @Test
    public void traversableNodes3() {
        InteropNode node7 = new InteropNode(7);
        ArrayList<InteropNode> expectedTraversableNodes = new ArrayList<InteropNode>();
        expectedTraversableNodes.add(new InteropNode(6));
        expectedTraversableNodes.add(new InteropNode(8));
        List<InteropNode> traversableNodes = this.getGraph().getTraversableNodes(node7);
        Assert.assertEquals(expectedTraversableNodes, traversableNodes);
    }
}

