/*
 * Decompiled with CFR 0.152.
 */
package cl.omp.logger;

import cl.omp.logger.LoggerPrinter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileLoggerPrinter
extends LoggerPrinter {
    private final File logFile;
    private final Path logFilePath;
    private final StandardOpenOption writeOption;

    public FileLoggerPrinter(File logFile) {
        this.logFile = logFile;
        this.logFilePath = this.logFile.toPath();
        this.writeOption = StandardOpenOption.APPEND;
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void print(String msg) throws IOException {
        Files.write(this.logFilePath, msg.getBytes(), this.writeOption);
    }

    @Override
    public void println(String msg) throws IOException {
        this.print(msg.concat("\n"));
    }
}

