(ns leiningen.new.clarp
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "clarp"))

(defn clarp
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["harp.json" (render "harp.json" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{sanitized}}/core.cljs" (render "core.cljs" data)]
             ["public/_layout.jade" (render "layout.jade" data)]
             ["public/index.jade" (render "index.jade" data)]
             ["public/main.less" (render "main.less" data)])))
