(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME"
  :url "http://example.com/FIXME"

  :dependencies [[org.clojure/clojure "1.5.1"]
                 [org.clojure/clojurescript "0.0-2234"]]

  :plugins [[lein-pdo "0.1.1"]
            [lein-npm "0.4.0"]
            [lein-cljsbuild "1.0.3"]]

  :node-dependencies [[harp "0.12.1"]]
  :nodejs {:scripts {:serve "harp server"
                     :compile "harp compile -o dist"}}

  :cljsbuild {
    :builds [{:id "dev"
              :source-paths ["src"]
              :compiler {
                :output-to "public/main-dev.js"
                :output-dir "public/cljsbuild"
                :optimizations :none
                :source-map true}}
             {:id "dist"
              :source-paths ["src"]
              :compiler {
                :output-to "public/main.js"
                :optimizations :advanced
                :preamble [] :externs [] ;; use these for external libraries
                :pretty-print false}}]}

  :aliases {"dev" ["pdo" "clean" ["cljsbuild" "clean"]
                         ["cljsbuild" "auto" "dev"]    ;; handles cljs re-compilation
                         ["npm" "run" "serve"]]        ;; harp handles the rest (except livereload)
            "dist" ["do" "clean" ["cljsbuild" "clean"]
                         ["cljsbuild" "once" "dist"]   ;; produces optimized, minified main.js
                         ["npm" "run" "compile"]]})    ;; harp compiles the site to dist


