(ns pedestal-utils.http-response
  (:require [ring.util.response :as resp]))

; TODO : move service to pedestal-utils
(defn a-response [status body]
  {:status  status
   :body    body
   :headers {}})

(defn an-error-response
  ([status msg] (a-response status {:userMessage msg}))
  ([status msg error] (assoc-in (an-error-response status msg) [:body :developerMessage] error)))

(defn ok
  ([] (ok {:userMessage "ok"}))
  ([body] (a-response 200 body)))

(def created (partial a-response 201))

(def accepted (partial a-response 202))

(def no-content (partial a-response 204 nil))

(def bad-request (partial an-error-response 400))

(def unauthorized (partial an-error-response 401))

(def forbidden (partial an-error-response 403))

(defn not-found
  ([] (an-error-response 404 "Not Found"))
  ([body] (an-error-response 404 body)))

(def method-not-allowed (partial an-error-response 405))

