(ns pedestal-utils.casing-conversion
  (:require [camel-snake-kebab.extras :refer [transform-keys]]
            [camel-snake-kebab.core :as c]))

(defn casing-conv [& {:keys [enter-casing leave-casing] :or {enter-casing c/->kebab-case
                                                             leave-casing c/->camelCase}}]
  {:name  :casing-conv
   :enter (fn [context]
            (update-in context [:request :body] #(transform-keys enter-casing %)))
   :leave (fn [context]
            (update-in context [:response :body] #(transform-keys leave-casing %)))})
