(ns pedestal-utils.mdc-headers
  ^{:doc "Pedestal interceptor for managing thread-local variables"}
  (:require [utils.mdc :as MDC]))

(defn remove-request-logging-fields []
  (MDC/remove-tenant-id) (MDC/remove-user-id) (MDC/remove-request-id))

(def mdc-headers
  ^{:doc "Interceptor for adding request data to thread-local MDC object on :enter, and using and removing fields on :leave"}
  {:name  :mdc-headers
   :enter (fn [{{headers                               :headers
                 {tenant-id :tenantId employee-id :id} :employee-info}
                :request :as context}]
            (MDC/put-tenant-id tenant-id) (MDC/put-request-id (get headers "x-request-id")) (MDC/put-user-id employee-id)
            context)

   :error (fn [context] 
            (remove-request-logging-fields)
            context)
   :leave (fn
            [context]
            (let [new-context (-> context
                                  (assoc-in [:response :headers "X-CS-Tenant-Id"] (MDC/get-tenant-id))
                                  (assoc-in [:response :headers "X-CS-User-Id"] (MDC/get-user-id)))]
              (remove-request-logging-fields)
              new-context))})
