(ns utils.token-auth
  (:require [utils.employee-info-service :as employee-info-service]
            [io.pedestal.interceptor.chain :as chain]))

(defn get-token [headers] (subs (get headers "authorization") (count "Bearer ")))

(defn compojure-auth-middleware
  [handler]
  (fn
    [{headers :headers
      :as     request}]
    (let [token (get-token headers)
          employee-request-obj (employee-info-service/get-employee-info token)
          employee-info (:body employee-request-obj)]
      (if (= (:status employee-request-obj) 200)
        (handler (assoc request :employee-info employee-info :token token))
        {:status  401
         :body    {:message "Unauthorized"}
         :headers {"content-type" "application/json; charset=utf-8"}}))))

(def pedestal-401-response
  {:name  :401-response
   :leave (fn [context]
            (assoc context :response {:status  401
                                      :headers {}
                                      :body    "Unauthorized"}))})

(def pedastal-auth-interceptor
  {:name  :auth-interceptor
   :enter (fn [{{headers :headers} :request :as context}]
            (let [token (get-token headers)
                  {employee-info :body
                   status        :status} (employee-info-service/do-remote-employee-info-call token)]
              (if (= status 200)
                (assoc-in context [:request :employee-info] employee-info)
                (-> context
                    chain/terminate
                    (chain/enqueue* pedestal-401-response)))))})
