(ns utils.rethink-service
  (:require [rethinkdb.query :as r]
            [utils.logger :as log]))

(defn connect [db-name] (r/connect :host (System/getenv "RDBHOST") :port 28015 :db db-name))

(defn find-by-id [employee-id table-name db-name]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/get employee-id)
      (r/run conn))))

(defn find-by-filter [filter table-name db-name]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/filter filter)
      (r/run conn))))

(defn delete-by-filter [filter table-name db-name]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/filter filter)
      (r/delete)
      (r/run conn))))

(defn delete-by-id [db-name table-name id]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/get id)
      (r/delete)
      (r/run conn))))

(defn find-by-index [value index table-name db-name]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/get-all [value] {:index index})
      (r/run conn))))

(defn find-all [table-name db-name]
  (log/debug "RETRIEVING CREDENTIALS")
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/run conn))))

(defn replace-doc [db-name table-name message]
  (with-open [conn (connect db-name)]
    (->
      (r/table table-name)
      (r/insert message {:conflict "replace"})
      (r/run conn))))