(ns utils.logger
  (:require [clj-time.core :as t]
            [clj-time.format :as f]))

(def log-date-formatter (f/formatter "yyyy-MM-dd HH:mm:ss.SSS"))

(defn log-time []
  (f/unparse log-date-formatter (t/now)))

(defn- logger [level]
  (fn [& args]
    (apply println (into [(format "%s [%s] %s %s - " (log-time) (.getName (Thread/currentThread)) level (ns-name *ns*) )] args))
    (last args)))

(def trace (logger "TRACE"))

(def debug (logger "DEBUG"))

(def info (logger "INFO"))

(def err (logger "ERROR"))

(def log (logger "LOG"))

(def fatal (logger "FATAL"))

(def warning (logger "WARN"))