(ns utils.logger
  (:require [clj-time.core :as t]
            [clj-time.format :as f]
            [clojure.tools.logging :as logging]
            [clojure.string :as string]))

(defn- join-message [message-coll]
  (string/join " " message-coll))

(defn trace [& messages] (logging/trace (join-message messages)) (last messages))

(defn log [& message] (logging/log "LOG" (join-message message)) (last message))

(defn debug [& messages] (logging/debug (join-message messages)) (last messages))

(defn info [& messages] (logging/info (join-message messages)) (last messages))

(defn warn [& messages] (logging/warn (join-message messages)) (last messages))

(defn err [& messages] (logging/error (join-message messages)) (last messages))

(defn fatal [& messages] (logging/fatal (join-message messages)) (last messages))