(ns utils.gzip
  (:import (java.io ByteArrayOutputStream BufferedOutputStream ByteArrayInputStream)
           (java.util.zip GZIPOutputStream)))

(defn gzip [handler]
  (fn [request]
    (let [response (handler request)
          out (ByteArrayOutputStream.)
          accept-encoding (.get (:headers  request) "accept-encoding")]
      (if (and (not (nil? accept-encoding)) (re-find #"gzip" accept-encoding))
        (do
          (doto (BufferedOutputStream. (GZIPOutputStream. out))
            (.write (.getBytes (:body response)))
            (.close))

          {:status  (:status response)
            :headers (assoc (:headers response) "Content-Encoding" "gzip")
            :body    (ByteArrayInputStream. (.toByteArray out))})
        response))))
