(ns utils.employee-info-service
  (:require [utils.http :refer [GET]]))

(defn- log [x] (prn x) x)

(defn do-remote-employee-info-call [token]
  (GET (str "https://" (System/getenv "CSAPIHOST") "/api/api/employee/myinfo")
            {:headers          {:Authorization (str "Bearer " token)}
             :client-params    {:cookie-policy (constantly nil)}
             :content-type     :json
             :throw-exceptions false
             :as               :json
             :insecure?        true}))


(defn do-remote-token-info-call [token]
  (GET (str "https://" (System/getenv "CSAPIHOST") "/oauth/check_token?token=" token)
            {:client-params    {:cookie-policy (constantly nil)}
             :content-type     :json
             :throw-exceptions false
             :as               :json
             :insecure?        true}))

(defn get-employee-info [token] (:body (do-remote-employee-info-call token))) ;TODO: we need to respond with error if invalid token

(defn get-tenant-id [token] (:tenantId (get-employee-info token)))
