(ns utils.http
  (:require [clj-http.client :as client]
            [utils.mdc :as MDC]
            [utils.logger :as logger]))

(defn add-request-id [req]
  (assoc-in (or req {}) [:headers "x-request-id"] (MDC/get-request-id)))

(defn request [method]
  (fn [url & [request & r]]
    (apply method (concat [url (add-request-id request)] r))))

(def GET (request client/get))

(def POST (request client/post))

(def PUT (request client/put))

(def PATCH (request client/patch))

(def DELETE (request client/delete))

(def HEAD (request client/head))

(def OPTIONS (request client/options))
