(ns io.datafy.http.route
  (:require [clojure.tools.logging :as log]
            [io.pedestal.http.ring-middlewares :as ring-mw]
            [io.datafy.http.server.pedestal-interceptor :as res]
            [clojure.java.io :as io]
            [io.pedestal.http.route :as route]
            [ring.util.response :as ring-resp]
            [ingestion.api.client :as iclient]
            [ingestion.api.client.core :as ccore]
            [ksql.gen.protocol :as p]
    ;   [ingestion.api.client.mapping-gen :as mgen]
    ; [ingestion.api.client.core :as core]
    ;[io.datafy.api :as api]
            [io.datafy.http.server.req-parser :as rp]
    #_[io.datafy.server.stream-handler :as sh]))


(defn html-response
  [html]
  {:status 200 :body html :headers {"Content-Type" "text/html"}})


(defn json-response
  [json-str]
  {:status 200 :body json-str :headers {"Content-Type" "script/js"}})


;; Gather some data from the user to retain in their session.
(defn login-form
  "Prompt a user for their name, then remember it."
  [req]
  (html-response
    (slurp (io/resource "public/login.html"))))


#_(defn main-js [req]
  (json-response
    (slurp (io/resource "public/js/main.js"))))


(comment

  (main-js nil)

  )


(defn introduction
  "Place the name provided by the user into their session, then send
   them to hello."
  [req]
  ;(clojure.pprint/pprint req)
  (let [name (get-in req [:params :name])
        name (if (empty? name) nil name)]
    (-> (ring-resp/redirect "/hello")
        (p/log-v)
        (assoc :session {:name name}))))

;; Behavior dictated by data in the user's session. Using ring
;; middleware means that the request is what gets modified by
;; interceptors.

;; We default in 'Stranger' so users visiting the service can see the
;; behavior of the service when no session data is present.
(defn hello
  "Look up the name for this http session, if present greet the user
   by their name. If not, greet the user as stranger."
  [req]
  (println "---hello ------------------")
  (clojure.pprint/pprint req)
  (let [name (or (get-in req [:session :name]) "Stranger")]
    (html-response (str "<html><body><h1>Hello, " name "!</h1></body></html>\n"))))


#_(def rkeys [:repo-path :ds-name :extension :entity-name
              :payload
              :attr-filter
              :meta-params
              :api])
(comment

  (->
    @(get @ccore/ns-store-impl :ns-context-m)
    keys
    )

  )

;(defonce app-context (atom (core/get-context)))


(defn invoke-handler [server-context request]
  (try
    (let [w (or (:transit-params request)
                (:edn-params request)
                (:json-params request))
          w (update w [:op] (fn [v] (if (keyword? v) (name v) v)))
          out (iclient/invoke w)]
      {:out out})
    (catch clojure.lang.ExceptionInfo e
      (do
        (println e)
        (log/debug "error for " e)
        (throw e)))
    (catch Exception e
      (do
        (println e)
        (log/error e)
        (throw (ex-info (.getMessage e) {:error (.getMessage e)}))
        )



      )
    )

  )



(def FILE_FORM_PARAM "file")
(def OUTPUT_DIR "/tmp/")

(defn stream->bytes [is]
  (loop [b (.read is) accum []]
    (if (< b 0)
      accum
      (recur (.read is) (conj accum b)))))


(defn upload-metadata
  [request]
  (try
    (let [[in file-name] ((juxt :tempfile :filename)
                          (-> request :params (get FILE_FORM_PARAM)))
          mapping-name (get-in request [:params "app-ns-name"])

          mapping-str (iclient/invoke {:op           "df-gen-mapping-by-file"
                                       :app-ns-name mapping-name
                                       :request      {:file-name file-name :file in}})]
      {:out mapping-str}
      #_{:status 200
         :body   mapping-str})
    (catch Exception e
      (do
        (log/error e)
        ;(println (.getMessage e))
        (throw (ex-info (.getMessage e) {:error (.getMessage e)}))
        #_{:status 200
           :body   (.getMessage e)}))))



(defn upload-data
  [request]
  (try
    (let [[in file-name] ((juxt :tempfile :filename)
                          (-> request :params (get FILE_FORM_PARAM)))

          mapping-name (get-in request [:params "app-ns-name"])

          mapping-str (iclient/invoke {:op           "df-data-push-file"
                                       :app-ns-name mapping-name
                                       :request      {:file-name file-name :file in}})]
      {:out "ok"}
      #_{:status 200
         :body   mapping-str})
    (catch Exception e
      (do
        (log/error e)
        ;(log/info (Throwable->map e) #_(.getMessage e))
        (throw (ex-info (.getMessage e) {:error (.getMessage e)}))
        #_(throw (ex-info "upload exception " {:error (.getMessage e)}))
        #_{:status 200
           :body   (.getMessage e)}))))



(defn get-routes [context base-url]
  (let [base-url (or base-url "/r")
        ;data-url
        ;meta-data-url

        ; data-h (conj res/data-interceptors (partial http-data-handler context))
        ; data-api-h (conj res/data-interceptors (partial api-data-handler context))
        ; repo-http-h (conj res/data-interceptors (partial http-ds-handler context))
        ; dataflow-url
        invoke-h (conj res/data-interceptors (partial invoke-handler context))
        h-intercepter (res/html-interceptors)
        ]
    #_(route/expand-routes

        [[["/login" {:get `login-form}]
          ["/introduce" ^:interceptors h-intercepter
           {:post `introduction}]
          ["/hello" ^:interceptors h-intercepter #_[session-interceptor]
           {:get `hello}]]]
        )
    (route/expand-routes #{["/login" :get `login-form :route-name :login-form]
                           #_["/js/app.js" :get `main-js :route-name :main-json]
                           ["/introduce" :post (conj h-intercepter (partial introduction)) :route-name :introduce]
                           ["/hello" :get (conj h-intercepter (partial hello)) :route-name :hello]
                           ["/upload-metadata" :post (conj res/upload-interceptor (partial upload-metadata)) :route-name :md-upload]
                           ["/upload-data" :post (conj res/upload-interceptor (partial upload-data)) :route-name :data-upload]
                           [(str base-url "/invoke") :post invoke-h :route-name :invoke]

                           ; [(str base-url "/gen_ksql") :post genksql-h :route-name :gen-mapping-route]

                           ;                     [base-url :post data-api-h :route-name :datafy-data-api-route]
                           ;[(str base-url "/data/*repo") :any data-h :route-name :datafy-api-route]
                           ;[(str base-url "/ds/*repo") :any repo-http-h :route-name :datafy-repo-route]

                           })))


;["/upload" ^:interceptors  [(ring-mw/multipart-params)] {:post upload}]

(comment

  (get-routes "/rr")

  )

(defn get-routes-test
  [base-url handler]
  (let [base-url (or base-url "/r")
        data-url (str base-url "/:api/*repo")
        intr (conj res/data-interceptors handler)]
    (route/expand-routes #{[base-url :post intr :route-name :datafy-api-route]
                           [data-url :any intr :route-name :datafy-route]})))


