(ns ksql.gen.core
  (:require [ksql.gen.expand-join-impl :as mc2]
            [ksql.gen.expand-macro-impl :as fi]
            [ksql.gen.protocol :as p]
            [ksql.gen.util :as u]
            [ksql.gen.schema-gen :as sg]
            [clojure.tools.reader.edn :as edn]))


(def ^:dynamic gcontext {})

#_(defn create-mapping-name [schema-m]
    (let [sink-name (get schema-m :sink-name)
          source-name (get schema-m :source-name)
          mapping-name (if (clojure.string/includes? sink-name "step")
                         (str sink-name "-mapping")
                         (str (clojure.string/lower-case sink-name)
                              "-"
                              (->> source-name
                                   (clojure.string/join "-")
                                   (clojure.string/lower-case))
                              "-mapping"))]
      (assoc schema-m :name mapping-name)))






(defn log [v]
  (clojure.pprint/pprint v)
  v)



(defn do-m-sort [schema mapping-schema]

  (let [field-m (->> (mapv :name (get schema :fields))
                     (map (fn [index v]
                            {(clojure.string/lower-case v) index}
                            ) (range))
                     (into {}))
        ;_ (  field-m)
        fields (->> (get mapping-schema :fields)
                    (sort-by (fn [v]
                               (get field-m (clojure.string/lower-case (get v :name)))
                               ))
                    (into []))]

    ;(  (mapv :name (get mapping-schema :fields)) )
    ;(println "----------------")
    ;(  (mapv :name fields) )
    (assoc mapping-schema :fields fields)))



#_(defn get-new-schema-coll [schema-m mapping-coll]
    (let [schema-set (into #{} (keys schema-m))
          xf (comp (map (fn [v] (first v)))
                   (remove (fn [m] (contains? schema-set (clojure.string/lower-case (get m :sink-name)))))
                   #_(map (fn [m]
                            {(clojure.string/upper-case (get m :sink-name)) m})))]
      (->> mapping-coll
           (into [] (remove (fn [m] (get m :mapping-schema))))
           (group-by :sink-name)
           (vals)
           (into [] xf))))


#_(defn get-mapping-schema [schema-m mapping-coll]
    (let [xf (comp
               (filter :mapping-schema)
               (map (fn [mapping-schema]
                      (let [schema (get schema-m (clojure.string/lower-case (get mapping-schema :sink-name)))]
                        (do-m-sort schema mapping-schema)))))]
      (into [] xf mapping-coll)))


(defn- update-rekey-referance [mapping-schema rekey-schema]
  (let [new-source (get rekey-schema :sink-name)
        old-source (first (get rekey-schema :source-name))
        mapping-schema (if (get mapping-schema :source-name)
                         (update-in mapping-schema [:source-name] (fn [v]
                                                                    (mapv (fn [n]
                                                                            (if (= (clojure.string/lower-case n)
                                                                                   (clojure.string/lower-case old-source))
                                                                              new-source
                                                                              n)) v)))
                         mapping-schema)
        s-name (str (clojure.string/lower-case old-source) "/")
        n-name (str (clojure.string/lower-case new-source) "/")]
    (-> (pr-str mapping-schema)
        (clojure.string/replace s-name n-name)
        (edn/read-string))))


#_(defn get-schema [schema-m schema-name]
    (get schema-m schema-name)
    )

(defn- create-rekey-join-schema [schema-coll mapping-schema]
  (when-let [j (or (get mapping-schema :join)
                   (get mapping-schema :left_join))]
    ;(println "---" j "--" (keys schema-m))
    (let [[j-entity-name j-entity-col-name :as w] (mapv clojure.string/lower-case (clojure.string/split (nth j 2) #"/"))
          new-source-entity (u/get-source-schema schema-coll j-entity-name)
          new-source-entity-name (clojure.string/lower-case (str j-entity-name "_BY_" j-entity-col-name))]

      ;(println "--- " (get new-source-entity :key) "--" j-entity-col-name)
      (when (not= (get new-source-entity :key)
                  j-entity-col-name)
        (assoc new-source-entity :name new-source-entity-name
                                 :ksql-gen-type p/gen-ksql-rekey-stream-from-mapping
                                 :rekey true
                                 :sink-name new-source-entity-name
                                 :source-name [j-entity-name]
                                 :key j-entity-col-name)))))


#_(defn rekey-source-one [schema-coll mapping-schema]
    ;  (println "------------------")
    ;  (  mapping-schema)
    ;  (println "----------------")
    (if-let [rekey-entity-schema (create-rekey-join-schema schema-coll mapping-schema)]
      (let [w (update-rekey-referance mapping-schema rekey-entity-schema)]
        [w rekey-entity-schema])
      [mapping-schema]))


(defn rekey-source [schema-coll mapping-schema]
  (if-let [join-coll (get mapping-schema :join)]
    (let [df (fn [j]
               (let [[j-entity-name j-entity-col-name :as w] (mapv clojure.string/lower-case (clojure.string/split (nth j 2) #"/"))
                     new-source-entity (u/get-source-schema schema-coll j-entity-name)
                     new-source-entity-name (clojure.string/lower-case (str j-entity-name "_BY_" j-entity-col-name))]

                 ;(println "--- " (get new-source-entity :key) "--" j-entity-col-name)
                 (when (not= (get new-source-entity :key)
                             j-entity-col-name)
                   (assoc new-source-entity :name new-source-entity-name
                                            :ksql-gen-type p/gen-ksql-rekey-stream-from-mapping
                                            :rekey true
                                            :sink-name new-source-entity-name
                                            :source-name [j-entity-name]
                                            :key j-entity-col-name))))
          w-coll (into [] (comp (map df)
                                (remove nil?)) join-coll)

          mapping-schema (reduce (fn [acc k]
                                   (update-rekey-referance acc k)
                                   ) mapping-schema w-coll)

          ]
      (into [mapping-schema] w-coll)
      )
    [mapping-schema]
    )

  )



(defn merge-schema-coll [schema-coll mapping-coll]
  (let [w (into #{} (map (juxt :sink-name :source-name)) schema-coll)]
    (into schema-coll
          (remove (fn [mapping]
                    (contains? w ((juxt :sink-name :source-name) mapping))))
          mapping-coll)))



(defn get-source-name-from-fields [transfer_fn]
  (->> transfer_fn
       rest
       (filter (fn [v]
                 (clojure.string/includes? v "/")))
       (remove (fn [v]
                 (clojure.string/starts-with? v "'")))
       (flatten)
       (first)))

(comment

  (get-source-name-from-fields ["as" "'ref_mapping2/id'"])

  )



(defn add-source-type-batch [schema-coll mapping]
  (let [schema-m (reduce (fn [acc v]
                           (let [sink-name (get v :sink-name)]
                             (if (get acc sink-name)
                               acc
                               (merge acc (into {} (map (fn [m]
                                                          {(str sink-name "/" (get m :name)) (get-in m [:schema])}
                                                          )) (get v :fields)))))
                           ) {} schema-coll)]
    ; (p/log-v mapping)

    (into [] (map (fn [m]
                    (if (and (get m :field_name))
                      (let [s-name (get-source-name-from-fields (get m :transfer_fn))
                            st (when-let [v (get schema-m s-name)]
                                 v)
                            source-type (loop [out []
                                               m st]
                                          (if (nil? m)
                                            (into [] (reverse out))
                                            (let [out (conj out (get m :type))]
                                              (recur out (get m :member_schema))
                                              )
                                            )
                                          )
                            source-type (if (empty? source-type) nil source-type)
                            sink-type (or (get m :field_type) source-type ["string"])
                            ]
                        (assoc m :field_type sink-type :source-type st))
                      m
                      )

                    )) mapping)
    ))



(defn get-key [schema-m source-names current-mapping]
  (if (get current-mapping :key)
    (get current-mapping :key)
    ;(assoc current-mapping :partition-key (get current-mapping :key) )
    (let [source-entity-name (first source-names)
          ; _ (println "--" source-entity-name)
          source-schema-key (get-in schema-m [source-entity-name :key])
          source-schema-key (if (clojure.string/blank? source-schema-key)
                              nil
                              source-schema-key
                              )
          ; _ (println "--" source-schema-key)
          k (get-in current-mapping [:fields 0 :name])]
      source-schema-key
      #_(assoc current-mapping :key source-schema-key #_(or k))
      )
    ))


(defn assoc-generation-type [schema-coll current-mapping]
  (let [source-names (u/get-all-source-name current-mapping)
        main-source-name (u/get-main-source-name current-mapping)
        ;   _ (println "--" source-names)

        source-schema-m (into {} (comp (map (partial u/get-source-schema schema-coll))
                                       (remove nil?)
                                       (map (fn [m]
                                              {(get m :sink-name) m}
                                              ))
                                       ) source-names)

        current-mapping (assoc current-mapping :source-schema source-schema-m :source-name source-names)

        ; _ (p/log-v current-mapping)

        current-mapping (if (= "table" (get current-mapping :type))

                          (let [
                                ;    _ (  current-mapping)
                                all-transformation-fn (mapv (fn [m]
                                                              (first (get m :transfer_fn))
                                                              ) (:fields current-mapping))
                                ;  _ (println all-transformation-fn)
                                create-table? (if (every? #{"as"} all-transformation-fn) true false)
                                ]

                            ;  (println "--" create-table?)
                            ;(println "--" (keys schema-m) "--" main-source-name "--" (get schema-m main-source-name))
                            (cond (and create-table?
                                       (=
                                         (get current-mapping :key)
                                         (get (get source-schema-m main-source-name) :key)))
                                  (do
                                    (assoc current-mapping :ksql-gen-type p/gen-ksql-create-table))

                                  (and
                                    create-table?
                                    (not=
                                      (get current-mapping :key)
                                      (get (get source-schema-m main-source-name) :key)))

                                  (assoc current-mapping :ksql-gen-type p/gen-ksql-table-from-stream-after-rekey)

                                  :else
                                  (assoc current-mapping :ksql-gen-type p/gen-ksql-create-table-as)))




                          (let [sink-schema (u/get-source-schema schema-coll (clojure.string/lower-case (get current-mapping :sink-name)))
                                ;      remote-source-name (get sink-schema :source-name)
                                ;source-schema

                                ;; @todo previous source schema finding error
                                ;       previous-source-name (u/get-source-entity-name-from-sink-schema (get current-mapping :source-name) sink-schema)
                                ]



                            (if (and
                                  sink-schema
                                  #_(not= (get current-mapping :source-name)
                                          remote-source-name))
                              (let [sink-name (get current-mapping :sink-name)
                                    sink-schema (reduce (fn [acc v]
                                                          (if (= sink-name
                                                                 (get v :sink-name)
                                                                 )
                                                            (reduced v)
                                                            acc

                                                            )
                                                          ) nil schema-coll)
                                    sink-fields (get sink-schema :fields)


                                    mapping-fields-m (into {} (map (fn [v] [(get v :name) v])) (get current-mapping :fields))

                                    sink-fields (into [] (map (fn [v]
                                                                (let [n (get v :name)]
                                                                  (if-let [mapping-fields-name (get mapping-fields-m n)]
                                                                    (assoc v :transfer_fn (get mapping-fields-name  :transfer_fn)
                                                                             :source-type (get mapping-fields-name  :source-type))
                                                                    (assoc v :transfer_fn  ["vnull"] #_(get-in mapping-fields-m [n :transfer_fn])
                                                                             :source-type (get v :type) #_(get-in mapping-fields-m [n :source-type]))
                                                                    )
                                                                  )


                                                                )) sink-fields)
                                 ;   _ (p/log-v sink-fields)
                                    current-mapping (assoc current-mapping :fields sink-fields)

                                    ]
                           ;     (p/log-v current-mapping)
                            ;    (p/log-v current-mapping)
                                ; (do-m-sort sink-schema current-mapping)
                                (-> current-mapping
                                    (assoc :sink-schema sink-schema
                                           :sink-key (get sink-schema :key)
                                           :ksql-gen-type p/gen-ksql-stream-insert-from-mapping)))
                              (assoc current-mapping :ksql-gen-type p/gen-ksql-stream-from-mapping))))]
    current-mapping

    )

  )





(defn do-post-validation [schema-m]
  (when (and (= (get schema-m :type) "table")
             (nil? (get schema-m :key))
             )
    (throw (ex-info (p/msg :500) (select-keys schema-m [:sink-name :key])))))





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




#_(defn get-join-entity-and-field-name [mapping]
    ;(p/log-v mapping)
    (let [out (into [] (comp (filter (fn [step]
                                       (contains? #{"join" "left_join"} (first (get step :transfer_fn [])))))
                             (map (fn [step] (nth (get step :transfer_fn []) 2)))
                             (remove empty?)
                             (map (fn [v] (clojure.string/split v #"/")))
                             cat
                             ) mapping)]
      ;(p/log-v out)
      (if (empty? out) nil out)

      ;out

      ))

#_(defn get-reference-entity [schema-coll]
    (reduce (fn [acc mapping]))

    )


(defn process-one [schema-coll current-mapping]

  (let [
        ;[current-mapping rekey-mapping] (rekey-source-one schema-coll current-mapping)
        [current-mapping & rekey-mapping] (rekey-source schema-coll current-mapping)
        ;    _ (p/log-v rekey-mapping)
        schema-coll (if rekey-mapping (merge-schema-coll schema-coll rekey-mapping) #_(into schema-coll) schema-coll)
        ;    source-names2 (u/get-source-name2 (get current-mapping :fields))
        current-mapping (assoc-generation-type schema-coll current-mapping)
        ]
    (if rekey-mapping
      (conj (vec rekey-mapping) current-mapping)
      #_[rekey-mapping current-mapping]
      [current-mapping]))

  )



(defn do-compile-one [schema-coll mapping]
  ;(  mapping)
  (let [
        schema-coll-m (into {} (map (fn [m]
                                      {(get m :sink-name) m}
                                      )) schema-coll)


        mapping-coll [mapping]
        ;mapping (fi/expand-this-macro mapping)
        mapping-coll (into [] (comp (map (fn [mapping]
                                           (add-source-type-batch schema-coll mapping)
                                           ))
                                    (map (fn [mapping]
                                           (if (get gcontext :join-split false)
                                             (mc2/join-expand mapping)
                                             ;(p/log-v )
                                             [mapping])))
                                    cat

                                    ) mapping-coll)



        mapping-coll (mapv (fn [mapping]
                             (sg/as-emitter-schema schema-coll-m mapping)
                             ) mapping-coll)

        struct-schema-coll (into [] (filter (fn [m] (= "struct" (get m :type)))) mapping-coll)
        schema-coll (merge-schema-coll schema-coll struct-schema-coll)


        mapping-coll (into [] (remove (fn [m] (= "struct" (get m :type)))) mapping-coll)

        ;_ (p/log-v mapping-coll)
        {:keys [p mapping-coll]} (group-by (fn [m]
                                             (if (nil? (u/get-main-source-name m))
                                               :p :mapping-coll)
                                             ) mapping-coll)

        w (into [] (map (fn [m]
                          (-> (assoc m :ksql-gen-type (if (= "table" (get m :type))
                                                        p/gen-ksql-create-table
                                                        p/gen-ksql-create-stream))
                              (assoc :source-name [(get m :sink-name)]))
                          )) p)
        schema-coll (merge-schema-coll schema-coll w)
        ;schema-coll (into schema-coll v)
        ]

    (loop [[current-mapping & mapping-coll] mapping-coll
           schema-coll schema-coll]
      (if (nil? current-mapping)
        schema-coll
        (let [v (process-one schema-coll current-mapping)
              schema-coll (merge-schema-coll schema-coll v)]
          (recur mapping-coll schema-coll))))))


(defn do-compile-batch [schema-coll mapping-coll]

  (loop [[mapping & r] mapping-coll
         out schema-coll]
    (if (nil? mapping)
      out

      (let [w (fi/do-expand-macro out mapping)

            ]
        (if (empty? w)
          (recur r out)
          (let [[f-mapping & r-mapping] w
                r-mapping (if r-mapping (vec r-mapping) [])
                ;_ (println f-mapping)
                r-mapping (into r-mapping r)]
            (recur r-mapping (do-compile-one out f-mapping))
            )
          )

        )

      )
    )

  #_(reduce do-compile-one schema-coll mapping-coll))









(comment




  (compile-mapping-one
    (list {:name        "tnf_policy",
           :field_name  "policy_number",
           :transfer_fn ["as"                               ;"id3_poltblp_policy/B4DOCD_Policy_Number"
                         "id3_zvspolp_policy/FBFNCU_Policy_Id"],
           :doc         "",
           :type        "String"}

          {:name        "tnf_policy",
           :field_name  "issue_state",
           :transfer_fn ["as" "id3_zvspolp_policy/FBFPCU_State_Id"],
           :doc         "",
           :type        "String"}

          {:name       "tnf_policy",
           :field_name "",
           :transfer_fn
                       ["join"
                        "id3_zvspolp_policy/FBFNCU_Policy_Id"
                        "id3_poltblp_policy/B4DOCD_Policy_Number"
                        ],
           :doc        "",
           :type       ""}
          {:name       "tnf_policy",
           :field_name "product_id",
           :transfer_fn
                       ["lookup"
                        "tnf_product/Product_Code"
                        ["="
                         "id3_zvspolp_policy/FBFVCU_Plan_Code"
                         "tnf_product/Product_Code"
                         ]],
           :doc        "",
           :type       "String"})

    )

  )
;join-entity-name



;(disj #{1 2 3} 1)