(ns ksqldb.client.broker-sedes-config
  (:require [jackdaw.serdes.resolver :as resolver]
            [jackdaw.serdes.edn :as serdes.edn]
            [cheshire.core :as json]
            [ksqldb.client.protocol :as c]
            [jackdaw.serdes :as serdes]))


(defn edn-topic-config [context topic-name]
  (let [partitions (get context :partitions 1)
        replicas (get context :replicas 1)]
    {:topic-name         topic-name
     :partition-count    partitions
     :replication-factor replicas
     :key-serde          (serdes/string-serde)
     :value-serde        (serdes.edn/serde)}
    )
  )


(defn json-topic-config [context topic-name]
  (let [partitions (get context :partitions 1)
        replicas (get context :replicas 1)
        ]

    {:topic-name         topic-name
     :partition-count    partitions
     :replication-factor replicas
     :key-serde          (serdes/string-serde)
     :value-serde        (serdes/string-serde)}
    )
  )


#_(defn convert-stream-to-avro-schema [stream-schema]
  (let [xf (comp (map (fn [m]
                        (let [type (clojure.string/lower-case (get-in m [:schema :type]))
                              type (if (contains? #{"int" "long" "float" "double" "boolean" "null"} type)
                                     type "string"
                                     )
                              new-type ["null" type]]
                          (-> m
                              (select-keys [:name])
                              (assoc :type new-type)
                              (assoc :default nil))))))
        fields (into [] xf (get stream-schema :fields))]
    {:fields    fields
     :type      "record"
     :name      "KsqlDataSourceSchema"
     :namespace "io.confluent.ksql.avro_schemas"
     :topic     (get stream-schema :topic)}))

#_(defn topic-config-for-data
  ([client stream-name]
   (let [stream-schema (c/invoke client {:op "describe-stream" :request stream-name})
         avro-schema (convert-stream-to-avro-schema stream-schema)
         topic-name (get stream-schema :topic)
         ;schema (dissoc schema :topic)
         ]
     ;(println "-------------topic name" stream-schema)
     (topic-config-for-data client topic-name avro-schema)))
  ([client topic-name schema]
   (let [serde-resolver (partial resolver/serde-resolver :schema-registry-url (get client :schema-url))
         schema (json/generate-string schema)]
     {:topic-name         topic-name
      :partition-count    1
      :replication-factor 1
      :key-serde          (serdes/string-serde)
      :value-serde        ((serde-resolver)
                            {:serde-keyword :jackdaw.serdes.avro.confluent/serde
                             :schema        schema
                             :key?          false})})))


(defn avro-topic-config
  ([client topic-name] (avro-topic-config client topic-name (c/invoke client {:op "describe-schema" :request (str topic-name "-value")})))
  ([client topic-name schema]
  ;  (  schema)
 ;  (println "--" client)
   (let [
         serde-resolver (partial resolver/serde-resolver :schema-registry-url (get client :schema-url "http://localhost:8081"))
         schema (json/generate-string schema)]
     {:topic-name         topic-name
      :partition-count    1
      :replication-factor 1
      :key-serde          (serdes/string-serde)
      :value-serde        ((serde-resolver)
                            {:serde-keyword :jackdaw.serdes.avro.confluent/serde
                             :schema        schema
                             :key?          false})})
   #_(let []
     ))

  )
