(ns ksql.gen.connector.core
  (:require [cheshire.core :as json]
            [ksql.gen.protocol :as p]
            ;[ksql.client :as client]
            [ksql.gen.connector.config-generator]
            [ksql.gen.reader.csv-data-reader :as r]
            [ksql.gen.file-util :as fio]))


(defn format-input [base-dir req]
  (as-> req {:keys [ds_file data_file key entity_name ref_name] :as m}
        (if ds_file
          (assoc m :ds_file (str base-dir (clojure.string/trim ds_file)))
          m)
        (if data_file
          (assoc m :data_file (str base-dir (clojure.string/trim data_file)))
          m)
        (if key
          (assoc m :key (if (sequential? key)
                          (mapv clojure.string/trim key)
                          (clojure.string/trim key)
                          ))
          m)
        (if entity_name
          (assoc m :entity_name (clojure.string/trim entity_name))
          m)
        (if ref_name
          (assoc m :ref_name (clojure.string/trim ref_name))
          m)
        m))

(defn as-sink-connector-schema [base-dir v]
  (let [out (if (string? v)
              (fio/read-csv-file v)
              (mapv (fn [req]
                      (zipmap [:ds_file :entity_name :key :ref_name] req)) v))
        xf (comp
             (map (fn [m]
                    ;  (println "--------" m)
                    (if (clojure.string/blank? (get m :key))
                      (assoc m :key nil)
                      m
                      )
                    ))
             (remove (fn [m] (or (nil? (get m :ds_file))
                                 (clojure.string/blank? (get m :ds_file))
                                 )))
             (map (fn [w] (format-input base-dir w)))
             (map (fn [w] #_(format-input base-dir w)
                    (let [template (r/load-template (get w :ds_file))
                          template-file-name (r/get-file-name (get w :ds_file))]
                      (assoc w :template template :template-file-name template-file-name))))
             (map (fn [v]
                    (-> v
                        (update :entity_name (comp clojure.string/trim clojure.string/lower-case))
                        (update :key (fn [v] (when v (clojure.string/trim v)))))))
             (map (fn [v]
                    (if (nil? (get v :key))
                      v
                      (let [k (clojure.string/trim (get v :key))
                            k (clojure.string/split k #" ")]
                        (if (= (count k) 1)
                          (assoc v :key (first k))
                          (assoc v :key k)))))))]
    (into [] xf out)))

(defn- gen-schema-from-entity-one [e]
  ; (  e)
  (let [template-path (get e :ds_file)
        file-path (get e :data_file)
        pk-name (get e :key)
        e-name (get e :entity_name)
        e-name (if (clojure.string/blank? e-name)
                 nil
                 e-name)
        tn (r/get-file-name template-path)
        t (r/load-template template-path)
        connector_ref_name (r/get-file-name file-path)]
    {:name               (or e-name connector_ref_name)
     :key                pk-name
     :entity_name        e-name
     :ref_name           connector_ref_name
     :template           t
     :template-file-name tn
     :file-path          file-path
     :connector_ref_name connector_ref_name
     :connector_source   tn
     :connector          t}))


(defn as-source-connector-schema [base-dir connector-mapping]
  (let [
        out (if (string? connector-mapping)
              (fio/read-csv-file connector-mapping)
              (mapv (fn [req]
                      (zipmap [:ds_file :data_file :key :entity_name] req)) connector-mapping))
        ;_ (pritln )
        xf (comp (map (fn [m]
                        ;     (println "--------" m)
                        (if (or (nil? (get m :key)) (clojure.string/blank? (get m :key)))
                          (assoc m :key nil)
                          m
                          )
                        ))
                 (map (fn [m]
                        (if (:key m)
                          (let [k (clojure.string/trim (:key m))
                                keys (clojure.string/split k #" ")]
                            (if (< 1 (count keys))
                              (assoc m :key keys)
                              m))
                          m)))
                 (remove (fn [m] (or (nil? (get m :ds_file))
                                     (clojure.string/blank? (get m :ds_file))
                                     )))

                 (map (fn [w] (format-input base-dir w)))
                 (map gen-schema-from-entity-one))]
    (into [] xf out)))

