(ns ksql.gen.emitter.ksql.core
  (:require [ksql.gen.emitter.ksql.ksql-gen-trans :as ti]
            [ksql.gen.util :as kutil]
            [ksql.gen.protocol :as p]
            [clojure.tools.logging :as log]))


(def ^:dynamic current-context {})

(defn as-create-fields
  ([fields] (as-create-fields fields nil nil))
  ([fields k gen-type]

    ;(p/log-v fields)

   (let [w (if (= "table" gen-type) " PRIMARY KEY " " KEY ")

         w (->> fields
                (reduce (fn [acc m]
                          ;(println "--" (get-in m [:schema :type]  ))
                          (if-let [member-schema (get-in m [:schema :member_schema])]
                            (cond
                              (= "key"
                                 (get-in m [:schema :type]))
                              (->> (str (get m :name) " " (get-in member-schema [:type]) w)
                                   (conj acc))

                              (= "array"
                                 (get-in m [:schema :type]))

                              (if (= "struct" (get-in member-schema [:type]))
                                (let [v (as-create-fields (get-in member-schema [ :fields]))]
                                  (->> (str (get m :name) " ARRAY<STRUCT<" v ">>")
                                       (conj acc))

                                  )
                                (->> (str (get m :name) " ARRAY<" (get-in member-schema [:type]) ">")
                                     (conj acc))

                                )





                              :else

                              (->> (str (get m :name) " " (get-in member-schema [:type]))
                                   (conj acc))
                              )

                            (if (= "struct"
                                   (get-in m [:schema :type]))


                              (do

                                ;(println "--" (as-create-fields (get-in m [:schema :fields]  )) )
                                (->> (str (get m :name) " STRUCT<" (as-create-fields (get-in m [:schema :fields])) ">")
                                     (conj acc))

                                )


                              (->> (str (get m :name) " " (get-in m [:schema :type]))
                                   (conj acc))
                              )

                            )

                          )

                        #_(if (= (get m :name) k)
                            (->> (str (get m :name) " " (get-in m [:schema :type]) w)
                                 (conj acc))
                            (->> (str (get m :name) " " (get-in m [:schema :type]))
                                 (conj acc))
                            )
                        [])
                (clojure.string/join " , "))]
     (-> #_(str "( " w " )")
       w
       (clojure.string/upper-case))))
  )


(defn do-fields-transformation [f]
  ;(p/log-v f)
  (let [n (get f :name)
        sink-type (when-let [w (get-in f [:schema :type]) #_(get-in f [:source-type :type])]
                    (if (= w "key")
                      (get-in f [:schema :member_schema :type])
                      w
                      )
                    ;(clojure.string/lower-case w)
                    )
        ;_ (println (get f :source-type ""))
        ;   _ (println "--sink type" sink-type "--source type " (get f :source-type ) "--" n)
        source-type (when-let [w (get-in f [:source-type :type])]
                      (if (= w "key")
                        (get-in f [:source-type :member_schema :type])
                        w
                        )
                      ;(clojure.string/lower-case w)
                      )



        ;_ (println "--name " n "---type " t)
        transformation? (sequential? (get f :transfer_fn))
        uf (if transformation?
             (ti/field-transformation (get f :transfer_fn))
             (get f :transfer_fn))
        v (if (and sink-type
                   (not (nil? source-type))
                   (not= source-type (clojure.string/lower-case sink-type))

                   )
            (str " CAST ( " uf " AS " sink-type " )  ")
            (str " " uf " ")

            )]
    (str v " AS " n " ")))





(defn make-with-clause
  ([topic-name] (make-with-clause topic-name "'AVRO'" true))
  ([topic-name value_format] (make-with-clause topic-name value_format true))
  ([topic-name value_format with-partitions? ]
   (let [topic-name (clojure.string/lower-case topic-name)
         str-out (str " WITH (kafka_topic='" topic-name "', value_format=" value_format "")
         str-out (if with-partitions?
                   (let [str-out (if-let [partitions (get current-context :partitions)]
                                   (str str-out ",partitions=" partitions)
                                   str-out)
                         str-out (if-let [replicas (get current-context :replicas)]
                                   (str str-out ",replicas=" replicas)
                                   str-out)]
                     str-out)
                   str-out)
         str-out (str str-out " ) ")]
     str-out)))


#_(defn do-fields-transformation-batch [fields]
    ;(  fields)
    (let [t-fields (filter :transfer_fn fields)]
      (if (empty? t-fields)
        "*"
        (->> t-fields
             (reduce (fn [acc f]
                       (conj acc (do-fields-transformation f))) [])
             (clojure.string/join ",")))))



(defn build-select-statement [mapping-schema]
  ;(clojure.pprint/pprint mapping-schema)
  ;(p/log-v mapping-schema)
  (let [fields (get mapping-schema :fields)

        ;;; window
        ;
        source-name (clojure.string/upper-case (kutil/get-main-source-name mapping-schema))
        ;_ (println "---source name " source-name)

        t-fields (filter :transfer_fn fields)

        select-fields (if (empty? t-fields)
                        "*"
                        (->> t-fields
                             (reduce (fn [acc f]
                                       (conj acc (do-fields-transformation f))) [])
                             (clojure.string/join ","))) #_(do-fields-transformation-batch fields #_(get mapping-schema :fields))

        ;_ (println "--" select-fields)
        sql-str (str "SELECT " select-fields " FROM " source-name " " source-name)

        sql-str (if-let [window (get mapping-schema :window)]
                  (do
                    (str sql-str (str " WINDOW TUMBLING (SIZE  " (clojure.string/join " " (rest window))  " ) ") )
                    )
                  sql-str
                  )

        sql-str (if-let [join (or (get mapping-schema :join)
                                  (get mapping-schema :left_join))]
                  (let [w (ti/join-transformation current-context (get mapping-schema :source-schema {}) join)]
                    ;(println "--" join)
                    (str sql-str " " w))
                  sql-str)
        sql-str (if-let [where (get mapping-schema :where)]
                  (let [w (ti/where-transformation where)]
               ;     (println "---where" w )
                    (str sql-str " " w))
                  sql-str)

        sql-str (if-let [group-by-v (get mapping-schema :group_by)]
                  (do
                    ;(println "--group by " group-by-v)
                    (str sql-str " GROUP BY " (clojure.string/join ", " (mapv ti/replace-forward-slap group-by-v) )  )
                    )
                  #_(let [w (ti/where-transformation where)]
                      (str sql-str " " w))
                  sql-str)

        sql-str (if-let [having (get mapping-schema :having)]
                  (do

                    (str sql-str (ti/field-transformation ["having" having]  #_["having"]))
                    )
                  sql-str
                  )

        ;sql-str (build-sql-statement sql-str mapping-schema)
        ]

    sql-str))




(defmethod p/gen-ksql p/gen-ksql-create-stream
  [m]
  ;(  m)
  (let [{:keys [name sink-name key fields]} m]
    (let [sql-column (str "( " (as-create-fields fields key (get m :type)) " )")
          source-name (clojure.string/upper-case sink-name)
          sink-name (clojure.string/upper-case sink-name)
          topic-name (or (get m :topic) source-name)
          value_format (get m :value_format "'AVRO'")

          ]
      (if (= "table" (get m :type))
        (list
          (str "CREATE TABLE " sink-name " " sql-column " " (make-with-clause topic-name value_format) ";")
          )
        (list
          (str "CREATE STREAM " sink-name " " sql-column " " (make-with-clause topic-name value_format) ";")
          )
        )

      )))



#_(ksql "CREATE TABLE net_policy_refined_by_local_policy_id AS
         SELECT local_policy_id, latest_by_offset(insurers_gross_policy_share) AS insurers_gross_policy_share,  latest_by_offset(underwriting_year) AS underwriting_year
         FROM net_policy_refined GROUP BY local_policy_id  EMIT CHANGES;")

;replicas


(defn get-sink-key [e-key-m sink-m]
  (let [sink-name (clojure.string/lower-case (get sink-m :sink-name))]
    (get e-key-m sink-name)))


(defn get-partition-key [mapping-schema]
  ;(p/log-v mapping-schema)
  (if (and (get-in mapping-schema [:key])
           (not (clojure.string/blank? (get-in mapping-schema [:key])))
           )
    (get-in mapping-schema [:key])
    (let [join (or (get mapping-schema :join)
                   (get mapping-schema :left_join)
                   )

          field-name (when-let [jk (nth join 1)]
                       (some-> (filter (fn [m]

                                         (clojure.string/includes? (pr-str m) jk)
                                         ) (get mapping-schema :fields))

                               (first)
                               (or {})
                               (get :name "")
                               (clojure.string/lower-case)
                               )
                       )
          ]
      field-name
      #_(when-not (= sink-key field-name)
        sink-key
        ;(str " PARTITION BY " (clojure.string/upper-case sink-key))
        )

      )

    )
  )





#_(defmethod p/gen-ksql "gen-ksql-stream-from-mapping2"
  [mapping-schema]


  ;(  mapping-schema)
  (let [sink-name (get mapping-schema :sink-name)

        all-transformation-fn (mapv (fn [m]
                                      (first (get m :transfer_fn))
                                      ) (:fields mapping-schema))
        ;  _ (println all-transformation-fn)
        staging? (if (every? #{"as"} all-transformation-fn) false true)

        ;   _ (  (get mapping-schema :key) )
        ;        source-type-m (get-source-type-m mapping-schema)

        partition-by (when-let [partition-key (get-partition-key mapping-schema)]
                       (str " PARTITION BY " (clojure.string/upper-case partition-key)))
        ;  fields (get mapping-schema :fields)
        _ (println "--" partition-by)

        ;
        source-name (clojure.string/upper-case (kutil/get-main-source-name mapping-schema))
        ;_ (println "---source name " source-name)
        ;  select-fields (do-fields-transformation-batch fields #_(get mapping-schema :fields))

        ;_ (println "--" select-fields)
        ;sql-str (str "SELECT " select-fields " FROM " source-name " " source-name)
        sql-str (build-select-statement mapping-schema)
        ]
    (if partition-by
      (if staging?
        [(str "CREATE STREAM " (clojure.string/upper-case (str sink-name "_stag")) " " (make-with-clause (str sink-name "_stag")) " as " sql-str ";")
         (str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name) " as select * from " (clojure.string/upper-case (str sink-name "_stag")) " " partition-by ";")]

        [

         (str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name) " as select * from " (clojure.string/upper-case source-name) " " partition-by ";")
         ]

        )


      [(str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name) " as " sql-str ";")]
      )

    )
  )

;(as->>)


(defmethod p/gen-ksql p/gen-ksql-stream-from-mapping
  [mapping-schema]
  ;"Not implement yet"

  (let [
        ;source-key (get mapping-schema :key)
        sink-name (clojure.string/upper-case (get mapping-schema :sink-name))


        sql-str (build-select-statement mapping-schema)



        partition-key (when-let [partition-key (get mapping-schema :key)]
                        ;(println "--" partition-key)
                        (some->> (get mapping-schema :fields)
                                 (reduce (fn [acc v]
                                           (if (= (get v :name) partition-key)
                                             (do
                                               ;(println "--" (ti/field-transformation (get v :transfer_fn)) "-" (get v :transfer_fn))
                                               ;(reduced (second (get v :transfer_fn)))

                                               (reduced  (ti/field-transformation (get v :transfer_fn)) #_(second (get v :transfer_fn)))
                                               )

                                             acc
                                             )
                                           ) "")
                                 ;(p/log-v)
                                 (ti/replace-forward-slap)
                                 (clojure.string/upper-case)
                                 (str " PARTITION BY ")))]

    (if partition-key
      [(str "CREATE STREAM " sink-name " " (make-with-clause sink-name) " AS " sql-str " " partition-key ";")]
      [(str "CREATE STREAM " sink-name " " (make-with-clause sink-name) " AS " sql-str ";")])))


(defmethod p/gen-ksql p/gen-ksql-stream-insert-from-mapping
  [mapping-schema]
  (let [sink-name (clojure.string/upper-case (get mapping-schema :sink-name))
        partition-by (when-let [partition-key (get-partition-key mapping-schema)]
                       (some->> (get mapping-schema :fields)
                                (reduce (fn [acc v]
                                          (if (= (get v :name) partition-key)
                                            (reduced  (ti/field-transformation (get v :transfer_fn)) #_(second (get v :transfer_fn)))
                                            ;(reduced (second (get v :transfer_fn)))
                                            acc
                                            )
                                          ) "")
                                (ti/replace-forward-slap)
                                (clojure.string/upper-case)
                                (str " PARTITION BY "))

                       #_(let [partition-key (ti/replace-forward-slap partition-key)]
                         (str " PARTITION BY " (clojure.string/upper-case partition-key))))
       ; _ (println "--" partition-by)
        sql-str (build-select-statement mapping-schema)]
    (if partition-by
      [(str "INSERT INTO " (clojure.string/upper-case sink-name) " " sql-str " " partition-by ";")]
      [(str "INSERT INTO " (clojure.string/upper-case sink-name) " " sql-str ";")])))


#_(defn create-rekey-stream-statement [entity-schema sink-name source-name source-key]
    ;(println)
    (let []
      (str "CREATE STREAM " sink-name " " (make-with-clause sink-name) " AS SELECT * FROM " source-name " PARTITION BY " source-key " ;")))


(defmethod p/gen-ksql p/gen-ksql-rekey-stream-from-mapping [entity-schema]
  ;(  entity-schema)
  ;(println "------------" (get entity-schema :key))
  (let [sink-key (get entity-schema :key)
        sink-name (get entity-schema :sink-name)
        source-name (first (get entity-schema :source-name))

        fields (get entity-schema :fields)
        fields (into [] (drop 2 fields))
        ;    fields-str (as-create-fields fields)
        ;_ (println fields-str)
        sink-name (clojure.string/upper-case sink-name)
        source-name (clojure.string/upper-case source-name)
        source-key (clojure.string/upper-case sink-key)]

    [
     ;(create-rekey-stream-statement entity-schema sink-name source-name sink-key)
     (str "CREATE STREAM " sink-name " " (make-with-clause sink-name) " AS SELECT * FROM " source-name " PARTITION BY " source-key " ;")
     ]

    ))




(defmethod p/gen-ksql p/gen-ksql-table-from-stream-after-rekey
  [table-schema]
  ;"Not implement yet"

  (let [
        source-key (clojure.string/upper-case (get table-schema :key))
        sink-name (clojure.string/upper-case (get table-schema :sink-name))

        ; source-name (first (get table-schema :source-name))
        fields (get table-schema :fields)

        source-name (clojure.string/upper-case (kutil/get-main-source-name table-schema))

        ;        sql-str (build-select-statement table-schema)

        table-fields-v (into [] (comp
                                  (remove (fn [field]
                                            ;(println "--" source-key "--" (get field :name))
                                            (= (clojure.string/lower-case source-key) (clojure.string/lower-case (get field :name)))
                                            ))
                                  (map (fn [field]
                                         (str "latest_by_offset ( " (get field :name) " ) as " (get field :name))
                                         ))) fields)
        table-fields-v (clojure.string/join "," table-fields-v)
        table-fields-v (str source-key ", " table-fields-v)
        ;value_format (get entity-schema :value_format "AVRO")
        ]

    (vector

      (str "CREATE TABLE " sink-name " " (make-with-clause sink-name) " AS select " table-fields-v " from " source-name " GROUP BY " source-key "  ;")
      )

    )

  )





(defmethod p/gen-ksql p/gen-ksql-create-table-as
  [mapping-schema]
  ;"Not implement yet"

  (let [source-key (get mapping-schema :key)
        sink-name (clojure.string/upper-case (get mapping-schema :sink-name))


        sql-str (build-select-statement mapping-schema)

        ;partition-key
        #_(reduce (fn [acc v]
                    (if (= (get v :name) source-key)
                      (reduced (second (get v :transfer_fn)))
                      acc
                      )
                    ) "" (get mapping-schema :fields))

        ;  partition-key (ti/replace-forward-slap partition-key)
        ;   w (str " PARTITION BY " (clojure.string/upper-case partition-key))

        ]

    [(str "CREATE TABLE " sink-name " " (make-with-clause sink-name) " AS " sql-str " ;")]

    )

  )

#_(ksql "CREATE TABLE net_policy_refined_by_local_policy_id AS
         SELECT local_policy_id, latest_by_offset(insurers_gross_policy_share) AS insurers_gross_policy_share,  latest_by_offset(underwriting_year) AS underwriting_year
         FROM net_policy_refined GROUP BY local_policy_id  EMIT CHANGES;")


(defmethod p/gen-ksql p/gen-ksql-create-table
  [table-schema]
  ;"Not implement yet"
  ;(  table-schema)
  (let [source-key (get table-schema :key)
        sink-name (clojure.string/upper-case (get table-schema :sink-name))


        source-name (first (get table-schema :source-name))
        ;  _ (println "--" source-name)
        fields (get table-schema :fields)
        ;_ (  fields)
        sql-column (str "( " (as-create-fields fields source-key (get table-schema :type)) " )")
        ;sql-column (as-create-fields fields)
        value_format (get table-schema :value_format "'AVRO'")
        ]

    (vector

      ;[(str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name ) " as " sql-str " " partition-by ";")]

      ;(str "CREATE TABLE " source-name " " sql-column (make-with-clause source-staging-rekey source-key) " ;")

      (str "CREATE TABLE " sink-name " " sql-column (make-with-clause source-name value_format false) " ;")
      )
    #_(vector
        (str "CREATE TABLE " sink-name " AS  SELECT " field-str " FROM " source-name " GROUP BY " pk " EMIT CHANGES;")
        )

    ))







(defn as-select-fields [coll]
  (->> coll
       (mapv (fn [m]
               (let [n (get m :name)
                     alias (or (get m :aliases) n)
                     t (get-in m [:schema :type])]
                 (str " CAST ( " alias " AS " t " ) AS " n ""))))
       (clojure.string/join ",")
       (clojure.string/upper-case)))


(comment

  (as-select-fields (list {:name "name", :schema {:type "STRING"} :aliases "este"}
                          {:name "surname", :schema {:type "STRING"}}
                          {:name "gender", :schema {:type "STRING"}}))

  )


(defn stream-rekey [{:keys [topic key fields from-topic type]}]
  (if from-topic
    (if (= type "TABLE")
      (let [sql-column (str "( " (as-create-fields fields) " )")]
        (str "CREATE TABLE " topic " " sql-column " WITH (kafka_topic='" from-topic "', value_format='AVRO',KEY='" (clojure.string/upper-case key) "');"))
      (let [sql-colum (str "( " (as-select-fields fields) " )")]
        (str "CREATE STREAM " topic " AS SELECT " sql-colum " FROM " from-topic " PARTITION BY " (clojure.string/upper-case key) ";")))
    (let [sql-column (str "( " (as-create-fields fields) " )")]
      (str "CREATE STREAM " topic " " sql-column " WITH (kafka_topic='" topic "', value_format='AVRO');"))))


#_(defn as-ksql-schema [coll]
    (into [] (comp (map stream-rekey)
                   ) coll))


#_(defn topic-to-table [key topic-name]
    (let [stream-name (clojure.string/upper-case topic-name)
          stream-in (str stream-name "_IN")
          stream-rekey-name (str stream-name "_RE")
          table-name (str stream-name "_TB")
          key (clojure.string/upper-case key)]
      (vector
        (str "CREATE STREAM " stream-in "  WITH (kafka_topic='" topic-name "', value_format='AVRO');")
        (str "CREATE STREAM " stream-rekey-name " AS SELECT * FROM " stream-in " PARTITION BY " key ";")
        (str "CREATE TABLE " table-name "  WITH (kafka_topic='" stream-rekey-name "', value_format='AVRO', KEY='" key "');"))))



#_(defn topic-source-name-ksql [sql-str]
    (if-let [w (second (clojure.string/split sql-str #"KAFKA_TOPIC"))]
      (some-> (clojure.string/split w #",")
              (first)
              (clojure.string/split #"=")
              (second)
              (clojure.string/trim)
              (clojure.string/replace #"'" ""))
      (some-> (clojure.string/split sql-str #"kafka_topic")
              (second)
              (clojure.string/split #",")
              (first)
              (clojure.string/split #"=")
              (second)
              (clojure.string/trim)
              (clojure.string/replace #"'" ""))))

#_(defn topic-source-name-ksql-batch [sql-coll]
    (into #{} (comp (map topic-source-name-ksql) (remove nil?)) sql-coll))



