(ns ksql.gen-connector
  (:require [cheshire.core :as json]
            [ksql.gen.protocol :as p]
            [ksql.gen.connector.core :as c]
            [ksql.gen.emitter.ksql :as eksql]
            ;[ksql.client :as client]
          ;  [ksql.metadata-api :as md]
            [ksql.gen.connector.config-generator]
            [ksql.gen.reader.csv-data-reader :as r]
            [ksql.gen.file-util :as fio]))



;;;@todo this need to be override with file-path-extension using csv or json or anything else
(defn assoc-field-schema [e]
  (let [config (get e :connector)
        file-path (get e :file-path)
        fields (->> (r/read-header config file-path)
                    (mapv (fn [v]
                            {:name v, :schema {:type "string"}})))
        ]
    (assoc e :fields fields)))





(defn gen-source-connector-config [context connector-mapping]
  (let [base-dir (get context :base-dir "")
        xf (comp
             (map assoc-field-schema)
             (map p/gen-connector))]
    (->> (c/as-source-connector-schema base-dir connector-mapping)
         (into [] xf))))


(comment

  (->> (gen-source-connector-config "app/azben/" [["mapping/config/csv_source.json" "data/source/raw_bnl_claim.csv"]])

       )

  )



(defn get-source-connector-names [context connector-mapping]
  (let [base-dir (get context :base-dir "")
        req-coll (c/as-source-connector-schema base-dir connector-mapping)]
    (into [] (comp
               ;(map (fn [m] (if schema-enable (assoc-file-schema m) m) ))
               (map p/gen-connector #_(fn [m]
                                        (p/gen-connector (get m :connector)
                                                         (get m :connector_source)
                                                         m)))
               (map :name)
               ) req-coll)
    )

  )



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Sink connector ;;;;;;;;;;;;;;;;;;;;;;;;











#_(defn convert-schema-to-rekey-schema [topic-schema sink-schema]
  (let [fields (get topic-schema :fields)
        source-name (get topic-schema :name)
        fields (mapv (fn [f]
                       (assoc f :transfer_fn ["as" (str source-name "/" (get f :name))])
                       ) fields)
        keys (get sink-schema :key)


        ffield (cond
                 (or (nil? keys) (empty? keys))
                 (let [tf (into ["hash"] (comp (map (fn [m]
                                                      ["cast" (str source-name "/" (get m :name)) " string"]
                                                      ))) fields)]
                   {:name        "P_ROWID"
                    :schema      {:type "string"}
                    :transfer_fn tf})

                 (sequential? keys)
                 (let [tf (into ["gen_id"] (comp (map (fn [m]
                                                        (str source-name "/" m)
                                                        ))) keys)
                       v (clojure.string/join "_" keys)]
                   {:name        v
                    :schema      {:type "string"}
                    :transfer_fn tf})
                 :else
                 {})

        f-name (get ffield :name keys)
        new-name (clojure.string/lower-case (str (get topic-schema :name) "_by_" f-name))

        fields (into [ffield] fields)]
    (assoc topic-schema :fields fields
                        :key f-name
                        :sink-name new-name
                        :ksql-gen-type p/gen-ksql-stream-from-mapping
                        :source-name [(get topic-schema :name)])))


#_(defn apply-rekey? [schema-m sink-schema-m]
  ;(println "--" (get-in schema-m [(get sink-schema-m :entity_name) :key]))
  ;  (println "-- " (get sink-schema-m :key))
  ;(  sink-schema-m)
  ;(println "--------------------" (keys schema-m))
  ;(  (get-in schema-m [(get sink-schema-m :entity_name) ]))
  (if (and (= "io.confluent.connect.jdbc.JdbcSinkConnector"
              (get-in sink-schema-m [:template :config :connector.class]))
           (not= (get sink-schema-m :key)
                 (get-in schema-m [(clojure.string/lower-case (get sink-schema-m :entity_name)) :key]))
           )
    true
    false

    )
  )



#_(defn update-sink-connector-mapping [context connector-mapping-coll]
  (let [schema-m (md/get-ksqldb-schema context)]
    (loop [[m & connector-mapping-coll] connector-mapping-coll
           connector-schema-coll []
           stream-schema-coll []]
      (if (nil? m)
        [connector-schema-coll stream-schema-coll]
        (let [;[m] (conn/as-sink-connector-schema base-dir [connector-connector])
              [connector-schema-temp stream-schema-temp] (if (apply-rekey? schema-m m)
                                                           (let [topic-schema-m (get-in schema-m [(get m :entity_name)])
                                                                 s (convert-schema-to-rekey-schema topic-schema-m m)
                                                                 sink-connector (-> (assoc m :entity_name (get s :sink-name))
                                                                                    (assoc :key (get s :key))
                                                                                    )]
                                                             ;      (println "--after apply rekey ")
                                                             [sink-connector s])
                                                           [m]
                                                           )
              connector-schema-coll (conj connector-schema-coll connector-schema-temp)
              stream-schema-coll (if stream-schema-temp (conj stream-schema-coll stream-schema-temp) stream-schema-coll)]
          (recur connector-mapping-coll connector-schema-coll stream-schema-coll))))))




(defn gen-sink-connector-config

  [context  sink-connector-mapping]
  (let [base-dir (get context :base-dir "")

        sink-connector-mapping (c/as-sink-connector-schema base-dir sink-connector-mapping)

      ;  [connector-schema stream-schema] (update-sink-connector-mapping context sink-connector-mapping)
        ; _ (  connector-schema)
       ; ksql-coll (eksql/emit-ksql context stream-schema)

        conn-coll (mapv p/gen-connector sink-connector-mapping)
        ]

    conn-coll
   ; [conn-coll ksql-coll]

    )
  )