(ns ksql.gen.util
  (:require [clojure.tools.reader.edn :as edn])
  )




(defn is-process-string? [v]
  (when v
    (clojure.string/includes? v ")")
    )

  )

(defn is-namespace? [v]
  (if (and (string? v)
           (not (clojure.string/starts-with? v "'"))
           )
    (let [out (->> (re-seq #"(\w+)/(\w+)" v)
                   (apply concat))]

      (if (empty? out)
        false
        true

        )
      )
    false))


(defn is-digit? [v]
  (try
    (number? (edn/read-string (pr-str v)))
    (catch Exception e
      (do
        ; (println "--exectp" v)
        false)))



  #_(if (re-find (re-pattern "\\d+") v)
      true false))


(defn is-transformation? [v]
  (if (and (string? v)
           (clojure.string/starts-with? (clojure.string/trim v) "(")
           (clojure.string/ends-with? (clojure.string/trim v) ")")

           )
    true false

    ))

(defn get-source-schema [ksqldb-schema-m-coll source-name]

  (reduce (fn [acc schema]
            (if (= (get schema :sink-name) source-name)
              (reduced schema)
              acc
              )
            ) nil ksqldb-schema-m-coll )
  )


(comment

  (is-transformation? "test")

  (is-transformation? "(test")

  (is-transformation? "(test)")

  )



(defn get-source-name2 [fields]
  ;(  fields)
  (->> fields
       (mapv :transfer_fn)
       (mapv rest)
       (flatten)
       (filter is-namespace?)
       (mapv (fn [v] (first (clojure.string/split v #"/"))))
       (flatten)
       (remove nil?)
       (distinct)
       (map clojure.string/lower-case)
       (into [])))


(defn get-source-name-from-fields [fields]
  (->> fields
       (mapv :transfer_fn)
       (mapv rest)
       (flatten)
       (filter is-namespace?)
       #_(filter (fn [v]
                 (clojure.string/includes? v "/")
                 ))
       (mapv (fn [v] (first (clojure.string/split v #"/"))))
       (remove (fn [v]
                 (= "'" v)

                 ))

       (flatten)
       (into #{})))

#_(defn get-source-name-from-join [join]
  (when join
    (-> (nth join 1)
        (clojure.string/split #"/")
        (first)
        )
    #_(->> join
           (filter (fn [v]
                     (clojure.string/includes? v "/")
                     ))
           (mapv (fn [v] (first (clojure.string/split v #"/"))))
           (flatten)
           (into #{})
           )

    )

  )


(defn get-main-source-name [m]
  ;(println ";;;;;;;;;;;;;;;;;;")
  ;(  m)
  (let [source-name (get-source-name-from-fields (:fields m))
        ;_ (println "--" source-name)
        source-name (if-let [w (get m :join) #_(or  (get m :left_join))]



                      (let [[j-type f-source j-source] (first w)  #_(kutil/get-source-name-from-join w)
                            f-source-name (first (clojure.string/split f-source #"/"))
                            j-source-name (first (clojure.string/split j-source #"/"))]

                        ;(println "--join source name " w)
                        ;   (conj source-name w)
                        (conj (disj source-name j-source-name) f-source-name) )
                      source-name)]
    ;(println "--" source-name)

    (if-let [w (->> source-name
                    (remove nil?)
                    (first)
                    )]
      (clojure.string/lower-case w)
      nil
      )
    ))


(defn get-all-source-name [m]
  ;(println ";;;;;;;;;;;;;;;;;;")
  ;(  m)
  (let [source-name (get-source-name-from-fields (:fields m))
        ;_ (println "--" source-name)

        source-name (if-let [w (get m :join) #_(or  (get m :left_join))]
                      (reduce (fn [acc j]
                                (let [[j-type f-source j-source] j
                                      f-source-name (first (clojure.string/split f-source #"/"))
                                      j-source-name (first (clojure.string/split j-source #"/"))]

                                  ;   (println "--join source name " j-source-name "--" f-source-name)
                                  ;   (conj source-name w)
                                  (conj acc f-source-name j-source-name) )
                                ) source-name w )

                      source-name)]
    ;(println "--" source-name)

    (if-let [w (->> source-name
                    (remove nil?)
                    (into [])
                  ;  (first)
                    )]
      w
      ;(clojure.string/upper-case w)
      nil
      )
    ))


(comment


  (get-all-source-name {:left_join   ["left_join" "cust_raw/id" "cust_stage_tab/id"],
                        :sink-name   "cust_raw_enrich",
                        :source-name ["cust_raw" "cust_stage_tab"],
                        :fields
                                     [{:name "id",
                          :source-type "string",
                          :schema {:type "string", },
                          :transfer_fn ["as" "cust_raw/id"]}
                         {:name "name",
                          :source-type "string",
                          :schema {:type "string", },
                          :transfer_fn ["as" "cust_raw/name"]}],
                        :type        "stream"})



  )

(defn get-source-entity-name-from-sink-schema [source-name-list sink-schema]

  ; (  source-list)

  (let [remote-source-name (get sink-schema :source-name)]
    (if-not (empty? remote-source-name)
      remote-source-name
      (into [] (comp (map :queryString)
                     (map (fn [v]
                            ;(println "--- v" v)
                            (let [v (-> (clojure.string/trim v)
                                        (clojure.string/split #"FROM")
                                        (last))


                                  ;v (if r r f)

                                  ]
                              (if (< 1 (count source-name-list))
                                (-> (first (clojure.string/split v #"ON"))
                                    ;  (p/log-v)
                                    (clojure.string/replace "LEFT OUTER JOIN" "")
                                    (clojure.string/replace "\n" "")
                                    (clojure.string/split #" ")
                                    (distinct)
                                    )

                                (-> v
                                    (clojure.string/trim)
                                    (clojure.string/split #" ")
                                    (first)
                                    (vector)
                                    )

                                )

                              )

                            ))
                     cat
                     (remove clojure.string/blank?)
                     (map clojure.string/lower-case)
                     ) (:writeQueries sink-schema))
      )

    )

  )

