(ns ksql.ingestion-api
  (:require [ksql.ingestion-api-impl :as di]

           [ksql.gen.protocol :as p]
           [ksql.ksqldb-api :as kapi]
           [cheshire.core :as json]
           [ksql.gen-api :as gapi]
           [ksql.core :as core]))


(defn invoke-dataflow
  [op-name request]
  (p/invoke-dataflow-impl op-name (core/get-context) request))


(defn reset-schema-m []
  (update (core/get-context) :mapping-schema (fn [v-atom]
                                               (reset! v-atom []))))



(defn export-ksql-to-file
  "Export generated KSQL statement to file
  file-name: Saving file name
  mapping: Mapping file or mapping as data
  "
  [file-name mapping]
  (let [o (gapi/gen-ksql-by-mapping mapping)
        o (clojure.string/join "\n" o)]
    (spit file-name o :append true)))


(defn import-ksql-from-file
  "Import KSQl to KSQl server after apply delta "
  [file-name]
  (->> (clojure.string/split (slurp file-name) #"\n")
       (remove (fn [v] (clojure.string/blank? v)))
       (vec)
       (di/push-ksql-statement (core/get-context))))



